/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.PlayerSpawnInfo;

public class ClientboundRespawnPacket
implements MinecraftPacket {
    private static final byte KEEP_ATTRIBUTE_MODIFIERS = 1;
    private static final byte KEEP_ENTITY_DATA = 2;
    private final PlayerSpawnInfo commonPlayerSpawnInfo;
    private final boolean keepMetadata;
    private final boolean keepAttributeModifiers;

    public ClientboundRespawnPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.commonPlayerSpawnInfo = helper.readPlayerSpawnInfo(in);
        byte dataToKeep = in.readByte();
        this.keepAttributeModifiers = (dataToKeep & 1) != 0;
        this.keepMetadata = (dataToKeep & 2) != 0;
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writePlayerSpawnInfo(out, this.commonPlayerSpawnInfo);
        int dataToKeep = 0;
        if (this.keepMetadata) {
            dataToKeep = (byte)(dataToKeep + 2);
        }
        if (this.keepAttributeModifiers) {
            dataToKeep = (byte)(dataToKeep + 1);
        }
        out.writeByte(dataToKeep);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public PlayerSpawnInfo getCommonPlayerSpawnInfo() {
        return this.commonPlayerSpawnInfo;
    }

    public boolean isKeepMetadata() {
        return this.keepMetadata;
    }

    public boolean isKeepAttributeModifiers() {
        return this.keepAttributeModifiers;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundRespawnPacket)) {
            return false;
        }
        ClientboundRespawnPacket other = (ClientboundRespawnPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isKeepMetadata() != other.isKeepMetadata()) {
            return false;
        }
        if (this.isKeepAttributeModifiers() != other.isKeepAttributeModifiers()) {
            return false;
        }
        PlayerSpawnInfo this$commonPlayerSpawnInfo = this.getCommonPlayerSpawnInfo();
        PlayerSpawnInfo other$commonPlayerSpawnInfo = other.getCommonPlayerSpawnInfo();
        return !(this$commonPlayerSpawnInfo == null ? other$commonPlayerSpawnInfo != null : !((Object)this$commonPlayerSpawnInfo).equals(other$commonPlayerSpawnInfo));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundRespawnPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isKeepMetadata() ? 79 : 97);
        result = result * 59 + (this.isKeepAttributeModifiers() ? 79 : 97);
        PlayerSpawnInfo $commonPlayerSpawnInfo = this.getCommonPlayerSpawnInfo();
        result = result * 59 + ($commonPlayerSpawnInfo == null ? 43 : ((Object)$commonPlayerSpawnInfo).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundRespawnPacket(commonPlayerSpawnInfo=" + this.getCommonPlayerSpawnInfo() + ", keepMetadata=" + this.isKeepMetadata() + ", keepAttributeModifiers=" + this.isKeepAttributeModifiers() + ")";
    }

    public @NonNull ClientboundRespawnPacket withCommonPlayerSpawnInfo(PlayerSpawnInfo commonPlayerSpawnInfo) {
        return this.commonPlayerSpawnInfo == commonPlayerSpawnInfo ? this : new ClientboundRespawnPacket(commonPlayerSpawnInfo, this.keepMetadata, this.keepAttributeModifiers);
    }

    public @NonNull ClientboundRespawnPacket withKeepMetadata(boolean keepMetadata) {
        return this.keepMetadata == keepMetadata ? this : new ClientboundRespawnPacket(this.commonPlayerSpawnInfo, keepMetadata, this.keepAttributeModifiers);
    }

    public @NonNull ClientboundRespawnPacket withKeepAttributeModifiers(boolean keepAttributeModifiers) {
        return this.keepAttributeModifiers == keepAttributeModifiers ? this : new ClientboundRespawnPacket(this.commonPlayerSpawnInfo, this.keepMetadata, keepAttributeModifiers);
    }

    public ClientboundRespawnPacket(PlayerSpawnInfo commonPlayerSpawnInfo, boolean keepMetadata, boolean keepAttributeModifiers) {
        this.commonPlayerSpawnInfo = commonPlayerSpawnInfo;
        this.keepMetadata = keepMetadata;
        this.keepAttributeModifiers = keepAttributeModifiers;
    }
}

