/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.handshake.serverbound;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.data.handshake.HandshakeIntent;

public class ClientIntentionPacket
implements MinecraftPacket {
    private final int protocolVersion;
    @lombok.NonNull
    private final String hostname;
    private final int port;
    @lombok.NonNull
    private final HandshakeIntent intent;

    public ClientIntentionPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.protocolVersion = helper.readVarInt(in);
        this.hostname = helper.readString(in);
        this.port = in.readUnsignedShort();
        this.intent = HandshakeIntent.from(helper.readVarInt(in) - 1);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writeVarInt(out, this.protocolVersion);
        helper.writeString(out, this.hostname);
        out.writeShort(this.port);
        helper.writeVarInt(out, this.intent.ordinal() + 1);
    }

    @Override
    public boolean isTerminal() {
        return true;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    @lombok.NonNull
    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    @lombok.NonNull
    public HandshakeIntent getIntent() {
        return this.intent;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientIntentionPacket)) {
            return false;
        }
        ClientIntentionPacket other = (ClientIntentionPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getProtocolVersion() != other.getProtocolVersion()) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        HandshakeIntent this$intent = this.getIntent();
        HandshakeIntent other$intent = other.getIntent();
        return !(this$intent == null ? other$intent != null : !((Object)((Object)this$intent)).equals((Object)other$intent));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientIntentionPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getProtocolVersion();
        result = result * 59 + this.getPort();
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        HandshakeIntent $intent = this.getIntent();
        result = result * 59 + ($intent == null ? 43 : ((Object)((Object)$intent)).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ClientIntentionPacket(protocolVersion=" + this.getProtocolVersion() + ", hostname=" + this.getHostname() + ", port=" + this.getPort() + ", intent=" + this.getIntent() + ")";
    }

    public @NonNull ClientIntentionPacket withProtocolVersion(int protocolVersion) {
        return this.protocolVersion == protocolVersion ? this : new ClientIntentionPacket(protocolVersion, this.hostname, this.port, this.intent);
    }

    public @NonNull ClientIntentionPacket withHostname(@lombok.NonNull String hostname) {
        if (hostname == null) {
            throw new NullPointerException("hostname is marked non-null but is null");
        }
        return this.hostname == hostname ? this : new ClientIntentionPacket(this.protocolVersion, hostname, this.port, this.intent);
    }

    public @NonNull ClientIntentionPacket withPort(int port) {
        return this.port == port ? this : new ClientIntentionPacket(this.protocolVersion, this.hostname, port, this.intent);
    }

    public @NonNull ClientIntentionPacket withIntent(@lombok.NonNull HandshakeIntent intent) {
        if (intent == null) {
            throw new NullPointerException("intent is marked non-null but is null");
        }
        return this.intent == intent ? this : new ClientIntentionPacket(this.protocolVersion, this.hostname, this.port, intent);
    }

    public ClientIntentionPacket(int protocolVersion, @lombok.NonNull String hostname, int port, @lombok.NonNull HandshakeIntent intent) {
        if (hostname == null) {
            throw new NullPointerException("hostname is marked non-null but is null");
        }
        if (intent == null) {
            throw new NullPointerException("intent is marked non-null but is null");
        }
        this.protocolVersion = protocolVersion;
        this.hostname = hostname;
        this.port = port;
        this.intent = intent;
    }
}

