/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.common.clientbound;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

public class ClientboundTransferPacket
implements MinecraftPacket {
    private final String host;
    private final int port;

    public ClientboundTransferPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.host = helper.readString(in);
        this.port = helper.readVarInt(in);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writeString(out, this.host);
        helper.writeVarInt(out, this.port);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return false;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundTransferPacket)) {
            return false;
        }
        ClientboundTransferPacket other = (ClientboundTransferPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        return !(this$host == null ? other$host != null : !this$host.equals(other$host));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundTransferPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPort();
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundTransferPacket(host=" + this.getHost() + ", port=" + this.getPort() + ")";
    }

    public @NonNull ClientboundTransferPacket withHost(String host) {
        return this.host == host ? this : new ClientboundTransferPacket(host, this.port);
    }

    public @NonNull ClientboundTransferPacket withPort(int port) {
        return this.port == port ? this : new ClientboundTransferPacket(this.host, port);
    }

    public ClientboundTransferPacket(String host, int port) {
        this.host = host;
        this.port = port;
    }
}

