/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol;

import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.Objects;
import java.util.UUID;
import lombok.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtUtils;
import org.geysermc.mcprotocollib.auth.GameProfile;
import org.geysermc.mcprotocollib.network.BuiltinFlags;
import org.geysermc.mcprotocollib.network.Server;
import org.geysermc.mcprotocollib.network.Session;
import org.geysermc.mcprotocollib.network.crypt.AESEncryption;
import org.geysermc.mcprotocollib.network.crypt.EncryptionConfig;
import org.geysermc.mcprotocollib.network.packet.PacketHeader;
import org.geysermc.mcprotocollib.network.packet.PacketProtocol;
import org.geysermc.mcprotocollib.network.packet.PacketRegistry;
import org.geysermc.mcprotocollib.protocol.ClientListener;
import org.geysermc.mcprotocollib.protocol.MinecraftConstants;
import org.geysermc.mcprotocollib.protocol.ServerListener;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodec;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.PacketCodec;
import org.geysermc.mcprotocollib.protocol.data.ProtocolState;
import org.geysermc.mcprotocollib.protocol.data.handshake.HandshakeIntent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinecraftProtocol
extends PacketProtocol {
    private static final Logger log = LoggerFactory.getLogger(MinecraftProtocol.class);
    private static @Nullable NbtMap DEFAULT_NETWORK_CODEC;
    private final PacketCodec codec;
    private ProtocolState inboundState;
    private PacketRegistry inboundStateRegistry;
    private ProtocolState outboundState;
    private PacketRegistry outboundStateRegistry;
    private final HandshakeIntent handshakeIntent;
    private GameProfile profile;
    private String accessToken;
    private boolean useDefaultListeners = true;

    public MinecraftProtocol() {
        this(MinecraftCodec.CODEC);
    }

    public MinecraftProtocol(PacketCodec codec) {
        this.codec = codec;
        this.handshakeIntent = HandshakeIntent.STATUS;
        this.resetStates();
    }

    public MinecraftProtocol(@NonNull String username) {
        this(new GameProfile(UUID.randomUUID(), username), null);
        if (username == null) {
            throw new NullPointerException("username is marked non-null but is null");
        }
    }

    public MinecraftProtocol(@NonNull PacketCodec codec, @NonNull String username) {
        this(codec, new GameProfile(UUID.randomUUID(), username), null);
        if (codec == null) {
            throw new NullPointerException("codec is marked non-null but is null");
        }
        if (username == null) {
            throw new NullPointerException("username is marked non-null but is null");
        }
    }

    public MinecraftProtocol(@NonNull GameProfile profile, String accessToken) {
        this(MinecraftCodec.CODEC, profile, accessToken);
        if (profile == null) {
            throw new NullPointerException("profile is marked non-null but is null");
        }
    }

    public MinecraftProtocol(@NonNull PacketCodec codec, @NonNull GameProfile profile, String accessToken) {
        if (codec == null) {
            throw new NullPointerException("codec is marked non-null but is null");
        }
        if (profile == null) {
            throw new NullPointerException("profile is marked non-null but is null");
        }
        this.codec = codec;
        this.handshakeIntent = HandshakeIntent.LOGIN;
        this.profile = profile;
        this.accessToken = accessToken;
        this.resetStates();
    }

    @Override
    public String getSRVRecordPrefix() {
        return "_minecraft";
    }

    @Override
    public PacketHeader getPacketHeader() {
        return MinecraftConstants.PACKET_HEADER;
    }

    @Override
    public MinecraftCodecHelper createHelper() {
        return this.codec.getHelperFactory().get();
    }

    @Override
    public void newClientSession(Session session) {
        session.setFlag(MinecraftConstants.PROFILE_KEY, this.profile);
        session.setFlag(MinecraftConstants.ACCESS_TOKEN_KEY, this.accessToken);
        this.resetStates();
        if (this.useDefaultListeners) {
            session.addListener(new ClientListener(this.handshakeIntent == HandshakeIntent.LOGIN && session.getFlag(BuiltinFlags.CLIENT_TRANSFERRING, false) != false ? HandshakeIntent.TRANSFER : this.handshakeIntent));
        }
    }

    @Override
    public void newServerSession(Server server, Session session) {
        this.resetStates();
        if (this.useDefaultListeners) {
            if (DEFAULT_NETWORK_CODEC == null) {
                DEFAULT_NETWORK_CODEC = MinecraftProtocol.loadNetworkCodec();
            }
            session.addListener(new ServerListener(DEFAULT_NETWORK_CODEC));
        }
    }

    @Override
    public PacketRegistry getInboundPacketRegistry() {
        return this.inboundStateRegistry;
    }

    @Override
    public PacketRegistry getOutboundPacketRegistry() {
        return this.outboundStateRegistry;
    }

    protected EncryptionConfig createEncryption(Key key) {
        try {
            return new EncryptionConfig(new AESEncryption(key));
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException("Failed to create protocol encryption.", e);
        }
    }

    public void resetStates() {
        this.setInboundState(ProtocolState.HANDSHAKE);
        this.setOutboundState(ProtocolState.HANDSHAKE);
    }

    public ProtocolState getInboundState() {
        return this.inboundState;
    }

    public ProtocolState getOutboundState() {
        return this.outboundState;
    }

    public void setInboundState(ProtocolState state) {
        log.debug("Setting inbound protocol state to: {}", (Object)state);
        this.inboundState = state;
        this.inboundStateRegistry = this.codec.getCodec(state);
    }

    public void setOutboundState(ProtocolState state) {
        log.debug("Setting outbound protocol state to: {}", (Object)state);
        this.outboundState = state;
        this.outboundStateRegistry = this.codec.getCodec(state);
    }

    public static NbtMap loadNetworkCodec() {
        NbtMap nbtMap;
        block8: {
            InputStream inputStream = Objects.requireNonNull(MinecraftProtocol.class.getClassLoader().getResourceAsStream("networkCodec.nbt"));
            try {
                nbtMap = (NbtMap)NbtUtils.createGZIPReader((InputStream)inputStream).readTag(512);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AssertionError("Unable to load network codec.", e);
                }
            }
            inputStream.close();
        }
        return nbtMap;
    }

    public PacketCodec getCodec() {
        return this.codec;
    }

    public GameProfile getProfile() {
        return this.profile;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public boolean isUseDefaultListeners() {
        return this.useDefaultListeners;
    }

    public void setUseDefaultListeners(boolean useDefaultListeners) {
        this.useDefaultListeners = useDefaultListeners;
    }
}

