/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.network;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.network.Flag;
import org.geysermc.mcprotocollib.network.codec.PacketCodecHelper;
import org.geysermc.mcprotocollib.network.compression.CompressionConfig;
import org.geysermc.mcprotocollib.network.crypt.EncryptionConfig;
import org.geysermc.mcprotocollib.network.event.session.SessionEvent;
import org.geysermc.mcprotocollib.network.event.session.SessionListener;
import org.geysermc.mcprotocollib.network.netty.FlushHandler;
import org.geysermc.mcprotocollib.network.packet.Packet;
import org.geysermc.mcprotocollib.network.packet.PacketProtocol;

public interface Session {
    public SocketAddress getLocalAddress();

    public SocketAddress getRemoteAddress();

    public PacketProtocol getPacketProtocol();

    public PacketCodecHelper getCodecHelper();

    public Map<String, Object> getFlags();

    public boolean hasFlag(Flag<?> var1);

    default public <T> T getFlag(Flag<T> flag) {
        return (T)this.getFlagSupplied(flag, () -> null);
    }

    default public <T> T getFlag(Flag<T> flag, T def) {
        return (T)this.getFlagSupplied(flag, () -> def);
    }

    public <T> T getFlagSupplied(Flag<T> var1, Supplier<T> var2);

    public <T> void setFlag(Flag<T> var1, T var2);

    public void setFlags(Map<String, Object> var1);

    public List<SessionListener> getListeners();

    public void addListener(SessionListener var1);

    public void removeListener(SessionListener var1);

    public void callEvent(SessionEvent var1);

    public void callPacketReceived(Packet var1);

    public void callPacketSent(Packet var1);

    public void setCompression(@Nullable CompressionConfig var1);

    public void setEncryption(@Nullable EncryptionConfig var1);

    public boolean isConnected();

    default public void send(@NonNull Packet packet) {
        this.send(packet, null);
    }

    public void send(@NonNull Packet var1, @Nullable Runnable var2);

    default public void disconnect(@NonNull String reason) {
        this.disconnect(reason, null);
    }

    default public void disconnect(@NonNull String reason, @Nullable Throwable cause) {
        this.disconnect((Component)Component.text((String)reason), cause);
    }

    default public void disconnect(@NonNull Component reason) {
        this.disconnect(reason, null);
    }

    public void disconnect(@NonNull Component var1, @Nullable Throwable var2);

    public void setAutoRead(boolean var1);

    public Channel getChannel();

    public Executor getPacketHandlerExecutor();

    default public void switchInboundState(Runnable switcher) {
        switcher.run();
        this.setAutoRead(true);
    }

    default public void switchOutboundState(Runnable switcher) {
        this.getChannel().writeAndFlush((Object)FlushHandler.FLUSH_PACKET).syncUninterruptibly();
        switcher.run();
    }
}

