/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.auth;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.geysermc.mcprotocollib.auth.SessionService;
import org.geysermc.mcprotocollib.auth.util.TextureUrlChecker;
import org.geysermc.mcprotocollib.auth.util.UndashedUUIDAdapter;

public class GameProfile {
    private static final PublicKey SIGNATURE_KEY = GameProfile.loadSignatureKey();
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(UUID.class, (Object)new UndashedUUIDAdapter()).create();
    private final UUID id;
    private final String name;
    private List<Property> properties;
    private Map<TextureType, Texture> textures;
    private boolean texturesVerified;

    private static PublicKey loadSignatureKey() {
        PublicKey publicKey;
        block8: {
            InputStream in = Objects.requireNonNull(SessionService.class.getResourceAsStream("/yggdrasil_session_pubkey.der"));
            try {
                publicKey = KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(in.readAllBytes()));
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("Missing/invalid yggdrasil public key.", e);
                }
            }
            in.close();
        }
        return publicKey;
    }

    public GameProfile(String id, String name) {
        this(id == null || id.isEmpty() ? null : UUID.fromString(id), name);
    }

    public GameProfile(UUID id, String name) {
        this.id = id;
        this.name = name;
    }

    public boolean isComplete() {
        return this.id != null && this.name != null && !this.name.isEmpty();
    }

    public UUID getId() {
        return this.id;
    }

    public String getIdAsString() {
        return this.id != null ? this.id.toString() : "";
    }

    public String getName() {
        return this.name;
    }

    public List<Property> getProperties() {
        if (this.properties == null) {
            this.properties = new ArrayList<Property>();
        }
        return Collections.unmodifiableList(this.properties);
    }

    public void setProperties(List<Property> properties) {
        if (this.properties == null) {
            this.properties = new ArrayList<Property>();
        } else {
            this.properties.clear();
        }
        if (properties != null) {
            this.properties.addAll(properties);
        }
        this.textures = null;
        this.texturesVerified = false;
    }

    public Property getProperty(String name) {
        for (Property property : this.getProperties()) {
            if (!property.getName().equals(name)) continue;
            return property;
        }
        return null;
    }

    public Map<TextureType, Texture> getTextures() throws IllegalStateException {
        return this.getTextures(true);
    }

    public Map<TextureType, Texture> getTextures(boolean requireSecure) throws IllegalStateException {
        if (this.textures == null || requireSecure && !this.texturesVerified) {
            Property textures = this.getProperty("textures");
            if (textures != null) {
                MinecraftTexturesPayload result;
                if (requireSecure) {
                    if (!textures.hasSignature()) {
                        throw new IllegalStateException("Signature is missing from textures payload.");
                    }
                    if (!textures.isSignatureValid(SIGNATURE_KEY)) {
                        throw new IllegalStateException("Textures payload has been tampered with. (signature invalid)");
                    }
                }
                try {
                    String json = new String(Base64.getDecoder().decode(textures.getValue().getBytes(StandardCharsets.UTF_8)));
                    result = (MinecraftTexturesPayload)GSON.fromJson(json, MinecraftTexturesPayload.class);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Could not decode texture payload.", e);
                }
                if (result != null && result.textures != null) {
                    if (requireSecure) {
                        for (Texture texture : result.textures.values()) {
                            if (TextureUrlChecker.isAllowedTextureDomain(texture.getURL())) continue;
                            throw new IllegalStateException("Textures payload has been tampered with. (non-whitelisted domain)");
                        }
                    }
                    this.textures = result.textures;
                } else {
                    this.textures = Collections.emptyMap();
                }
                this.texturesVerified = requireSecure;
            } else {
                return Collections.emptyMap();
            }
        }
        return Collections.unmodifiableMap(this.textures);
    }

    public Texture getTexture(TextureType type) throws IllegalStateException {
        return this.getTextures().get((Object)type);
    }

    public Texture getTexture(TextureType type, boolean requireSecure) throws IllegalStateException {
        return this.getTextures(requireSecure).get((Object)type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            GameProfile that = (GameProfile)o;
            return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name);
        }
        return false;
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "GameProfile{id=" + this.id + ", name=" + this.name + ", properties=" + this.getProperties() + "}";
    }

    public static class Property {
        private final String name;
        private final String value;
        private final String signature;

        public Property(String name, String value) {
            this(name, value, null);
        }

        public Property(String name, String value, String signature) {
            this.name = name;
            this.value = value;
            this.signature = signature;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public boolean hasSignature() {
            return this.signature != null;
        }

        public String getSignature() {
            return this.signature;
        }

        public boolean isSignatureValid(PublicKey key) throws IllegalStateException {
            if (!this.hasSignature()) {
                return false;
            }
            try {
                Signature sig = Signature.getInstance("SHA1withRSA");
                sig.initVerify(key);
                sig.update(this.value.getBytes());
                return sig.verify(Base64.getDecoder().decode(this.signature.getBytes(StandardCharsets.UTF_8)));
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not validate property signature.", e);
            }
        }

        public String toString() {
            return "Property{name=" + this.name + ", value=" + this.value + ", signature=" + this.signature + "}";
        }
    }

    private static class MinecraftTexturesPayload {
        public long timestamp;
        public UUID profileId;
        public String profileName;
        public boolean isPublic;
        public Map<TextureType, Texture> textures;

        private MinecraftTexturesPayload() {
        }
    }

    public static class Texture {
        private final String url;
        private final Map<String, String> metadata;

        public Texture(String url, Map<String, String> metadata) {
            this.url = url;
            this.metadata = metadata;
        }

        public String getURL() {
            return this.url;
        }

        public String getMetadata(String key) {
            if (this.metadata == null) {
                return null;
            }
            return this.metadata.get(key);
        }

        public TextureModel getModel() {
            String model = this.getMetadata("model");
            return model != null && model.equals("slim") ? TextureModel.SLIM : TextureModel.WIDE;
        }

        public String getHash() {
            String url = this.url.endsWith("/") ? this.url.substring(0, this.url.length() - 1) : this.url;
            int slash = url.lastIndexOf("/");
            int dot = url.lastIndexOf(".");
            if (dot < slash) {
                dot = url.length();
            }
            return url.substring(slash + 1, dot != -1 ? dot : url.length());
        }

        public String toString() {
            return "Texture{url=" + this.url + ", model=" + this.getModel() + ", hash=" + this.getHash() + "}";
        }
    }

    public static enum TextureModel {
        WIDE,
        SLIM;

    }

    public static enum TextureType {
        SKIN,
        CAPE,
        ELYTRA;

    }
}

