package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound;

import io.netty.buffer.ByteBuf;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NonNull;
import lombok.With;
import net.kyori.adventure.text.Component;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

@Data
@With
@AllArgsConstructor
public class ClientboundTabListPacket implements MinecraftPacket {
    private final @NonNull Component header;
    private final @NonNull Component footer;

    public ClientboundTabListPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.header = helper.readComponent(in);
        this.footer = helper.readComponent(in);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writeComponent(out, this.header);
        helper.writeComponent(out, this.footer);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }
}
