/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.status.serverbound;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import io.netty.buffer.ByteBuf;
import java.io.IOException;

public class ServerboundPingRequestPacket
implements MinecraftPacket {
    private final long pingTime;

    public ServerboundPingRequestPacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.pingTime = in.readLong();
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        out.writeLong(this.pingTime);
    }

    public long getPingTime() {
        return this.pingTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundPingRequestPacket)) {
            return false;
        }
        ServerboundPingRequestPacket other = (ServerboundPingRequestPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getPingTime() == other.getPingTime();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerboundPingRequestPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $pingTime = this.getPingTime();
        result = result * 59 + (int)($pingTime >>> 32 ^ $pingTime);
        return result;
    }

    public String toString() {
        return "ServerboundPingRequestPacket(pingTime=" + this.getPingTime() + ")";
    }

    public ServerboundPingRequestPacket withPingTime(long pingTime) {
        return this.pingTime == pingTime ? this : new ServerboundPingRequestPacket(pingTime);
    }

    public ServerboundPingRequestPacket(long pingTime) {
        this.pingTime = pingTime;
    }
}

