/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.serverbound.inventory;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import com.github.steveice10.mc.protocol.data.game.inventory.AdvancementTabAction;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import lombok.NonNull;

public class ServerboundSeenAdvancementsPacket
implements MinecraftPacket {
    @NonNull
    private final AdvancementTabAction action;
    private final String tabId;

    public ServerboundSeenAdvancementsPacket() {
        this.action = AdvancementTabAction.CLOSED_SCREEN;
        this.tabId = null;
    }

    public ServerboundSeenAdvancementsPacket(@NonNull String tabId) {
        if (tabId == null) {
            throw new NullPointerException("tabId is marked non-null but is null");
        }
        this.action = AdvancementTabAction.OPENED_TAB;
        this.tabId = tabId;
    }

    public String getTabId() {
        if (this.action != AdvancementTabAction.OPENED_TAB) {
            throw new IllegalStateException("tabId is only set if action is " + (Object)((Object)AdvancementTabAction.OPENED_TAB) + " but it was " + (Object)((Object)this.action));
        }
        return this.tabId;
    }

    public ServerboundSeenAdvancementsPacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.action = AdvancementTabAction.from(helper.readVarInt(in));
        switch (this.action) {
            case CLOSED_SCREEN: {
                this.tabId = null;
                break;
            }
            case OPENED_TAB: {
                this.tabId = helper.readString(in);
                break;
            }
            default: {
                throw new IOException("Unknown advancement tab action: " + (Object)((Object)this.action));
            }
        }
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        helper.writeVarInt(out, this.action.ordinal());
        switch (this.action) {
            case CLOSED_SCREEN: {
                break;
            }
            case OPENED_TAB: {
                helper.writeString(out, this.tabId);
                break;
            }
            default: {
                throw new IOException("Unknown advancement tab action: " + (Object)((Object)this.action));
            }
        }
    }

    public String toString() {
        return "ServerboundSeenAdvancementsPacket(action=" + (Object)((Object)this.getAction()) + ", tabId=" + this.getTabId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundSeenAdvancementsPacket)) {
            return false;
        }
        ServerboundSeenAdvancementsPacket other = (ServerboundSeenAdvancementsPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AdvancementTabAction this$action = this.getAction();
        AdvancementTabAction other$action = other.getAction();
        if (this$action == null ? other$action != null : !((Object)((Object)this$action)).equals((Object)other$action)) {
            return false;
        }
        String this$tabId = this.getTabId();
        String other$tabId = other.getTabId();
        return !(this$tabId == null ? other$tabId != null : !this$tabId.equals(other$tabId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerboundSeenAdvancementsPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AdvancementTabAction $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : ((Object)((Object)$action)).hashCode());
        String $tabId = this.getTabId();
        result = result * 59 + ($tabId == null ? 43 : $tabId.hashCode());
        return result;
    }

    @NonNull
    public AdvancementTabAction getAction() {
        return this.action;
    }
}

