/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound.scoreboard;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import com.github.steveice10.mc.protocol.data.game.scoreboard.ScoreboardAction;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import lombok.NonNull;

public class ClientboundSetScorePacket
implements MinecraftPacket {
    @NonNull
    private final String entry;
    @NonNull
    private final ScoreboardAction action;
    @NonNull
    private final String objective;
    private final int value;

    public ClientboundSetScorePacket(@NonNull String entry, @NonNull String objective) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        if (objective == null) {
            throw new NullPointerException("objective is marked non-null but is null");
        }
        this.entry = entry;
        this.action = ScoreboardAction.REMOVE;
        this.objective = objective;
        this.value = 0;
    }

    public ClientboundSetScorePacket(@NonNull String entry, @NonNull String objective, int value) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        if (objective == null) {
            throw new NullPointerException("objective is marked non-null but is null");
        }
        this.entry = entry;
        this.action = ScoreboardAction.ADD_OR_UPDATE;
        this.objective = objective;
        this.value = value;
    }

    public ClientboundSetScorePacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.entry = helper.readString(in);
        this.action = ScoreboardAction.from(helper.readVarInt(in));
        this.objective = helper.readString(in);
        this.value = this.action == ScoreboardAction.ADD_OR_UPDATE ? helper.readVarInt(in) : 0;
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        helper.writeString(out, this.entry);
        helper.writeVarInt(out, this.action.ordinal());
        helper.writeString(out, this.objective);
        if (this.action == ScoreboardAction.ADD_OR_UPDATE) {
            helper.writeVarInt(out, this.value);
        }
    }

    @NonNull
    public String getEntry() {
        return this.entry;
    }

    @NonNull
    public ScoreboardAction getAction() {
        return this.action;
    }

    @NonNull
    public String getObjective() {
        return this.objective;
    }

    public int getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundSetScorePacket)) {
            return false;
        }
        ClientboundSetScorePacket other = (ClientboundSetScorePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getValue() != other.getValue()) {
            return false;
        }
        String this$entry = this.getEntry();
        String other$entry = other.getEntry();
        if (this$entry == null ? other$entry != null : !this$entry.equals(other$entry)) {
            return false;
        }
        ScoreboardAction this$action = this.getAction();
        ScoreboardAction other$action = other.getAction();
        if (this$action == null ? other$action != null : !((Object)((Object)this$action)).equals((Object)other$action)) {
            return false;
        }
        String this$objective = this.getObjective();
        String other$objective = other.getObjective();
        return !(this$objective == null ? other$objective != null : !this$objective.equals(other$objective));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundSetScorePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getValue();
        String $entry = this.getEntry();
        result = result * 59 + ($entry == null ? 43 : $entry.hashCode());
        ScoreboardAction $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : ((Object)((Object)$action)).hashCode());
        String $objective = this.getObjective();
        result = result * 59 + ($objective == null ? 43 : $objective.hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundSetScorePacket(entry=" + this.getEntry() + ", action=" + (Object)((Object)this.getAction()) + ", objective=" + this.getObjective() + ", value=" + this.getValue() + ")";
    }

    public ClientboundSetScorePacket withEntry(@NonNull String entry) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        return this.entry == entry ? this : new ClientboundSetScorePacket(entry, this.action, this.objective, this.value);
    }

    public ClientboundSetScorePacket withAction(@NonNull ScoreboardAction action) {
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        return this.action == action ? this : new ClientboundSetScorePacket(this.entry, action, this.objective, this.value);
    }

    public ClientboundSetScorePacket withObjective(@NonNull String objective) {
        if (objective == null) {
            throw new NullPointerException("objective is marked non-null but is null");
        }
        return this.objective == objective ? this : new ClientboundSetScorePacket(this.entry, this.action, objective, this.value);
    }

    public ClientboundSetScorePacket withValue(int value) {
        return this.value == value ? this : new ClientboundSetScorePacket(this.entry, this.action, this.objective, value);
    }

    private ClientboundSetScorePacket(@NonNull String entry, @NonNull ScoreboardAction action, @NonNull String objective, int value) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        if (objective == null) {
            throw new NullPointerException("objective is marked non-null but is null");
        }
        this.entry = entry;
        this.action = action;
        this.objective = objective;
        this.value = value;
    }
}

