/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;

public class ClientboundUpdateTagsPacket
implements MinecraftPacket {
    @NonNull
    private final Map<String, Map<String, int[]>> tags = new HashMap<String, Map<String, int[]>>();

    public ClientboundUpdateTagsPacket(ByteBuf in, MinecraftCodecHelper helper) {
        int totalTagCount = helper.readVarInt(in);
        for (int i = 0; i < totalTagCount; ++i) {
            HashMap<String, int[]> tag = new HashMap<String, int[]>();
            String tagName = helper.readResourceLocation(in);
            int tagsCount = helper.readVarInt(in);
            for (int j = 0; j < tagsCount; ++j) {
                String name = helper.readResourceLocation(in);
                int entriesCount = helper.readVarInt(in);
                int[] entries = new int[entriesCount];
                for (int index = 0; index < entriesCount; ++index) {
                    entries[index] = helper.readVarInt(in);
                }
                tag.put(name, entries);
            }
            this.tags.put(tagName, tag);
        }
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writeVarInt(out, this.tags.size());
        for (Map.Entry<String, Map<String, int[]>> tagSet : this.tags.entrySet()) {
            helper.writeResourceLocation(out, tagSet.getKey());
            helper.writeVarInt(out, tagSet.getValue().size());
            for (Map.Entry<String, int[]> tag : tagSet.getValue().entrySet()) {
                helper.writeResourceLocation(out, tag.getKey());
                helper.writeVarInt(out, tag.getValue().length);
                for (int id : tag.getValue()) {
                    helper.writeVarInt(out, id);
                }
            }
        }
    }

    @NonNull
    public Map<String, Map<String, int[]>> getTags() {
        return this.tags;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundUpdateTagsPacket)) {
            return false;
        }
        ClientboundUpdateTagsPacket other = (ClientboundUpdateTagsPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, Map<String, int[]>> this$tags = this.getTags();
        Map<String, Map<String, int[]>> other$tags = other.getTags();
        return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundUpdateTagsPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Map<String, int[]>> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundUpdateTagsPacket(tags=" + this.getTags() + ")";
    }

    public ClientboundUpdateTagsPacket() {
    }
}

