/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.GlobalPos;
import com.github.steveice10.mc.protocol.data.game.entity.player.GameMode;
import io.netty.buffer.ByteBuf;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public class ClientboundRespawnPacket
implements MinecraftPacket {
    private static final byte KEEP_ATTRIBUTES = 1;
    private static final byte KEEP_ENTITY_DATA = 2;
    @NonNull
    private final String dimension;
    @NonNull
    private final String worldName;
    private final long hashedSeed;
    @NonNull
    private final GameMode gamemode;
    @Nullable
    private final GameMode previousGamemode;
    private final boolean debug;
    private final boolean flat;
    private final boolean keepMetadata;
    private final boolean keepAttributes;
    @Nullable
    private final GlobalPos lastDeathPos;
    private final int portalCooldown;

    public ClientboundRespawnPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.dimension = helper.readString(in);
        this.worldName = helper.readString(in);
        this.hashedSeed = in.readLong();
        this.gamemode = GameMode.byId(in.readUnsignedByte());
        this.previousGamemode = GameMode.byNullableId(in.readByte());
        this.debug = in.readBoolean();
        this.flat = in.readBoolean();
        byte dataToKeep = in.readByte();
        this.keepAttributes = (dataToKeep & 1) != 0;
        this.keepMetadata = (dataToKeep & 2) != 0;
        this.lastDeathPos = helper.readNullable(in, helper::readGlobalPos);
        this.portalCooldown = helper.readVarInt(in);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writeString(out, this.dimension);
        helper.writeString(out, this.worldName);
        out.writeLong(this.hashedSeed);
        out.writeByte(this.gamemode.ordinal());
        out.writeByte(GameMode.toNullableId(this.previousGamemode));
        out.writeBoolean(this.debug);
        out.writeBoolean(this.flat);
        int dataToKeep = 0;
        if (this.keepMetadata) {
            dataToKeep = (byte)(dataToKeep + 2);
        }
        if (this.keepAttributes) {
            dataToKeep = (byte)(dataToKeep + 1);
        }
        out.writeByte(dataToKeep);
        helper.writeNullable(out, this.lastDeathPos, helper::writeGlobalPos);
        helper.writeVarInt(out, this.portalCooldown);
    }

    @NonNull
    public String getDimension() {
        return this.dimension;
    }

    @NonNull
    public String getWorldName() {
        return this.worldName;
    }

    public long getHashedSeed() {
        return this.hashedSeed;
    }

    @NonNull
    public GameMode getGamemode() {
        return this.gamemode;
    }

    @Nullable
    public GameMode getPreviousGamemode() {
        return this.previousGamemode;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isFlat() {
        return this.flat;
    }

    public boolean isKeepMetadata() {
        return this.keepMetadata;
    }

    public boolean isKeepAttributes() {
        return this.keepAttributes;
    }

    @Nullable
    public GlobalPos getLastDeathPos() {
        return this.lastDeathPos;
    }

    public int getPortalCooldown() {
        return this.portalCooldown;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundRespawnPacket)) {
            return false;
        }
        ClientboundRespawnPacket other = (ClientboundRespawnPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getHashedSeed() != other.getHashedSeed()) {
            return false;
        }
        if (this.isDebug() != other.isDebug()) {
            return false;
        }
        if (this.isFlat() != other.isFlat()) {
            return false;
        }
        if (this.isKeepMetadata() != other.isKeepMetadata()) {
            return false;
        }
        if (this.isKeepAttributes() != other.isKeepAttributes()) {
            return false;
        }
        if (this.getPortalCooldown() != other.getPortalCooldown()) {
            return false;
        }
        String this$dimension = this.getDimension();
        String other$dimension = other.getDimension();
        if (this$dimension == null ? other$dimension != null : !this$dimension.equals(other$dimension)) {
            return false;
        }
        String this$worldName = this.getWorldName();
        String other$worldName = other.getWorldName();
        if (this$worldName == null ? other$worldName != null : !this$worldName.equals(other$worldName)) {
            return false;
        }
        GameMode this$gamemode = this.getGamemode();
        GameMode other$gamemode = other.getGamemode();
        if (this$gamemode == null ? other$gamemode != null : !this$gamemode.equals(other$gamemode)) {
            return false;
        }
        GameMode this$previousGamemode = this.getPreviousGamemode();
        GameMode other$previousGamemode = other.getPreviousGamemode();
        if (this$previousGamemode == null ? other$previousGamemode != null : !this$previousGamemode.equals(other$previousGamemode)) {
            return false;
        }
        GlobalPos this$lastDeathPos = this.getLastDeathPos();
        GlobalPos other$lastDeathPos = other.getLastDeathPos();
        return !(this$lastDeathPos == null ? other$lastDeathPos != null : !this$lastDeathPos.equals(other$lastDeathPos));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundRespawnPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $hashedSeed = this.getHashedSeed();
        result = result * 59 + (int)($hashedSeed >>> 32 ^ $hashedSeed);
        result = result * 59 + (this.isDebug() ? 79 : 97);
        result = result * 59 + (this.isFlat() ? 79 : 97);
        result = result * 59 + (this.isKeepMetadata() ? 79 : 97);
        result = result * 59 + (this.isKeepAttributes() ? 79 : 97);
        result = result * 59 + this.getPortalCooldown();
        String $dimension = this.getDimension();
        result = result * 59 + ($dimension == null ? 43 : $dimension.hashCode());
        String $worldName = this.getWorldName();
        result = result * 59 + ($worldName == null ? 43 : $worldName.hashCode());
        GameMode $gamemode = this.getGamemode();
        result = result * 59 + ($gamemode == null ? 43 : $gamemode.hashCode());
        GameMode $previousGamemode = this.getPreviousGamemode();
        result = result * 59 + ($previousGamemode == null ? 43 : $previousGamemode.hashCode());
        GlobalPos $lastDeathPos = this.getLastDeathPos();
        result = result * 59 + ($lastDeathPos == null ? 43 : $lastDeathPos.hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundRespawnPacket(dimension=" + this.getDimension() + ", worldName=" + this.getWorldName() + ", hashedSeed=" + this.getHashedSeed() + ", gamemode=" + this.getGamemode() + ", previousGamemode=" + this.getPreviousGamemode() + ", debug=" + this.isDebug() + ", flat=" + this.isFlat() + ", keepMetadata=" + this.isKeepMetadata() + ", keepAttributes=" + this.isKeepAttributes() + ", lastDeathPos=" + this.getLastDeathPos() + ", portalCooldown=" + this.getPortalCooldown() + ")";
    }

    public ClientboundRespawnPacket withDimension(@NonNull String dimension) {
        if (dimension == null) {
            throw new NullPointerException("dimension is marked non-null but is null");
        }
        return this.dimension == dimension ? this : new ClientboundRespawnPacket(dimension, this.worldName, this.hashedSeed, this.gamemode, this.previousGamemode, this.debug, this.flat, this.keepMetadata, this.keepAttributes, this.lastDeathPos, this.portalCooldown);
    }

    public ClientboundRespawnPacket withWorldName(@NonNull String worldName) {
        if (worldName == null) {
            throw new NullPointerException("worldName is marked non-null but is null");
        }
        return this.worldName == worldName ? this : new ClientboundRespawnPacket(this.dimension, worldName, this.hashedSeed, this.gamemode, this.previousGamemode, this.debug, this.flat, this.keepMetadata, this.keepAttributes, this.lastDeathPos, this.portalCooldown);
    }

    public ClientboundRespawnPacket withHashedSeed(long hashedSeed) {
        return this.hashedSeed == hashedSeed ? this : new ClientboundRespawnPacket(this.dimension, this.worldName, hashedSeed, this.gamemode, this.previousGamemode, this.debug, this.flat, this.keepMetadata, this.keepAttributes, this.lastDeathPos, this.portalCooldown);
    }

    public ClientboundRespawnPacket withGamemode(@NonNull GameMode gamemode) {
        if (gamemode == null) {
            throw new NullPointerException("gamemode is marked non-null but is null");
        }
        return this.gamemode == gamemode ? this : new ClientboundRespawnPacket(this.dimension, this.worldName, this.hashedSeed, gamemode, this.previousGamemode, this.debug, this.flat, this.keepMetadata, this.keepAttributes, this.lastDeathPos, this.portalCooldown);
    }

    public ClientboundRespawnPacket withPreviousGamemode(@Nullable GameMode previousGamemode) {
        return this.previousGamemode == previousGamemode ? this : new ClientboundRespawnPacket(this.dimension, this.worldName, this.hashedSeed, this.gamemode, previousGamemode, this.debug, this.flat, this.keepMetadata, this.keepAttributes, this.lastDeathPos, this.portalCooldown);
    }

    public ClientboundRespawnPacket withDebug(boolean debug) {
        return this.debug == debug ? this : new ClientboundRespawnPacket(this.dimension, this.worldName, this.hashedSeed, this.gamemode, this.previousGamemode, debug, this.flat, this.keepMetadata, this.keepAttributes, this.lastDeathPos, this.portalCooldown);
    }

    public ClientboundRespawnPacket withFlat(boolean flat) {
        return this.flat == flat ? this : new ClientboundRespawnPacket(this.dimension, this.worldName, this.hashedSeed, this.gamemode, this.previousGamemode, this.debug, flat, this.keepMetadata, this.keepAttributes, this.lastDeathPos, this.portalCooldown);
    }

    public ClientboundRespawnPacket withKeepMetadata(boolean keepMetadata) {
        return this.keepMetadata == keepMetadata ? this : new ClientboundRespawnPacket(this.dimension, this.worldName, this.hashedSeed, this.gamemode, this.previousGamemode, this.debug, this.flat, keepMetadata, this.keepAttributes, this.lastDeathPos, this.portalCooldown);
    }

    public ClientboundRespawnPacket withKeepAttributes(boolean keepAttributes) {
        return this.keepAttributes == keepAttributes ? this : new ClientboundRespawnPacket(this.dimension, this.worldName, this.hashedSeed, this.gamemode, this.previousGamemode, this.debug, this.flat, this.keepMetadata, keepAttributes, this.lastDeathPos, this.portalCooldown);
    }

    public ClientboundRespawnPacket withLastDeathPos(@Nullable GlobalPos lastDeathPos) {
        return this.lastDeathPos == lastDeathPos ? this : new ClientboundRespawnPacket(this.dimension, this.worldName, this.hashedSeed, this.gamemode, this.previousGamemode, this.debug, this.flat, this.keepMetadata, this.keepAttributes, lastDeathPos, this.portalCooldown);
    }

    public ClientboundRespawnPacket withPortalCooldown(int portalCooldown) {
        return this.portalCooldown == portalCooldown ? this : new ClientboundRespawnPacket(this.dimension, this.worldName, this.hashedSeed, this.gamemode, this.previousGamemode, this.debug, this.flat, this.keepMetadata, this.keepAttributes, this.lastDeathPos, portalCooldown);
    }

    public ClientboundRespawnPacket(@NonNull String dimension, @NonNull String worldName, long hashedSeed, @NonNull GameMode gamemode, @Nullable GameMode previousGamemode, boolean debug, boolean flat, boolean keepMetadata, boolean keepAttributes, @Nullable GlobalPos lastDeathPos, int portalCooldown) {
        if (dimension == null) {
            throw new NullPointerException("dimension is marked non-null but is null");
        }
        if (worldName == null) {
            throw new NullPointerException("worldName is marked non-null but is null");
        }
        if (gamemode == null) {
            throw new NullPointerException("gamemode is marked non-null but is null");
        }
        this.dimension = dimension;
        this.worldName = worldName;
        this.hashedSeed = hashedSeed;
        this.gamemode = gamemode;
        this.previousGamemode = previousGamemode;
        this.debug = debug;
        this.flat = flat;
        this.keepMetadata = keepMetadata;
        this.keepAttributes = keepAttributes;
        this.lastDeathPos = lastDeathPos;
        this.portalCooldown = portalCooldown;
    }
}

