/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.GlobalPos;
import com.github.steveice10.mc.protocol.data.game.entity.player.GameMode;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Arrays;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public class ClientboundLoginPacket
implements MinecraftPacket {
    private final int entityId;
    private final boolean hardcore;
    @NonNull
    private final GameMode gameMode;
    @Nullable
    private final GameMode previousGamemode;
    @NonNull
    private final String[] worldNames;
    @NonNull
    private final CompoundTag registry;
    @NonNull
    private final String dimension;
    @NonNull
    private final String worldName;
    private final long hashedSeed;
    private final int maxPlayers;
    private final int viewDistance;
    private final int simulationDistance;
    private final boolean reducedDebugInfo;
    private final boolean enableRespawnScreen;
    private final boolean debug;
    private final boolean flat;
    @Nullable
    private final GlobalPos lastDeathPos;
    private final int portalCooldown;

    public ClientboundLoginPacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.entityId = in.readInt();
        this.hardcore = in.readBoolean();
        this.gameMode = GameMode.byId(in.readByte());
        this.previousGamemode = GameMode.byNullableId(in.readByte());
        int worldCount = helper.readVarInt(in);
        this.worldNames = new String[worldCount];
        for (int i = 0; i < worldCount; ++i) {
            this.worldNames[i] = helper.readString(in);
        }
        this.registry = helper.readTag(in);
        this.dimension = helper.readString(in);
        this.worldName = helper.readString(in);
        this.hashedSeed = in.readLong();
        this.maxPlayers = helper.readVarInt(in);
        this.viewDistance = helper.readVarInt(in);
        this.simulationDistance = helper.readVarInt(in);
        this.reducedDebugInfo = in.readBoolean();
        this.enableRespawnScreen = in.readBoolean();
        this.debug = in.readBoolean();
        this.flat = in.readBoolean();
        this.lastDeathPos = in.readBoolean() ? helper.readGlobalPos(in) : null;
        this.portalCooldown = helper.readVarInt(in);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        out.writeInt(this.entityId);
        out.writeBoolean(this.hardcore);
        out.writeByte(this.gameMode.ordinal());
        out.writeByte(GameMode.toNullableId(this.gameMode));
        helper.writeVarInt(out, this.worldNames.length);
        for (String worldName : this.worldNames) {
            helper.writeString(out, worldName);
        }
        helper.writeTag(out, this.registry);
        helper.writeString(out, this.dimension);
        helper.writeString(out, this.worldName);
        out.writeLong(this.hashedSeed);
        helper.writeVarInt(out, this.maxPlayers);
        helper.writeVarInt(out, this.viewDistance);
        helper.writeVarInt(out, this.simulationDistance);
        out.writeBoolean(this.reducedDebugInfo);
        out.writeBoolean(this.enableRespawnScreen);
        out.writeBoolean(this.debug);
        out.writeBoolean(this.flat);
        out.writeBoolean(this.lastDeathPos != null);
        if (this.lastDeathPos != null) {
            helper.writeGlobalPos(out, this.lastDeathPos);
        }
        helper.writeVarInt(out, this.portalCooldown);
    }

    public int getEntityId() {
        return this.entityId;
    }

    public boolean isHardcore() {
        return this.hardcore;
    }

    @NonNull
    public GameMode getGameMode() {
        return this.gameMode;
    }

    @Nullable
    public GameMode getPreviousGamemode() {
        return this.previousGamemode;
    }

    @NonNull
    public String[] getWorldNames() {
        return this.worldNames;
    }

    @NonNull
    public CompoundTag getRegistry() {
        return this.registry;
    }

    @NonNull
    public String getDimension() {
        return this.dimension;
    }

    @NonNull
    public String getWorldName() {
        return this.worldName;
    }

    public long getHashedSeed() {
        return this.hashedSeed;
    }

    public int getMaxPlayers() {
        return this.maxPlayers;
    }

    public int getViewDistance() {
        return this.viewDistance;
    }

    public int getSimulationDistance() {
        return this.simulationDistance;
    }

    public boolean isReducedDebugInfo() {
        return this.reducedDebugInfo;
    }

    public boolean isEnableRespawnScreen() {
        return this.enableRespawnScreen;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isFlat() {
        return this.flat;
    }

    @Nullable
    public GlobalPos getLastDeathPos() {
        return this.lastDeathPos;
    }

    public int getPortalCooldown() {
        return this.portalCooldown;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundLoginPacket)) {
            return false;
        }
        ClientboundLoginPacket other = (ClientboundLoginPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        if (this.isHardcore() != other.isHardcore()) {
            return false;
        }
        if (this.getHashedSeed() != other.getHashedSeed()) {
            return false;
        }
        if (this.getMaxPlayers() != other.getMaxPlayers()) {
            return false;
        }
        if (this.getViewDistance() != other.getViewDistance()) {
            return false;
        }
        if (this.getSimulationDistance() != other.getSimulationDistance()) {
            return false;
        }
        if (this.isReducedDebugInfo() != other.isReducedDebugInfo()) {
            return false;
        }
        if (this.isEnableRespawnScreen() != other.isEnableRespawnScreen()) {
            return false;
        }
        if (this.isDebug() != other.isDebug()) {
            return false;
        }
        if (this.isFlat() != other.isFlat()) {
            return false;
        }
        if (this.getPortalCooldown() != other.getPortalCooldown()) {
            return false;
        }
        GameMode this$gameMode = this.getGameMode();
        GameMode other$gameMode = other.getGameMode();
        if (this$gameMode == null ? other$gameMode != null : !this$gameMode.equals(other$gameMode)) {
            return false;
        }
        GameMode this$previousGamemode = this.getPreviousGamemode();
        GameMode other$previousGamemode = other.getPreviousGamemode();
        if (this$previousGamemode == null ? other$previousGamemode != null : !this$previousGamemode.equals(other$previousGamemode)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getWorldNames(), other.getWorldNames())) {
            return false;
        }
        CompoundTag this$registry = this.getRegistry();
        CompoundTag other$registry = other.getRegistry();
        if (this$registry == null ? other$registry != null : !this$registry.equals(other$registry)) {
            return false;
        }
        String this$dimension = this.getDimension();
        String other$dimension = other.getDimension();
        if (this$dimension == null ? other$dimension != null : !this$dimension.equals(other$dimension)) {
            return false;
        }
        String this$worldName = this.getWorldName();
        String other$worldName = other.getWorldName();
        if (this$worldName == null ? other$worldName != null : !this$worldName.equals(other$worldName)) {
            return false;
        }
        GlobalPos this$lastDeathPos = this.getLastDeathPos();
        GlobalPos other$lastDeathPos = other.getLastDeathPos();
        return !(this$lastDeathPos == null ? other$lastDeathPos != null : !this$lastDeathPos.equals(other$lastDeathPos));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundLoginPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        result = result * 59 + (this.isHardcore() ? 79 : 97);
        long $hashedSeed = this.getHashedSeed();
        result = result * 59 + (int)($hashedSeed >>> 32 ^ $hashedSeed);
        result = result * 59 + this.getMaxPlayers();
        result = result * 59 + this.getViewDistance();
        result = result * 59 + this.getSimulationDistance();
        result = result * 59 + (this.isReducedDebugInfo() ? 79 : 97);
        result = result * 59 + (this.isEnableRespawnScreen() ? 79 : 97);
        result = result * 59 + (this.isDebug() ? 79 : 97);
        result = result * 59 + (this.isFlat() ? 79 : 97);
        result = result * 59 + this.getPortalCooldown();
        GameMode $gameMode = this.getGameMode();
        result = result * 59 + ($gameMode == null ? 43 : $gameMode.hashCode());
        GameMode $previousGamemode = this.getPreviousGamemode();
        result = result * 59 + ($previousGamemode == null ? 43 : $previousGamemode.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getWorldNames());
        CompoundTag $registry = this.getRegistry();
        result = result * 59 + ($registry == null ? 43 : $registry.hashCode());
        String $dimension = this.getDimension();
        result = result * 59 + ($dimension == null ? 43 : $dimension.hashCode());
        String $worldName = this.getWorldName();
        result = result * 59 + ($worldName == null ? 43 : $worldName.hashCode());
        GlobalPos $lastDeathPos = this.getLastDeathPos();
        result = result * 59 + ($lastDeathPos == null ? 43 : $lastDeathPos.hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundLoginPacket(entityId=" + this.getEntityId() + ", hardcore=" + this.isHardcore() + ", gameMode=" + this.getGameMode() + ", previousGamemode=" + this.getPreviousGamemode() + ", worldNames=" + Arrays.deepToString(this.getWorldNames()) + ", registry=" + this.getRegistry() + ", dimension=" + this.getDimension() + ", worldName=" + this.getWorldName() + ", hashedSeed=" + this.getHashedSeed() + ", maxPlayers=" + this.getMaxPlayers() + ", viewDistance=" + this.getViewDistance() + ", simulationDistance=" + this.getSimulationDistance() + ", reducedDebugInfo=" + this.isReducedDebugInfo() + ", enableRespawnScreen=" + this.isEnableRespawnScreen() + ", debug=" + this.isDebug() + ", flat=" + this.isFlat() + ", lastDeathPos=" + this.getLastDeathPos() + ", portalCooldown=" + this.getPortalCooldown() + ")";
    }

    public ClientboundLoginPacket withEntityId(int entityId) {
        return this.entityId == entityId ? this : new ClientboundLoginPacket(entityId, this.hardcore, this.gameMode, this.previousGamemode, this.worldNames, this.registry, this.dimension, this.worldName, this.hashedSeed, this.maxPlayers, this.viewDistance, this.simulationDistance, this.reducedDebugInfo, this.enableRespawnScreen, this.debug, this.flat, this.lastDeathPos, this.portalCooldown);
    }

    public ClientboundLoginPacket withHardcore(boolean hardcore) {
        return this.hardcore == hardcore ? this : new ClientboundLoginPacket(this.entityId, hardcore, this.gameMode, this.previousGamemode, this.worldNames, this.registry, this.dimension, this.worldName, this.hashedSeed, this.maxPlayers, this.viewDistance, this.simulationDistance, this.reducedDebugInfo, this.enableRespawnScreen, this.debug, this.flat, this.lastDeathPos, this.portalCooldown);
    }

    public ClientboundLoginPacket withGameMode(@NonNull GameMode gameMode) {
        if (gameMode == null) {
            throw new NullPointerException("gameMode is marked non-null but is null");
        }
        return this.gameMode == gameMode ? this : new ClientboundLoginPacket(this.entityId, this.hardcore, gameMode, this.previousGamemode, this.worldNames, this.registry, this.dimension, this.worldName, this.hashedSeed, this.maxPlayers, this.viewDistance, this.simulationDistance, this.reducedDebugInfo, this.enableRespawnScreen, this.debug, this.flat, this.lastDeathPos, this.portalCooldown);
    }

    public ClientboundLoginPacket withPreviousGamemode(@Nullable GameMode previousGamemode) {
        return this.previousGamemode == previousGamemode ? this : new ClientboundLoginPacket(this.entityId, this.hardcore, this.gameMode, previousGamemode, this.worldNames, this.registry, this.dimension, this.worldName, this.hashedSeed, this.maxPlayers, this.viewDistance, this.simulationDistance, this.reducedDebugInfo, this.enableRespawnScreen, this.debug, this.flat, this.lastDeathPos, this.portalCooldown);
    }

    public ClientboundLoginPacket withWorldNames(@NonNull String[] worldNames) {
        if (worldNames == null) {
            throw new NullPointerException("worldNames is marked non-null but is null");
        }
        return this.worldNames == worldNames ? this : new ClientboundLoginPacket(this.entityId, this.hardcore, this.gameMode, this.previousGamemode, worldNames, this.registry, this.dimension, this.worldName, this.hashedSeed, this.maxPlayers, this.viewDistance, this.simulationDistance, this.reducedDebugInfo, this.enableRespawnScreen, this.debug, this.flat, this.lastDeathPos, this.portalCooldown);
    }

    public ClientboundLoginPacket withRegistry(@NonNull CompoundTag registry) {
        if (registry == null) {
            throw new NullPointerException("registry is marked non-null but is null");
        }
        return this.registry == registry ? this : new ClientboundLoginPacket(this.entityId, this.hardcore, this.gameMode, this.previousGamemode, this.worldNames, registry, this.dimension, this.worldName, this.hashedSeed, this.maxPlayers, this.viewDistance, this.simulationDistance, this.reducedDebugInfo, this.enableRespawnScreen, this.debug, this.flat, this.lastDeathPos, this.portalCooldown);
    }

    public ClientboundLoginPacket withDimension(@NonNull String dimension) {
        if (dimension == null) {
            throw new NullPointerException("dimension is marked non-null but is null");
        }
        return this.dimension == dimension ? this : new ClientboundLoginPacket(this.entityId, this.hardcore, this.gameMode, this.previousGamemode, this.worldNames, this.registry, dimension, this.worldName, this.hashedSeed, this.maxPlayers, this.viewDistance, this.simulationDistance, this.reducedDebugInfo, this.enableRespawnScreen, this.debug, this.flat, this.lastDeathPos, this.portalCooldown);
    }

    public ClientboundLoginPacket withWorldName(@NonNull String worldName) {
        if (worldName == null) {
            throw new NullPointerException("worldName is marked non-null but is null");
        }
        return this.worldName == worldName ? this : new ClientboundLoginPacket(this.entityId, this.hardcore, this.gameMode, this.previousGamemode, this.worldNames, this.registry, this.dimension, worldName, this.hashedSeed, this.maxPlayers, this.viewDistance, this.simulationDistance, this.reducedDebugInfo, this.enableRespawnScreen, this.debug, this.flat, this.lastDeathPos, this.portalCooldown);
    }

    public ClientboundLoginPacket withHashedSeed(long hashedSeed) {
        return this.hashedSeed == hashedSeed ? this : new ClientboundLoginPacket(this.entityId, this.hardcore, this.gameMode, this.previousGamemode, this.worldNames, this.registry, this.dimension, this.worldName, hashedSeed, this.maxPlayers, this.viewDistance, this.simulationDistance, this.reducedDebugInfo, this.enableRespawnScreen, this.debug, this.flat, this.lastDeathPos, this.portalCooldown);
    }

    public ClientboundLoginPacket withMaxPlayers(int maxPlayers) {
        return this.maxPlayers == maxPlayers ? this : new ClientboundLoginPacket(this.entityId, this.hardcore, this.gameMode, this.previousGamemode, this.worldNames, this.registry, this.dimension, this.worldName, this.hashedSeed, maxPlayers, this.viewDistance, this.simulationDistance, this.reducedDebugInfo, this.enableRespawnScreen, this.debug, this.flat, this.lastDeathPos, this.portalCooldown);
    }

    public ClientboundLoginPacket withViewDistance(int viewDistance) {
        return this.viewDistance == viewDistance ? this : new ClientboundLoginPacket(this.entityId, this.hardcore, this.gameMode, this.previousGamemode, this.worldNames, this.registry, this.dimension, this.worldName, this.hashedSeed, this.maxPlayers, viewDistance, this.simulationDistance, this.reducedDebugInfo, this.enableRespawnScreen, this.debug, this.flat, this.lastDeathPos, this.portalCooldown);
    }

    public ClientboundLoginPacket withSimulationDistance(int simulationDistance) {
        return this.simulationDistance == simulationDistance ? this : new ClientboundLoginPacket(this.entityId, this.hardcore, this.gameMode, this.previousGamemode, this.worldNames, this.registry, this.dimension, this.worldName, this.hashedSeed, this.maxPlayers, this.viewDistance, simulationDistance, this.reducedDebugInfo, this.enableRespawnScreen, this.debug, this.flat, this.lastDeathPos, this.portalCooldown);
    }

    public ClientboundLoginPacket withReducedDebugInfo(boolean reducedDebugInfo) {
        return this.reducedDebugInfo == reducedDebugInfo ? this : new ClientboundLoginPacket(this.entityId, this.hardcore, this.gameMode, this.previousGamemode, this.worldNames, this.registry, this.dimension, this.worldName, this.hashedSeed, this.maxPlayers, this.viewDistance, this.simulationDistance, reducedDebugInfo, this.enableRespawnScreen, this.debug, this.flat, this.lastDeathPos, this.portalCooldown);
    }

    public ClientboundLoginPacket withEnableRespawnScreen(boolean enableRespawnScreen) {
        return this.enableRespawnScreen == enableRespawnScreen ? this : new ClientboundLoginPacket(this.entityId, this.hardcore, this.gameMode, this.previousGamemode, this.worldNames, this.registry, this.dimension, this.worldName, this.hashedSeed, this.maxPlayers, this.viewDistance, this.simulationDistance, this.reducedDebugInfo, enableRespawnScreen, this.debug, this.flat, this.lastDeathPos, this.portalCooldown);
    }

    public ClientboundLoginPacket withDebug(boolean debug) {
        return this.debug == debug ? this : new ClientboundLoginPacket(this.entityId, this.hardcore, this.gameMode, this.previousGamemode, this.worldNames, this.registry, this.dimension, this.worldName, this.hashedSeed, this.maxPlayers, this.viewDistance, this.simulationDistance, this.reducedDebugInfo, this.enableRespawnScreen, debug, this.flat, this.lastDeathPos, this.portalCooldown);
    }

    public ClientboundLoginPacket withFlat(boolean flat) {
        return this.flat == flat ? this : new ClientboundLoginPacket(this.entityId, this.hardcore, this.gameMode, this.previousGamemode, this.worldNames, this.registry, this.dimension, this.worldName, this.hashedSeed, this.maxPlayers, this.viewDistance, this.simulationDistance, this.reducedDebugInfo, this.enableRespawnScreen, this.debug, flat, this.lastDeathPos, this.portalCooldown);
    }

    public ClientboundLoginPacket withLastDeathPos(@Nullable GlobalPos lastDeathPos) {
        return this.lastDeathPos == lastDeathPos ? this : new ClientboundLoginPacket(this.entityId, this.hardcore, this.gameMode, this.previousGamemode, this.worldNames, this.registry, this.dimension, this.worldName, this.hashedSeed, this.maxPlayers, this.viewDistance, this.simulationDistance, this.reducedDebugInfo, this.enableRespawnScreen, this.debug, this.flat, lastDeathPos, this.portalCooldown);
    }

    public ClientboundLoginPacket withPortalCooldown(int portalCooldown) {
        return this.portalCooldown == portalCooldown ? this : new ClientboundLoginPacket(this.entityId, this.hardcore, this.gameMode, this.previousGamemode, this.worldNames, this.registry, this.dimension, this.worldName, this.hashedSeed, this.maxPlayers, this.viewDistance, this.simulationDistance, this.reducedDebugInfo, this.enableRespawnScreen, this.debug, this.flat, this.lastDeathPos, portalCooldown);
    }

    public ClientboundLoginPacket(int entityId, boolean hardcore, @NonNull GameMode gameMode, @Nullable GameMode previousGamemode, @NonNull String[] worldNames, @NonNull CompoundTag registry, @NonNull String dimension, @NonNull String worldName, long hashedSeed, int maxPlayers, int viewDistance, int simulationDistance, boolean reducedDebugInfo, boolean enableRespawnScreen, boolean debug, boolean flat, @Nullable GlobalPos lastDeathPos, int portalCooldown) {
        if (gameMode == null) {
            throw new NullPointerException("gameMode is marked non-null but is null");
        }
        if (worldNames == null) {
            throw new NullPointerException("worldNames is marked non-null but is null");
        }
        if (registry == null) {
            throw new NullPointerException("registry is marked non-null but is null");
        }
        if (dimension == null) {
            throw new NullPointerException("dimension is marked non-null but is null");
        }
        if (worldName == null) {
            throw new NullPointerException("worldName is marked non-null but is null");
        }
        this.entityId = entityId;
        this.hardcore = hardcore;
        this.gameMode = gameMode;
        this.previousGamemode = previousGamemode;
        this.worldNames = worldNames;
        this.registry = registry;
        this.dimension = dimension;
        this.worldName = worldName;
        this.hashedSeed = hashedSeed;
        this.maxPlayers = maxPlayers;
        this.viewDistance = viewDistance;
        this.simulationDistance = simulationDistance;
        this.reducedDebugInfo = reducedDebugInfo;
        this.enableRespawnScreen = enableRespawnScreen;
        this.debug = debug;
        this.flat = flat;
        this.lastDeathPos = lastDeathPos;
        this.portalCooldown = portalCooldown;
    }
}

