/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.data.game.command;

import com.github.steveice10.mc.protocol.data.game.Identifier;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public enum SuggestionType {
    ASK_SERVER,
    ALL_RECIPES,
    AVAILABLE_SOUNDS,
    SUMMONABLE_ENTITIES;

    private final String resourceLocation = Identifier.formalize(this.name().toLowerCase(Locale.ROOT));
    private static final Map<String, SuggestionType> VALUES;

    public String getResourceLocation() {
        return this.resourceLocation;
    }

    @NotNull
    public static SuggestionType from(String resourceLocation) {
        return VALUES.getOrDefault(resourceLocation, ASK_SERVER);
    }

    static {
        VALUES = new HashMap<String, SuggestionType>();
        for (SuggestionType suggestionType : SuggestionType.values()) {
            VALUES.put(suggestionType.resourceLocation, suggestionType);
        }
    }
}

