/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.data.game.chunk.palette;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.data.game.chunk.palette.Palette;
import io.netty.buffer.ByteBuf;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import java.io.IOException;
import java.util.Arrays;

public class MapPalette
implements Palette {
    private final int maxId;
    private final int[] idToState;
    private final IntObjectMap<Integer> stateToId = new IntObjectHashMap();
    private int nextId = 0;

    public MapPalette(int bitsPerEntry) {
        this.maxId = (1 << bitsPerEntry) - 1;
        this.idToState = new int[this.maxId + 1];
    }

    public MapPalette(int bitsPerEntry, ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this(bitsPerEntry);
        int paletteLength = helper.readVarInt(in);
        for (int i = 0; i < paletteLength; ++i) {
            int state;
            this.idToState[i] = state = helper.readVarInt(in);
            this.stateToId.putIfAbsent((Object)state, (Object)i);
        }
        this.nextId = paletteLength;
    }

    @Override
    public int size() {
        return this.nextId;
    }

    @Override
    public int stateToId(int state) {
        Integer id = (Integer)this.stateToId.get(state);
        if (id == null && this.size() < this.maxId + 1) {
            id = this.nextId++;
            this.idToState[id.intValue()] = state;
            this.stateToId.put(state, (Object)id);
        }
        if (id != null) {
            return id;
        }
        return -1;
    }

    @Override
    public int idToState(int id) {
        if (id >= 0 && id < this.size()) {
            return this.idToState[id];
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MapPalette)) {
            return false;
        }
        MapPalette other = (MapPalette)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.maxId != other.maxId) {
            return false;
        }
        if (this.nextId != other.nextId) {
            return false;
        }
        if (!Arrays.equals(this.idToState, other.idToState)) {
            return false;
        }
        IntObjectMap<Integer> this$stateToId = this.stateToId;
        IntObjectMap<Integer> other$stateToId = other.stateToId;
        return !(this$stateToId == null ? other$stateToId != null : !this$stateToId.equals(other$stateToId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MapPalette;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.maxId;
        result = result * 59 + this.nextId;
        result = result * 59 + Arrays.hashCode(this.idToState);
        IntObjectMap<Integer> $stateToId = this.stateToId;
        result = result * 59 + ($stateToId == null ? 43 : $stateToId.hashCode());
        return result;
    }
}

