/*
 * Decompiled with CFR 0.152.
 */
package com.whygraphics.multilineradiogroup;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.TableLayout;
import android.widget.TableRow;
import com.whygraphics.multilineradiogroup.R;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class MultiLineRadioGroup
extends RadioGroup {
    private static final String XML_DEFAULT_BUTTON_PREFIX_INDEX = "index:";
    private static final String XML_DEFAULT_BUTTON_PREFIX_TEXT = "text:";
    private static final int DEF_VAL_MAX_IN_ROW = 0;
    private static final AtomicInteger sNextGeneratedId = new AtomicInteger(1);
    private OnCheckedChangeListener mOnCheckedChangeListener;
    private int mMaxInRow;
    private TableLayout mTableLayout;
    private List<RadioButton> mRadioButtons;
    private RadioButton mCheckedButton;

    public MultiLineRadioGroup(Context context) {
        super(context);
        this.init(null);
    }

    public MultiLineRadioGroup(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        this.mRadioButtons = new ArrayList<RadioButton>();
        this.mTableLayout = this.getTableLayout();
        this.addView((View)this.mTableLayout);
        if (attrs != null) {
            this.initAttrs(attrs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAttrs(AttributeSet attrs) {
        TypedArray typedArray = this.getContext().getTheme().obtainStyledAttributes(attrs, R.styleable.multi_line_radio_group, 0, 0);
        try {
            this.setMaxInRow(typedArray.getInt(R.styleable.multi_line_radio_group_max_in_row, 0));
            CharSequence[] radioButtonStrings = typedArray.getTextArray(R.styleable.multi_line_radio_group_radio_buttons);
            this.addButtons(radioButtonStrings);
            String string = typedArray.getString(R.styleable.multi_line_radio_group_default_button);
            if (string != null) {
                this.setDefaultButton(string);
            }
        }
        finally {
            typedArray.recycle();
        }
    }

    private void setDefaultButton(String string) {
        String buttonToCheck;
        int START_OF_INDEX = XML_DEFAULT_BUTTON_PREFIX_INDEX.length();
        int START_OF_TEXT = XML_DEFAULT_BUTTON_PREFIX_TEXT.length();
        if (string.startsWith(XML_DEFAULT_BUTTON_PREFIX_INDEX)) {
            String indexString = string.substring(START_OF_INDEX);
            int index = Integer.parseInt(indexString);
            if (index < 0 || index >= this.mRadioButtons.size()) {
                throw new IllegalArgumentException("index must be between 0 to getRadioButtonCount() - 1 [" + (this.getRadioButtonCount() - 1) + "]: " + index);
            }
            buttonToCheck = this.mRadioButtons.get(index).getText().toString();
        } else {
            buttonToCheck = string.startsWith(XML_DEFAULT_BUTTON_PREFIX_TEXT) ? string.substring(START_OF_TEXT) : string;
        }
        this.check(buttonToCheck);
    }

    protected TableLayout getTableLayout() {
        return (TableLayout)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.table_layout, (ViewGroup)this, false);
    }

    protected TableRow getTableRow() {
        return (TableRow)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.table_row, (ViewGroup)this.mTableLayout, false);
    }

    protected RadioButton getRadioButton() {
        return (RadioButton)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.radio_button, null);
    }

    public void setOnCheckedChangeListener(OnCheckedChangeListener onCheckedChangeListener) {
        this.mOnCheckedChangeListener = onCheckedChangeListener;
    }

    public int getMaxInRow() {
        return this.mMaxInRow;
    }

    public void setMaxInRow(int maxInRow) {
        if (maxInRow < 0) {
            throw new IllegalArgumentException("maxInRow must not be negative: " + maxInRow);
        }
        this.mMaxInRow = maxInRow;
        this.arrangeButtons();
    }

    public void addView(View child) {
        this.addView(child, -1, child.getLayoutParams());
    }

    public void addView(View child, int index) {
        this.addView(child, index, child.getLayoutParams());
    }

    public void addView(View child, int width, int height) {
        this.addView(child, -1, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(width, height));
    }

    public void addView(View child, ViewGroup.LayoutParams params) {
        this.addView(child, -1, params);
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        if (child instanceof RadioButton) {
            this.addButtons(index, (RadioButton)child);
        } else {
            if (params == null) {
                params = new ViewGroup.LayoutParams(-1, -1);
            }
            super.addView(child, index, params);
        }
    }

    public void addButtons(CharSequence ... radioButtons) {
        this.addButtons(-1, radioButtons);
    }

    public void addButtons(int index, CharSequence ... radioButtons) {
        if (index < -1 || index > this.mRadioButtons.size()) {
            throw new IllegalArgumentException("index must be between -1 to getRadioButtonCount() [" + this.getRadioButtonCount() + "]: " + index);
        }
        if (radioButtons == null) {
            return;
        }
        RadioButton[] buttons = new RadioButton[radioButtons.length];
        for (int i = 0; i < buttons.length; ++i) {
            RadioButton radioButton = this.getRadioButton();
            radioButton.setText(radioButtons[i]);
            radioButton.setId(this.generateId());
            buttons[i] = radioButton;
        }
        this.addButtons(index, buttons);
    }

    private int generateId() {
        int newValue;
        int result;
        if (Build.VERSION.SDK_INT >= 17) {
            return View.generateViewId();
        }
        do {
            if ((newValue = (result = sNextGeneratedId.get()) + 1) <= 0xFFFFFF) continue;
            newValue = 1;
        } while (!sNextGeneratedId.compareAndSet(result, newValue));
        return result;
    }

    public void addButtons(RadioButton ... radioButtons) {
        this.addButtons(-1, radioButtons);
    }

    public void addButtons(int index, RadioButton ... radioButtons) {
        if (index < -1 || index > this.mRadioButtons.size()) {
            throw new IllegalArgumentException("index must be between -1 to getRadioButtonCount() [" + this.getRadioButtonCount() + "]: " + index);
        }
        if (radioButtons == null) {
            return;
        }
        int realIndex = index != -1 ? index : this.mRadioButtons.size();
        for (RadioButton radioButton : radioButtons) {
            this.initRadioButton(radioButton);
            this.mRadioButtons.add(realIndex++, radioButton);
        }
        this.arrangeButtons();
    }

    private void initRadioButton(RadioButton radioButton) {
        radioButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MultiLineRadioGroup.this.checkButton((RadioButton)v);
                if (MultiLineRadioGroup.this.mOnCheckedChangeListener != null) {
                    MultiLineRadioGroup.this.mOnCheckedChangeListener.onCheckedChanged((ViewGroup)MultiLineRadioGroup.this, MultiLineRadioGroup.this.mCheckedButton);
                }
            }
        });
    }

    public void removeView(View view) {
        super.removeView(view);
    }

    public void removeViewAt(int index) {
        super.removeViewAt(index);
    }

    public void removeViews(int start, int count) {
        super.removeViews(start, count);
    }

    public void removeAllViews() {
        super.removeAllViews();
    }

    public void removeButton(RadioButton radioButton) {
        if (radioButton == null) {
            return;
        }
        this.removeButton(radioButton.getText());
    }

    public void removeButton(CharSequence text) {
        if (text == null) {
            return;
        }
        int index = -1;
        int len = this.mRadioButtons.size();
        for (int i = 0; i < len; ++i) {
            if (!this.mRadioButtons.get(i).getText().equals(text)) continue;
            index = i;
            break;
        }
        if (index != -1) {
            this.removeButton(index);
        }
    }

    public void removeButton(int index) {
        this.removeButtons(index, 1);
    }

    public void removeButtons(int start, int count) {
        if (start < 0 || start >= this.mRadioButtons.size()) {
            throw new IllegalArgumentException("start index must be between 0 to getRadioButtonCount() - 1 [" + (this.getRadioButtonCount() - 1) + "]: " + start);
        }
        if (count < 0) {
            throw new IllegalArgumentException("count must not be negative: " + count);
        }
        if (count == 0) {
            return;
        }
        int endIndex = start + count - 1;
        if (endIndex >= this.mRadioButtons.size()) {
            endIndex = this.mRadioButtons.size() - 1;
        }
        for (int i = endIndex; i >= start; --i) {
            RadioButton radiobutton = this.mRadioButtons.get(i);
            if (radiobutton == this.mCheckedButton) {
                this.mCheckedButton = null;
            }
            this.mRadioButtons.remove(i);
        }
        this.arrangeButtons();
    }

    public void removeAllButtons() {
        this.removeButtons(0, this.mRadioButtons.size());
    }

    private void arrangeButtons() {
        int len = this.mRadioButtons.size();
        for (int i = 0; i < len; ++i) {
            RadioButton radioButtonToPlace = this.mRadioButtons.get(i);
            int rowToInsert = this.mMaxInRow != 0 ? i / this.mMaxInRow : 0;
            int columnToInsert = this.mMaxInRow != 0 ? i % this.mMaxInRow : i;
            TableRow tableRowToInsert = this.mTableLayout.getChildCount() <= rowToInsert ? this.addTableRow() : (TableRow)this.mTableLayout.getChildAt(rowToInsert);
            int tableRowChildCount = tableRowToInsert.getChildCount();
            if (tableRowChildCount > columnToInsert) {
                RadioButton currentButton = (RadioButton)tableRowToInsert.getChildAt(columnToInsert);
                if (currentButton == radioButtonToPlace) continue;
                this.removeButtonFromParent(currentButton, (ViewGroup)tableRowToInsert);
                this.removeButtonFromParent(radioButtonToPlace, (ViewGroup)radioButtonToPlace.getParent());
                tableRowToInsert.addView((View)radioButtonToPlace, columnToInsert);
                continue;
            }
            this.removeButtonFromParent(radioButtonToPlace, (ViewGroup)radioButtonToPlace.getParent());
            tableRowToInsert.addView((View)radioButtonToPlace, columnToInsert);
        }
        this.removeRedundancies();
    }

    private void removeRedundancies() {
        int rows = this.mRadioButtons.size() == 0 ? 0 : (this.mMaxInRow == 0 ? 1 : (this.mRadioButtons.size() - 1) / this.mMaxInRow + 1);
        int tableChildCount = this.mTableLayout.getChildCount();
        if (tableChildCount > rows) {
            this.mTableLayout.removeViews(rows, tableChildCount - rows);
        }
        tableChildCount = this.mTableLayout.getChildCount();
        int maxInRow = this.mMaxInRow != 0 ? this.mMaxInRow : this.mRadioButtons.size();
        for (int i = 0; i < tableChildCount; ++i) {
            int count;
            int startIndexToRemove;
            TableRow tableRow = (TableRow)this.mTableLayout.getChildAt(i);
            int tableRowChildCount = tableRow.getChildCount();
            if (i == tableChildCount - 1) {
                startIndexToRemove = (this.mRadioButtons.size() - 1) % maxInRow + 1;
                count = tableRowChildCount - startIndexToRemove;
            } else {
                startIndexToRemove = maxInRow;
                count = tableRowChildCount - maxInRow;
            }
            if (count <= 0) continue;
            tableRow.removeViews(startIndexToRemove, count);
        }
    }

    private TableRow addTableRow() {
        TableRow tableRow = this.getTableRow();
        this.mTableLayout.addView((View)tableRow);
        return tableRow;
    }

    private void removeButtonFromParent(RadioButton radioButton, ViewGroup parent) {
        if (radioButton == null || parent == null) {
            return;
        }
        parent.removeView((View)radioButton);
    }

    public int getRadioButtonCount() {
        return this.mRadioButtons.size();
    }

    public RadioButton getRadioButtonAt(int index) {
        if (index < 0 || index >= this.mRadioButtons.size()) {
            return null;
        }
        return this.mRadioButtons.get(index);
    }

    public void check(int id) {
        if (id <= 0) {
            return;
        }
        for (RadioButton radioButton : this.mRadioButtons) {
            if (radioButton.getId() != id) continue;
            this.checkButton(radioButton);
            return;
        }
    }

    public void check(CharSequence text) {
        if (text == null) {
            return;
        }
        for (RadioButton radioButton : this.mRadioButtons) {
            if (!radioButton.getText().equals(text)) continue;
            this.checkButton(radioButton);
            return;
        }
    }

    public void checkAt(int index) {
        if (index < 0 || index >= this.mRadioButtons.size()) {
            return;
        }
        this.checkButton(this.mRadioButtons.get(index));
    }

    private void checkButton(RadioButton button) {
        if (button == null) {
            return;
        }
        if (button != this.mCheckedButton) {
            if (this.mCheckedButton != null) {
                this.mCheckedButton.setChecked(false);
            }
            button.setChecked(true);
            this.mCheckedButton = button;
        }
    }

    public void clearCheck() {
        this.mCheckedButton.setChecked(false);
        this.mCheckedButton = null;
    }

    public int getCheckedRadioButtonId() {
        if (this.mCheckedButton == null) {
            return -1;
        }
        return this.mCheckedButton.getId();
    }

    public int getCheckedRadioButtonIndex() {
        if (this.mCheckedButton == null) {
            return -1;
        }
        return this.mRadioButtons.indexOf(this.mCheckedButton);
    }

    public CharSequence getCheckedRadioButtonText() {
        if (this.mCheckedButton == null) {
            return null;
        }
        return this.mCheckedButton.getText();
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable parcelable = super.onSaveInstanceState();
        SavedState savedState = new SavedState(parcelable);
        savedState.mMaxInRow = this.mMaxInRow;
        savedState.mCheckedButtonIndex = this.getCheckedRadioButtonIndex();
        return savedState;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        super.onRestoreInstanceState(state);
        if (!(state instanceof SavedState)) {
            return;
        }
        SavedState savedState = (SavedState)state;
        this.setMaxInRow(savedState.mMaxInRow);
        this.checkAt(savedState.mCheckedButtonIndex);
    }

    private static class SavedState
    extends View.BaseSavedState {
        public static final Parcelable.Creator CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };
        int mMaxInRow;
        int mCheckedButtonIndex;

        SavedState(Parcelable superState) {
            super(superState);
        }

        SavedState(Parcel in) {
            super(in);
            this.mMaxInRow = in.readInt();
            this.mCheckedButtonIndex = in.readInt();
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.mMaxInRow);
            out.writeInt(this.mCheckedButtonIndex);
        }
    }

    public static interface OnCheckedChangeListener {
        public void onCheckedChanged(ViewGroup var1, RadioButton var2);
    }
}

