/*
 * Decompiled with CFR 0.152.
 */
package com.miguelbcr.ui.rx_paparazzo2.interactors;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Parcelable;
import android.support.v4.content.FileProvider;
import com.miguelbcr.ui.rx_paparazzo2.entities.Config;
import com.miguelbcr.ui.rx_paparazzo2.entities.FileData;
import com.miguelbcr.ui.rx_paparazzo2.entities.TargetUi;
import com.miguelbcr.ui.rx_paparazzo2.interactors.ImageUtils;
import com.miguelbcr.ui.rx_paparazzo2.interactors.PermissionUtil;
import com.miguelbcr.ui.rx_paparazzo2.interactors.StartIntent;
import com.miguelbcr.ui.rx_paparazzo2.interactors.UseCase;
import io.reactivex.Observable;
import io.reactivex.functions.Function;
import java.io.File;
import java.io.FileNotFoundException;

public final class TakePhoto
extends UseCase<FileData> {
    private static final String PHOTO_FILE_PREFIX = "PHOTO-";
    private final Config config;
    private final StartIntent startIntent;
    private final TargetUi targetUi;
    private final ImageUtils imageUtils;

    public TakePhoto(Config config, StartIntent startIntent, TargetUi targetUi, ImageUtils imageUtils) {
        this.config = config;
        this.startIntent = startIntent;
        this.targetUi = targetUi;
        this.imageUtils = imageUtils;
    }

    @Override
    public Observable<FileData> react() {
        final File file = this.getOutputFile();
        Uri uri = this.getUri(file);
        return this.startIntent.with(this.getIntentCamera(uri)).react().map(this.revokeFileReadWritePermissions(this.targetUi, uri)).map((Function)new Function<Uri, FileData>(){

            public FileData apply(Uri uri) throws Exception {
                if (!file.exists()) {
                    throw new FileNotFoundException(String.format("Camera file not saved", file.getAbsolutePath()));
                }
                return new FileData(file, true, file.getName(), "image/jpeg");
            }
        });
    }

    private Function<Intent, Uri> revokeFileReadWritePermissions(final TargetUi targetUi, final Uri uri) {
        return new Function<Intent, Uri>(){

            public Uri apply(Intent data) throws Exception {
                PermissionUtil.revokeFileReadWritePermissions(targetUi, uri);
                return uri;
            }
        };
    }

    private Uri getUri(File file) {
        Context context = this.targetUi.getContext();
        String authority = this.config.getFileProviderAuthority(context);
        return FileProvider.getUriForFile((Context)context, (String)authority, (File)file);
    }

    private File getOutputFile() {
        String filename = this.imageUtils.createTimestampedFilename(PHOTO_FILE_PREFIX, "jpg");
        String directory = this.config.getFileProviderDirectory();
        return this.imageUtils.getPrivateFile(directory, filename);
    }

    private Intent getIntentCamera(Uri uri) {
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        intent.putExtra("output", (Parcelable)uri);
        return PermissionUtil.requestReadWritePermission(this.targetUi, intent, uri);
    }
}

