/*
 * Decompiled with CFR 0.152.
 */
package com.miguelbcr.ui.rx_paparazzo2.interactors;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.util.Log;
import com.miguelbcr.ui.rx_paparazzo2.entities.Config;
import com.miguelbcr.ui.rx_paparazzo2.entities.FileData;
import com.miguelbcr.ui.rx_paparazzo2.entities.TargetUi;
import com.miguelbcr.ui.rx_paparazzo2.interactors.Dimensions;
import com.miguelbcr.ui.rx_paparazzo2.interactors.ImageUtils;
import com.miguelbcr.ui.rx_paparazzo2.interactors.ScaledImageDimensions;
import com.miguelbcr.ui.rx_paparazzo2.interactors.UseCase;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.functions.Function;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;

public final class SaveFile
extends UseCase<FileData> {
    private static final String TAG = SaveFile.class.getSimpleName();
    private static final String SAVED_FILE_PREFIX = "SAVED-";
    private final TargetUi targetUi;
    private final Config config;
    private final ScaledImageDimensions scaledImageDimensions;
    private final ImageUtils imageUtils;
    private FileData fileData;

    public SaveFile(TargetUi targetUi, Config config, ScaledImageDimensions scaledImageDimensions, ImageUtils imageUtils) {
        this.targetUi = targetUi;
        this.config = config;
        this.scaledImageDimensions = scaledImageDimensions;
        this.imageUtils = imageUtils;
    }

    public SaveFile with(FileData fileData) {
        this.fileData = fileData;
        return this;
    }

    @Override
    public Observable<FileData> react() {
        return this.scaledImageDimensions.with(this.fileData).react().flatMap((Function)new Function<Dimensions, ObservableSource<FileData>>(){

            public ObservableSource<FileData> apply(Dimensions scaledDimensions) throws Exception {
                return SaveFile.this.saveAndSendToMediaScanner(scaledDimensions);
            }
        });
    }

    private ObservableSource<FileData> saveAndSendToMediaScanner(Dimensions scaledDimensions) throws Exception {
        FileData saved = this.save(scaledDimensions);
        if (this.config.isSendToMediaScanner()) {
            if (this.config.isUseInternalStorage()) {
                File file = this.fileData.getFile();
                String message = String.format("Media scanner will not be able to access internal storage '%s'", file.getAbsolutePath());
                Log.w((String)TAG, (String)message);
            }
            if (saved.getFile() != null && saved.getFile().exists()) {
                this.sendToMediaScannerIntent(saved);
            }
        }
        return Observable.just((Object)saved);
    }

    private FileData save(Dimensions scaledDimensions) throws Exception {
        Dimensions imageDimensions = ImageUtils.getImageDimensions(this.fileData.getFile());
        boolean isImage = imageDimensions.hasSize();
        if (isImage) {
            FileData withDimensions = new FileData(this.fileData, imageDimensions);
            return this.saveImageAndDeleteSourceFile(withDimensions, scaledDimensions);
        }
        return this.saveToDestinationAndDeleteSourceFile(this.fileData);
    }

    private FileData saveToDestinationAndDeleteSourceFile(FileData fileData) throws Exception {
        File source = fileData.getFile();
        if (this.isFileSizeLimitExceeded(source)) {
            FileData.deleteSourceFile(fileData);
            return FileData.exceededMaximumFileSize(fileData);
        }
        BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(source));
        File destination = this.getOutputFile();
        this.imageUtils.copy(inputStream, destination);
        return FileData.toFileDataDeleteSourceFileIfTransient(fileData, destination, true, fileData.getMimeType());
    }

    private FileData saveImageAndDeleteSourceFile(FileData fileData, Dimensions dimensions) {
        FileData scaled = this.imageUtils.scaleImage(fileData, this.getOutputFile(), dimensions);
        if (this.isFileSizeLimitExceeded(scaled.getFile())) {
            FileData.deleteSourceFile(fileData);
            FileData.deleteSourceFile(scaled);
            return FileData.exceededMaximumFileSize(fileData);
        }
        FileData.deleteSourceFile(fileData);
        return scaled;
    }

    private boolean isFileSizeLimitExceeded(File scaledFile) {
        return scaledFile.exists() && scaledFile.length() > this.config.getMaximumFileSize();
    }

    private void sendToMediaScannerIntent(FileData fileDataToScan) {
        File file = fileDataToScan.getFile();
        if (file.exists()) {
            Intent mediaScanIntent = new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE");
            Context context = this.targetUi.getContext();
            Uri contentUri = Uri.fromFile((File)file);
            mediaScanIntent.setData(contentUri);
            context.sendBroadcast(mediaScanIntent);
        }
    }

    private File getOutputFile() {
        String fileName = this.fileData.getFilename();
        String extension = this.imageUtils.getFileExtension(fileName);
        return this.imageUtils.getOutputFile(SAVED_FILE_PREFIX, extension);
    }
}

