/*
 * Decompiled with CFR 0.152.
 */
package com.miguelbcr.ui.rx_paparazzo2.interactors;

import com.miguelbcr.ui.rx_paparazzo2.entities.Ignore;
import com.miguelbcr.ui.rx_paparazzo2.entities.PermissionDeniedException;
import com.miguelbcr.ui.rx_paparazzo2.entities.TargetUi;
import com.miguelbcr.ui.rx_paparazzo2.interactors.UseCase;
import com.tbruyelle.rxpermissions2.Permission;
import com.tbruyelle.rxpermissions2.RxPermissions;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import io.reactivex.functions.Function;
import java.util.List;

public final class GrantPermissions
extends UseCase<Ignore> {
    private final TargetUi targetUi;
    private String[] permissions;

    public GrantPermissions(TargetUi targetUi) {
        this.targetUi = targetUi;
    }

    public GrantPermissions with(String ... permissions) {
        this.permissions = permissions;
        return this;
    }

    @Override
    public Observable<Ignore> react() {
        if (this.permissions.length == 0) {
            return Observable.just((Object)((Object)Ignore.Get));
        }
        return new RxPermissions(this.targetUi.activity()).requestEach(this.permissions).buffer(this.permissions.length).flatMapIterable((Function)new Function<List<Permission>, Iterable<Permission>>(){

            public Iterable<Permission> apply(List<Permission> permissions) throws Exception {
                return permissions;
            }
        }).concatMap((Function)new Function<Permission, ObservableSource<Integer>>(){

            public ObservableSource<Integer> apply(Permission permission2) throws Exception {
                if (permission2.granted) {
                    return Observable.just((Object)-1);
                }
                if (permission2.shouldShowRequestPermissionRationale) {
                    return Observable.just((Object)2);
                }
                return Observable.just((Object)3);
            }
        }).toList().flatMap((Function)new Function<List<Integer>, SingleSource<Ignore>>(){

            public SingleSource<Ignore> apply(List<Integer> resultCodes) throws Exception {
                int maxResultCode = -1;
                for (int resultCode : resultCodes) {
                    if (resultCode <= maxResultCode) continue;
                    maxResultCode = resultCode;
                }
                if (maxResultCode == -1) {
                    return Single.just((Object)((Object)Ignore.Get));
                }
                return Single.error((Throwable)new PermissionDeniedException(maxResultCode));
            }
        }).toObservable();
    }
}

