/*
 * Decompiled with CFR 0.152.
 */
package com.miguelbcr.ui.rx_paparazzo2.workers;

import android.net.Uri;
import com.miguelbcr.ui.rx_paparazzo2.entities.Config;
import com.miguelbcr.ui.rx_paparazzo2.entities.Ignore;
import com.miguelbcr.ui.rx_paparazzo2.entities.Response;
import com.miguelbcr.ui.rx_paparazzo2.entities.TargetUi;
import com.miguelbcr.ui.rx_paparazzo2.interactors.CropImage;
import com.miguelbcr.ui.rx_paparazzo2.interactors.GrantPermissions;
import com.miguelbcr.ui.rx_paparazzo2.interactors.PickImage;
import com.miguelbcr.ui.rx_paparazzo2.interactors.PickImages;
import com.miguelbcr.ui.rx_paparazzo2.interactors.SaveImage;
import com.miguelbcr.ui.rx_paparazzo2.workers.Worker;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.functions.Function;
import java.util.List;

public final class Gallery
extends Worker {
    private final GrantPermissions grantPermissions;
    private final PickImages pickImages;
    private final PickImage pickImage;
    private final CropImage cropImage;
    private final SaveImage saveImage;
    private final TargetUi targetUi;
    private final Config config;

    public Gallery(GrantPermissions grantPermissions, PickImages pickImages, PickImage pickImage, CropImage cropImage, SaveImage saveImage, TargetUi targetUi, Config config) {
        super(targetUi);
        this.grantPermissions = grantPermissions;
        this.pickImages = pickImages;
        this.pickImage = pickImage;
        this.cropImage = cropImage;
        this.saveImage = saveImage;
        this.targetUi = targetUi;
        this.config = config;
    }

    public <T> Observable<Response<T, String>> pickImage() {
        return this.grantPermissions.with(this.permissions()).react().flatMap((Function)new Function<Ignore, ObservableSource<Uri>>(){

            public ObservableSource<Uri> apply(Ignore ignore) throws Exception {
                return Gallery.this.pickImage.react();
            }
        }).flatMap((Function)new Function<Uri, ObservableSource<Uri>>(){

            public ObservableSource<Uri> apply(Uri uri) throws Exception {
                return Gallery.this.cropImage.with(uri).react();
            }
        }).flatMap((Function)new Function<Uri, ObservableSource<String>>(){

            public ObservableSource<String> apply(Uri uri) throws Exception {
                return Gallery.this.saveImage.with(uri).react();
            }
        }).map(new Function<String, Response<T, String>>(){

            public Response<T, String> apply(String path) throws Exception {
                return new Response<Object, String>(Gallery.this.targetUi.ui(), path, -1);
            }
        }).compose(this.applyOnError());
    }

    public <T> Observable<Response<T, List<String>>> pickImages() {
        return this.grantPermissions.with(this.permissions()).react().flatMap((Function)new Function<Ignore, ObservableSource<List<Uri>>>(){

            public ObservableSource<List<Uri>> apply(Ignore ignore) throws Exception {
                return Gallery.this.pickImages.react();
            }
        }).flatMapIterable((Function)new Function<List<Uri>, Iterable<Uri>>(){

            public Iterable<Uri> apply(List<Uri> uris) throws Exception {
                return uris;
            }
        }).concatMap((Function)new Function<Uri, ObservableSource<Uri>>(){

            public ObservableSource<Uri> apply(Uri uri) throws Exception {
                return Gallery.this.cropImage.with(uri).react();
            }
        }).concatMap((Function)new Function<Uri, ObservableSource<String>>(){

            public ObservableSource<String> apply(Uri uri) throws Exception {
                return Gallery.this.saveImage.with(uri).react();
            }
        }).toList().toObservable().map(new Function<List<String>, Response<T, List<String>>>(){

            public Response<T, List<String>> apply(List<String> paths) throws Exception {
                return new Response<Object, List<String>>(Gallery.this.targetUi.ui(), paths, -1);
            }
        }).compose(this.applyOnError());
    }

    private String[] permissions() {
        if (this.config.useInternalStorage()) {
            return new String[]{"android.permission.READ_EXTERNAL_STORAGE"};
        }
        return new String[]{"android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.READ_EXTERNAL_STORAGE"};
    }
}

