/*
 * Decompiled with CFR 0.152.
 */
package com.miguelbcr.ui.rx_paparazzo2.interactors;

import android.net.Uri;
import com.miguelbcr.ui.rx_paparazzo2.entities.TargetUi;
import com.miguelbcr.ui.rx_paparazzo2.interactors.ImageUtils;
import com.miguelbcr.ui.rx_paparazzo2.interactors.UseCase;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.schedulers.Schedulers;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

public final class DownloadImage
extends UseCase<String> {
    private final TargetUi targetUi;
    private final ImageUtils imageUtils;
    private Uri uri;

    public DownloadImage(TargetUi targetUi, ImageUtils imageUtils) {
        this.targetUi = targetUi;
        this.imageUtils = imageUtils;
    }

    @Override
    Observable<String> react() {
        return this.getObservableDownloadFile();
    }

    public DownloadImage with(Uri uri) {
        this.uri = uri;
        return this;
    }

    private Observable<String> getObservableDownloadFile() {
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<String>(){

            public void subscribe(ObservableEmitter<String> subscriber) throws Exception {
                if (!subscriber.isDisposed()) {
                    try {
                        if ("content".equalsIgnoreCase(DownloadImage.this.uri.getScheme())) {
                            subscriber.onNext((Object)DownloadImage.this.getContent());
                        } else {
                            subscriber.onNext((Object)DownloadImage.this.downloadFile());
                        }
                        subscriber.onComplete();
                    }
                    catch (FileNotFoundException e) {
                        subscriber.onError((Throwable)e);
                    }
                }
            }
        }).subscribeOn(Schedulers.io());
    }

    private String downloadFile() throws Exception {
        URL url = new URL(this.uri.toString());
        URLConnection connection = url.openConnection();
        connection.connect();
        BufferedInputStream inputStream = new BufferedInputStream(url.openStream(), 1024);
        String filename = this.getFilename(this.uri);
        filename = filename + this.imageUtils.getFileExtension(this.uri);
        File file = this.imageUtils.getPrivateFile(filename);
        this.imageUtils.copy(inputStream, file);
        return file.getAbsolutePath();
    }

    private String getContent() throws FileNotFoundException {
        InputStream inputStream = this.targetUi.getContext().getContentResolver().openInputStream(this.uri);
        String filename = this.getFilename(this.uri);
        filename = filename + this.imageUtils.getFileExtension(this.uri);
        File file = this.imageUtils.getPrivateFile(filename);
        this.imageUtils.copy(inputStream, file);
        return file.getAbsolutePath();
    }

    private String getFilename(Uri uri) {
        return uri.getLastPathSegment().replaceAll("[^A-Za-z0-9 ]", "");
    }
}

