/*
 * Decompiled with CFR 0.152.
 */
package com.miguelbcr.ui.rx_paparazzo2.internal.di;

import com.miguelbcr.ui.rx_paparazzo2.entities.Config;
import com.miguelbcr.ui.rx_paparazzo2.entities.TargetUi;
import com.miguelbcr.ui.rx_paparazzo2.interactors.CropImage;
import com.miguelbcr.ui.rx_paparazzo2.interactors.DownloadImage;
import com.miguelbcr.ui.rx_paparazzo2.interactors.GetDimens;
import com.miguelbcr.ui.rx_paparazzo2.interactors.GetPath;
import com.miguelbcr.ui.rx_paparazzo2.interactors.GrantPermissions;
import com.miguelbcr.ui.rx_paparazzo2.interactors.ImageUtils;
import com.miguelbcr.ui.rx_paparazzo2.interactors.PickImage;
import com.miguelbcr.ui.rx_paparazzo2.interactors.PickImages;
import com.miguelbcr.ui.rx_paparazzo2.interactors.SaveImage;
import com.miguelbcr.ui.rx_paparazzo2.interactors.StartIntent;
import com.miguelbcr.ui.rx_paparazzo2.interactors.TakePhoto;
import com.miguelbcr.ui.rx_paparazzo2.internal.di.ApplicationComponent;
import com.miguelbcr.ui.rx_paparazzo2.workers.Camera;
import com.miguelbcr.ui.rx_paparazzo2.workers.Gallery;

class ApplicationComponentImpl
extends ApplicationComponent {
    private final ImageUtils imageUtils;
    private final DownloadImage downloadImage;
    private final StartIntent startIntent;
    private final GetPath getPath;
    private final GetDimens getDimens;
    private final TakePhoto takePhoto;
    private final CropImage cropImage;
    private final SaveImage saveImage;
    private final GrantPermissions grantPermissions;
    private final PickImages pickImages;
    private final PickImage pickImage;
    private final Camera camera;
    private final Gallery gallery;

    public ApplicationComponentImpl(TargetUi ui, Config config) {
        this.startIntent = new StartIntent(ui);
        this.imageUtils = new ImageUtils(ui, config);
        this.downloadImage = new DownloadImage(ui, this.imageUtils);
        this.getPath = new GetPath(ui, this.downloadImage);
        this.takePhoto = new TakePhoto(this.startIntent, ui, this.imageUtils);
        this.getDimens = new GetDimens(ui, config, this.getPath);
        this.cropImage = new CropImage(ui, config, this.startIntent, this.getPath, this.imageUtils);
        this.saveImage = new SaveImage(ui, this.getPath, this.getDimens, this.imageUtils);
        this.grantPermissions = new GrantPermissions(ui);
        this.pickImages = new PickImages(this.startIntent);
        this.pickImage = new PickImage(this.startIntent, this.getPath);
        this.camera = new Camera(this.takePhoto, this.cropImage, this.saveImage, this.grantPermissions, ui, config);
        this.gallery = new Gallery(this.grantPermissions, this.pickImages, this.pickImage, this.cropImage, this.saveImage, ui, config);
    }

    @Override
    public Camera camera() {
        return this.camera;
    }

    @Override
    public Gallery gallery() {
        return this.gallery;
    }

    @Override
    public GetPath getPath() {
        return this.getPath;
    }
}

