/*
 * Decompiled with CFR 0.152.
 */
package com.miguelbcr.ui.rx_paparazzo2.interactors;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import android.support.v4.content.FileProvider;
import com.miguelbcr.ui.rx_paparazzo2.entities.TargetUi;
import com.miguelbcr.ui.rx_paparazzo2.interactors.ImageUtils;
import com.miguelbcr.ui.rx_paparazzo2.interactors.StartIntent;
import com.miguelbcr.ui.rx_paparazzo2.interactors.UseCase;
import io.reactivex.Observable;
import io.reactivex.functions.Function;
import java.io.File;
import java.util.List;

public final class TakePhoto
extends UseCase<Uri> {
    private static final int READ_WRITE_PERMISSIONS = 3;
    private final StartIntent startIntent;
    private final TargetUi targetUi;
    private final ImageUtils imageUtils;

    public TakePhoto(StartIntent startIntent, TargetUi targetUi, ImageUtils imageUtils) {
        this.startIntent = startIntent;
        this.targetUi = targetUi;
        this.imageUtils = imageUtils;
    }

    @Override
    public Observable<Uri> react() {
        final Uri uri = this.getUri();
        return this.startIntent.with(this.getIntentCamera(uri)).react().map((Function)new Function<Intent, Uri>(){

            public Uri apply(Intent data) throws Exception {
                TakePhoto.this.revokeFileReadWritePermissions(uri);
                return uri;
            }
        });
    }

    private Uri getUri() {
        Context context = this.targetUi.getContext();
        File file = this.imageUtils.getPrivateFile("shoot.jpg");
        String authority = context.getPackageName() + "." + "file_provider";
        return FileProvider.getUriForFile((Context)context, (String)authority, (File)file);
    }

    private Intent getIntentCamera(Uri uri) {
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        intent.addFlags(3);
        intent.putExtra("output", (Parcelable)uri);
        this.grantFileReadWritePermissions(intent, uri);
        return intent;
    }

    private void grantFileReadWritePermissions(Intent intent, Uri uri) {
        if (Build.VERSION.SDK_INT <= 19) {
            List resInfoList = this.targetUi.getContext().getPackageManager().queryIntentActivities(intent, 65536);
            for (ResolveInfo resolveInfo : resInfoList) {
                String packageName = resolveInfo.activityInfo.packageName;
                this.targetUi.getContext().grantUriPermission(packageName, uri, 3);
            }
        }
    }

    private void revokeFileReadWritePermissions(Uri uri) {
        if (Build.VERSION.SDK_INT <= 19) {
            this.targetUi.getContext().revokeUriPermission(uri, 3);
        }
    }
}

