/*
 * Decompiled with CFR 0.152.
 */
package com.miguelbcr.ui.rx_paparazzo2.interactors;

import android.content.Intent;
import android.net.Uri;
import com.miguelbcr.ui.rx_paparazzo2.entities.Config;
import com.miguelbcr.ui.rx_paparazzo2.entities.Options;
import com.miguelbcr.ui.rx_paparazzo2.entities.TargetUi;
import com.miguelbcr.ui.rx_paparazzo2.interactors.GetPath;
import com.miguelbcr.ui.rx_paparazzo2.interactors.ImageUtils;
import com.miguelbcr.ui.rx_paparazzo2.interactors.StartIntent;
import com.miguelbcr.ui.rx_paparazzo2.interactors.UseCase;
import com.yalantis.ucrop.UCrop;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.functions.BiFunction;
import io.reactivex.functions.Function;
import java.io.File;

public final class CropImage
extends UseCase<Uri> {
    private final Config config;
    private final StartIntent startIntent;
    private final GetPath getPath;
    private final TargetUi targetUi;
    private final ImageUtils imageUtils;
    private Uri uri;

    public CropImage(TargetUi targetUi, Config config, StartIntent startIntent, GetPath getPath, ImageUtils imageUtils) {
        this.targetUi = targetUi;
        this.config = config;
        this.startIntent = startIntent;
        this.getPath = getPath;
        this.imageUtils = imageUtils;
    }

    public CropImage with(Uri uri) {
        this.uri = uri;
        return this;
    }

    @Override
    public Observable<Uri> react() {
        if (this.config.doCrop()) {
            return this.getIntent().flatMap((Function)new Function<Intent, ObservableSource<Uri>>(){

                public ObservableSource<Uri> apply(Intent intent) throws Exception {
                    intent.addFlags(1);
                    return CropImage.this.startIntent.with(intent).react().map((Function)new Function<Intent, Uri>(){

                        public Uri apply(Intent intentResult) throws Exception {
                            return UCrop.getOutput((Intent)intentResult);
                        }
                    });
                }
            });
        }
        return this.getOutputUriNoCrop();
    }

    private Observable<Intent> getIntent() {
        return Observable.zip(this.getInputUri(), this.getOutputUriCrop(), (BiFunction)new BiFunction<Uri, Uri, Intent>(){

            public Intent apply(Uri uri, Uri outputUri) throws Exception {
                UCrop.Options options = CropImage.this.config.getOptions();
                if (options == null) {
                    return UCrop.of((Uri)uri, (Uri)outputUri).getIntent(CropImage.this.targetUi.getContext());
                }
                if (options instanceof Options) {
                    return CropImage.this.getIntentWithOptions((Options)options, outputUri);
                }
                return UCrop.of((Uri)uri, (Uri)outputUri).withOptions(CropImage.this.config.getOptions()).getIntent(CropImage.this.targetUi.getContext());
            }
        });
    }

    private Intent getIntentWithOptions(Options options, Uri outputUri) {
        UCrop uCrop = UCrop.of((Uri)this.uri, (Uri)outputUri);
        uCrop = uCrop.withOptions((UCrop.Options)options);
        if (options.getX() != 0.0f) {
            uCrop = uCrop.withAspectRatio(options.getX(), options.getY());
        }
        if (options.getWidth() != 0) {
            uCrop = uCrop.withMaxResultSize(options.getWidth(), options.getHeight());
        }
        return uCrop.getIntent(this.targetUi.getContext());
    }

    private Observable<Uri> getInputUri() {
        return this.getPath.with(this.uri).react().map((Function)new Function<String, Uri>(){

            public Uri apply(String filePath) throws Exception {
                return Uri.fromFile((File)new File(filePath)).buildUpon().build();
            }
        });
    }

    private Observable<Uri> getOutputUriCrop() {
        return this.getPath.with(this.uri).react().flatMap((Function)new Function<String, ObservableSource<Uri>>(){

            public ObservableSource<Uri> apply(String filepath) throws Exception {
                String extension = CropImage.this.imageUtils.getFileExtension(filepath);
                String filename = "cropped" + extension;
                File file = CropImage.this.imageUtils.getPrivateFile(filename);
                return Observable.just((Object)Uri.fromFile((File)file).buildUpon().build());
            }
        });
    }

    private Observable<Uri> getOutputUriNoCrop() {
        return this.getPath.with(this.uri).react().flatMap((Function)new Function<String, ObservableSource<Uri>>(){

            public ObservableSource<Uri> apply(String filepath) throws Exception {
                String extension = CropImage.this.imageUtils.getFileExtension(filepath);
                String filename = "no_cropped" + extension;
                File file = CropImage.this.imageUtils.getPrivateFile(filename);
                CropImage.this.imageUtils.copy(new File(filepath), file);
                return Observable.just((Object)Uri.fromFile((File)file).buildUpon().build());
            }
        });
    }
}

