/*
 * Decompiled with CFR 0.152.
 */
package com.fuck_boilerplate.rx_paparazzo.interactors;

import android.content.Intent;
import android.net.Uri;
import com.fuck_boilerplate.rx_paparazzo.entities.Config;
import com.fuck_boilerplate.rx_paparazzo.entities.Options;
import com.fuck_boilerplate.rx_paparazzo.entities.TargetUi;
import com.fuck_boilerplate.rx_paparazzo.interactors.GetPath;
import com.fuck_boilerplate.rx_paparazzo.interactors.ImageUtils;
import com.fuck_boilerplate.rx_paparazzo.interactors.StartIntent;
import com.fuck_boilerplate.rx_paparazzo.interactors.UseCase;
import com.yalantis.ucrop.UCrop;
import java.io.File;
import rx.Observable;
import rx.functions.Func1;
import rx.functions.Func2;

public final class CropImage
extends UseCase<Uri> {
    private final Config config;
    private final StartIntent startIntent;
    private final GetPath getPath;
    private final TargetUi targetUi;
    private final ImageUtils imageUtils;
    private Uri uri;

    public CropImage(TargetUi targetUi, Config config, StartIntent startIntent, GetPath getPath, ImageUtils imageUtils) {
        this.targetUi = targetUi;
        this.config = config;
        this.startIntent = startIntent;
        this.getPath = getPath;
        this.imageUtils = imageUtils;
    }

    public CropImage with(Uri uri) {
        this.uri = uri;
        return this;
    }

    @Override
    public Observable<Uri> react() {
        if (this.config.doCrop()) {
            return this.getIntent().flatMap((Func1)new Func1<Intent, Observable<Uri>>(){

                public Observable<Uri> call(Intent intent) {
                    intent.addFlags(1);
                    return CropImage.this.startIntent.with(intent).react().map((Func1)new Func1<Intent, Uri>(){

                        public Uri call(Intent intentResult) {
                            return UCrop.getOutput((Intent)intentResult);
                        }
                    });
                }
            });
        }
        return this.getOutputUriNoCrop();
    }

    private Observable<Intent> getIntent() {
        return Observable.zip(this.getInputUri(), this.getOutputUriCrop(), (Func2)new Func2<Uri, Uri, Intent>(){

            public Intent call(Uri uri, Uri outputUri) {
                UCrop.Options options = CropImage.this.config.getOptions();
                if (options == null) {
                    return UCrop.of((Uri)uri, (Uri)outputUri).getIntent(CropImage.this.targetUi.getContext());
                }
                if (options instanceof Options) {
                    return CropImage.this.getIntentWithOptions((Options)options, outputUri);
                }
                return UCrop.of((Uri)uri, (Uri)outputUri).withOptions(CropImage.this.config.getOptions()).getIntent(CropImage.this.targetUi.getContext());
            }
        });
    }

    private Intent getIntentWithOptions(Options options, Uri outputUri) {
        UCrop uCrop = UCrop.of((Uri)this.uri, (Uri)outputUri);
        uCrop = uCrop.withOptions((UCrop.Options)options);
        if (options.getX() != 0.0f) {
            uCrop = uCrop.withAspectRatio(options.getX(), options.getY());
        }
        if (options.getWidth() != 0) {
            uCrop = uCrop.withMaxResultSize(options.getWidth(), options.getHeight());
        }
        return uCrop.getIntent(this.targetUi.getContext());
    }

    private Observable<Uri> getInputUri() {
        return this.getPath.with(this.uri).react().map((Func1)new Func1<String, Uri>(){

            public Uri call(String filePath) {
                return Uri.fromFile((File)new File(filePath)).buildUpon().build();
            }
        });
    }

    private Observable<Uri> getOutputUriCrop() {
        return this.getPath.with(this.uri).react().flatMap((Func1)new Func1<String, Observable<Uri>>(){

            public Observable<Uri> call(String filepath) {
                String extension = CropImage.this.imageUtils.getFileExtension(filepath);
                String filename = "cropped" + extension;
                File file = CropImage.this.imageUtils.getPrivateFile(filename);
                return Observable.just((Object)Uri.fromFile((File)file).buildUpon().build());
            }
        });
    }

    private Observable<Uri> getOutputUriNoCrop() {
        return this.getPath.with(this.uri).react().flatMap((Func1)new Func1<String, Observable<Uri>>(){

            public Observable<Uri> call(String filepath) {
                String extension = CropImage.this.imageUtils.getFileExtension(filepath);
                String filename = "no_cropped" + extension;
                File file = CropImage.this.imageUtils.getPrivateFile(filename);
                CropImage.this.imageUtils.copyFile(filepath, file.getAbsolutePath());
                return Observable.just((Object)Uri.fromFile((File)file).buildUpon().build());
            }
        });
    }
}

