/*
 * Decompiled with CFR 0.152.
 */
package com.fuck_boilerplate.rx_paparazzo.interactors;

import android.graphics.BitmapFactory;
import android.net.Uri;
import android.util.DisplayMetrics;
import com.fuck_boilerplate.rx_paparazzo.entities.Config;
import com.fuck_boilerplate.rx_paparazzo.entities.Size;
import com.fuck_boilerplate.rx_paparazzo.entities.TargetUi;
import com.fuck_boilerplate.rx_paparazzo.interactors.GetPath;
import com.fuck_boilerplate.rx_paparazzo.interactors.UseCase;
import rx.Observable;
import rx.functions.Func1;

public final class GetDimens
extends UseCase<int[]> {
    private final TargetUi targetUi;
    private final Config config;
    private final GetPath getPath;
    private Uri uri;

    public GetDimens(TargetUi targetUi, Config config, GetPath getPath) {
        this.targetUi = targetUi;
        this.config = config;
        this.getPath = getPath;
    }

    public GetDimens with(Uri uri) {
        this.uri = uri;
        return this;
    }

    @Override
    public Observable<int[]> react() {
        return this.getPath.with(this.uri).react().map((Func1)new Func1<String, int[]>(){

            public int[] call(String filePath) {
                if (GetDimens.this.config.getSize() == Size.Original) {
                    return GetDimens.this.getFileDimens(filePath);
                }
                if (GetDimens.this.config.getSize() == Size.Screen) {
                    return GetDimens.this.getScreenDimens();
                }
                int[] dimens = GetDimens.this.getScreenDimens();
                return new int[]{dimens[0] / 8, dimens[1] / 8};
            }
        });
    }

    private int[] getScreenDimens() {
        DisplayMetrics metrics = this.targetUi.getContext().getResources().getDisplayMetrics();
        return new int[]{metrics.widthPixels, metrics.heightPixels};
    }

    private int[] getFileDimens(String filePath) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
        return new int[]{options.outWidth, options.outHeight};
    }
}

