/*
 * Decompiled with CFR 0.152.
 */
package lavalink.client.player;

import com.sedmelluq.discord.lavaplayer.player.AudioPlayer;
import com.sedmelluq.discord.lavaplayer.player.event.AudioEventListener;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioFrame;
import com.sedmelluq.discord.lavaplayer.track.playback.MutableAudioFrame;
import lavalink.client.player.IPlayer;
import lavalink.client.player.event.IPlayerEventListener;

public class LavaplayerPlayerWrapper
implements IPlayer {
    private final AudioPlayer player;

    public LavaplayerPlayerWrapper(AudioPlayer player) {
        this.player = player;
    }

    @Override
    public AudioTrack getPlayingTrack() {
        return this.player.getPlayingTrack();
    }

    @Override
    public void playTrack(AudioTrack track) {
        this.player.playTrack(track);
    }

    @Override
    public void stopTrack() {
        this.player.stopTrack();
    }

    @Override
    public void setPaused(boolean b) {
        this.player.setPaused(b);
    }

    @Override
    public boolean isPaused() {
        return this.player.isPaused();
    }

    @Override
    public long getTrackPosition() {
        if (this.player.getPlayingTrack() == null) {
            throw new IllegalStateException("Not playing anything");
        }
        return this.player.getPlayingTrack().getPosition();
    }

    @Override
    public void seekTo(long position) {
        if (this.player.getPlayingTrack() == null) {
            throw new IllegalStateException("Not playing anything");
        }
        this.player.getPlayingTrack().setPosition(position);
    }

    @Override
    public void setVolume(int volume) {
        this.player.setVolume(volume);
    }

    @Override
    public int getVolume() {
        return this.player.getVolume();
    }

    @Override
    public void addListener(IPlayerEventListener listener) {
        this.player.addListener((AudioEventListener)listener);
    }

    @Override
    public void removeListener(IPlayerEventListener listener) {
        this.player.removeListener((AudioEventListener)listener);
    }

    public AudioFrame provide() {
        return this.player.provide();
    }

    public boolean provide(MutableAudioFrame targetFrame) {
        return this.player.provide(targetFrame);
    }
}

