/*
 * Decompiled with CFR 0.152.
 */
package lavalink.client.io.jda;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.function.Function;
import lavalink.client.LavalinkUtil;
import lavalink.client.io.Lavalink;
import lavalink.client.io.jda.JDAVoiceInterceptor;
import lavalink.client.io.jda.JdaLink;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.events.GenericEvent;
import net.dv8tion.jda.api.events.ReconnectedEvent;
import net.dv8tion.jda.api.events.channel.voice.VoiceChannelDeleteEvent;
import net.dv8tion.jda.api.events.guild.GuildLeaveEvent;
import net.dv8tion.jda.api.hooks.EventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdaLavalink
extends Lavalink<JdaLink>
implements EventListener {
    private static final Logger log = LoggerFactory.getLogger(JdaLavalink.class);
    private final Function<Integer, JDA> jdaProvider;
    private boolean autoReconnect = true;
    private final JDAVoiceInterceptor voiceInterceptor;

    public JdaLavalink(String userId, int numShards, Function<Integer, JDA> jdaProvider) {
        super(userId, numShards);
        this.jdaProvider = jdaProvider;
        this.voiceInterceptor = new JDAVoiceInterceptor(this);
    }

    public boolean getAutoReconnect() {
        return this.autoReconnect;
    }

    public void setAutoReconnect(boolean autoReconnect) {
        this.autoReconnect = autoReconnect;
    }

    @NonNull
    public JdaLink getLink(Guild guild) {
        return (JdaLink)this.getLink(guild.getId());
    }

    @Nullable
    public JdaLink getExistingLink(Guild guild) {
        return (JdaLink)this.getExistingLink(guild.getId());
    }

    @NonNull
    public JDA getJda(int shardId) {
        return this.jdaProvider.apply(shardId);
    }

    @NonNull
    public JDA getJdaFromSnowflake(String snowflake) {
        return this.jdaProvider.apply(LavalinkUtil.getShardFromSnowflake(snowflake, this.numShards));
    }

    public JDAVoiceInterceptor getVoiceInterceptor() {
        return this.voiceInterceptor;
    }

    public void onEvent(GenericEvent event) {
        if (event instanceof ReconnectedEvent) {
            if (this.autoReconnect) {
                this.getLinksMap().forEach((guildId, link) -> {
                    try {
                        if (link.getLastChannel() != null && event.getJDA().getGuildById(guildId) != null) {
                            link.connect(event.getJDA().getVoiceChannelById(link.getLastChannel()), false);
                        }
                    }
                    catch (Exception e) {
                        log.error("Caught exception while trying to reconnect link " + link, (Throwable)e);
                    }
                });
            }
        } else if (event instanceof GuildLeaveEvent) {
            JdaLink link2 = (JdaLink)this.getLinksMap().get(((GuildLeaveEvent)event).getGuild().getId());
            if (link2 == null) {
                return;
            }
            link2.removeConnection();
        } else if (event instanceof VoiceChannelDeleteEvent) {
            VoiceChannelDeleteEvent e = (VoiceChannelDeleteEvent)event;
            JdaLink link3 = (JdaLink)this.getLinksMap().get(e.getGuild().getId());
            if (link3 == null || !e.getChannel().getId().equals(link3.getLastChannel())) {
                return;
            }
            link3.removeConnection();
        }
    }

    @Override
    protected JdaLink buildNewLink(String guildId) {
        return new JdaLink(this, guildId);
    }
}

