/*
 * Decompiled with CFR 0.152.
 */
package lavalink.client.io.jda;

import javax.annotation.Nonnull;
import lavalink.client.io.Link;
import lavalink.client.io.jda.JdaLavalink;
import lavalink.client.io.jda.JdaLink;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.VoiceChannel;
import net.dv8tion.jda.api.hooks.VoiceDispatchInterceptor;
import org.json.JSONObject;

public class JDAVoiceInterceptor
implements VoiceDispatchInterceptor {
    private final JdaLavalink lavalink;

    public JDAVoiceInterceptor(JdaLavalink lavalink) {
        this.lavalink = lavalink;
    }

    public void onVoiceServerUpdate(@Nonnull VoiceDispatchInterceptor.VoiceServerUpdate update) {
        JSONObject content = new JSONObject(update.toData().getObject("d").toMap());
        Guild guild = update.getGuild();
        if (guild == null) {
            throw new IllegalArgumentException("Attempted to start audio connection with Guild that doesn't exist! JSON: " + content);
        }
        this.lavalink.getLink(guild).onVoiceServerUpdate(content, guild.getSelfMember().getVoiceState().getSessionId());
    }

    public boolean onVoiceStateUpdate(@Nonnull VoiceDispatchInterceptor.VoiceStateUpdate update) {
        VoiceChannel channel = update.getChannel();
        JdaLink link = (JdaLink)this.lavalink.getLink(update.getGuildId());
        if (channel == null) {
            if (link.getState() != Link.State.DESTROYED) {
                link.onDisconnected();
            }
        } else {
            link.setChannel(channel.getId());
        }
        return link.getState() == Link.State.CONNECTED;
    }
}

