/*
 * Decompiled with CFR 0.152.
 */
package lavalink.client.io;

import org.json.JSONObject;

public class RemoteStats {
    private final JSONObject json;
    private final int players;
    private final int playingPlayers;
    private final long uptime;
    private final long memFree;
    private final long memUsed;
    private final long memAllocated;
    private final long memReservable;
    private final int cpuCores;
    private final double systemLoad;
    private final double lavalinkLoad;
    private int avgFramesSentPerMinute = -1;
    private int avgFramesNulledPerMinute = -1;
    private int avgFramesDeficitPerMinute = -1;

    RemoteStats(JSONObject json) {
        this.json = json;
        this.players = json.getInt("players");
        this.playingPlayers = json.getInt("playingPlayers");
        this.uptime = json.getLong("uptime");
        this.memFree = json.getJSONObject("memory").getLong("free");
        this.memUsed = json.getJSONObject("memory").getLong("used");
        this.memAllocated = json.getJSONObject("memory").getLong("allocated");
        this.memReservable = json.getJSONObject("memory").getLong("reservable");
        this.cpuCores = json.getJSONObject("cpu").getInt("cores");
        this.systemLoad = json.getJSONObject("cpu").getDouble("systemLoad");
        this.lavalinkLoad = json.getJSONObject("cpu").getDouble("lavalinkLoad");
        JSONObject frames = json.optJSONObject("frameStats");
        if (frames != null) {
            this.avgFramesSentPerMinute = frames.getInt("sent");
            this.avgFramesNulledPerMinute = frames.getInt("nulled");
            this.avgFramesDeficitPerMinute = frames.getInt("deficit");
        }
    }

    public JSONObject getAsJson() {
        return this.json;
    }

    public int getPlayers() {
        return this.players;
    }

    public int getPlayingPlayers() {
        return this.playingPlayers;
    }

    public long getUptime() {
        return this.uptime;
    }

    public long getMemFree() {
        return this.memFree;
    }

    public long getMemUsed() {
        return this.memUsed;
    }

    public long getMemAllocated() {
        return this.memAllocated;
    }

    public long getMemReservable() {
        return this.memReservable;
    }

    public int getCpuCores() {
        return this.cpuCores;
    }

    public double getSystemLoad() {
        return this.systemLoad;
    }

    public double getLavalinkLoad() {
        return this.lavalinkLoad;
    }

    public int getAvgFramesSentPerMinute() {
        return this.avgFramesSentPerMinute;
    }

    public int getAvgFramesNulledPerMinute() {
        return this.avgFramesNulledPerMinute;
    }

    public int getAvgFramesDeficitPerMinute() {
        return this.avgFramesDeficitPerMinute;
    }

    public String toString() {
        return "RemoteStats{players=" + this.players + ", playingPlayers=" + this.playingPlayers + ", uptime=" + this.uptime + ", memFree=" + this.memFree + ", memUsed=" + this.memUsed + ", memAllocated=" + this.memAllocated + ", memReservable=" + this.memReservable + ", cpuCores=" + this.cpuCores + ", systemLoad=" + this.systemLoad + ", lavalinkLoad=" + this.lavalinkLoad + ", avgFramesSentPerMinute=" + this.avgFramesSentPerMinute + ", avgFramesNulledPerMinute=" + this.avgFramesNulledPerMinute + ", avgFramesDeficitPerMinute=" + this.avgFramesDeficitPerMinute + '}';
    }
}

