/*
 * Decompiled with CFR 0.152.
 */
package lavalink.client.io;

import java.util.List;
import lavalink.client.io.Lavalink;
import lavalink.client.io.LavalinkSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconnectTask
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ReconnectTask.class);
    private Lavalink lavalink;

    ReconnectTask(Lavalink lavalink) {
        this.lavalink = lavalink;
    }

    @Override
    public void run() {
        try {
            List<LavalinkSocket> nodes = this.lavalink.getNodes();
            nodes.forEach(lavalinkSocket -> {
                if (lavalinkSocket.isClosed() && !lavalinkSocket.isConnecting() && System.currentTimeMillis() - lavalinkSocket.lastReconnectAttempt > lavalinkSocket.getReconnectInterval()) {
                    lavalinkSocket.attemptReconnect();
                }
            });
        }
        catch (Exception e) {
            log.error("Caught exception in reconnect thread", (Throwable)e);
        }
    }
}

