/*
 * Decompiled with CFR 0.152.
 */
package lavalink.client.io;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lavalink.client.io.Lavalink;
import lavalink.client.io.LavalinkSocket;
import lavalink.client.io.Link;
import lavalink.client.io.PenaltyProvider;
import lavalink.client.io.RemoteStats;

public class LavalinkLoadBalancer {
    private Lavalink lavalink;
    private List<PenaltyProvider> penaltyProviders = new ArrayList<PenaltyProvider>();

    LavalinkLoadBalancer(Lavalink lavalink) {
        this.lavalink = lavalink;
    }

    @NonNull
    public LavalinkSocket determineBestSocket(long guild) {
        LavalinkSocket leastPenalty = null;
        int record = Integer.MAX_VALUE;
        List<LavalinkSocket> nodes = this.lavalink.getNodes();
        for (LavalinkSocket socket : nodes) {
            int total = this.getPenalties(socket, guild, this.penaltyProviders).getTotal();
            if (total >= record) continue;
            leastPenalty = socket;
            record = total;
        }
        if (leastPenalty == null || !leastPenalty.isAvailable()) {
            throw new IllegalStateException("No available nodes!");
        }
        return leastPenalty;
    }

    public void addPenalty(PenaltyProvider penalty) {
        this.penaltyProviders.add(penalty);
    }

    public void removePenalty(PenaltyProvider penalty) {
        this.penaltyProviders.remove(penalty);
    }

    void onNodeDisconnect(LavalinkSocket disconnected) {
        Collection<Link> links = this.lavalink.getLinks();
        links.forEach(link -> {
            if (disconnected.equals(link.getNode(false))) {
                link.changeNode(this.lavalink.loadBalancer.determineBestSocket(link.getGuildIdLong()));
            }
        });
    }

    void onNodeConnect(LavalinkSocket connected) {
        List<LavalinkSocket> sockets = this.lavalink.getNodes();
        long otherAvailableNodes = sockets.stream().filter(node -> node != connected).filter(LavalinkSocket::isAvailable).count();
        if (otherAvailableNodes > 0L) {
            return;
        }
        Collection<Link> links = this.lavalink.getLinks();
        links.forEach(link -> {
            if (link.getNode(false) == null) {
                link.changeNode(connected);
            }
        });
    }

    public Penalties getPenalties(LavalinkSocket socket, long guild, List<PenaltyProvider> penaltyProviders) {
        return new Penalties(socket, guild, penaltyProviders, this.lavalink);
    }

    public static Penalties getPenalties(LavalinkSocket socket) {
        return new Penalties(socket, 0L, Collections.emptyList(), null);
    }

    public static class Penalties {
        private LavalinkSocket socket;
        private final long guild;
        private int playerPenalty = 0;
        private int cpuPenalty = 0;
        private int deficitFramePenalty = 0;
        private int nullFramePenalty = 0;
        private int customPenalties = 0;
        private final Lavalink lavalink;

        private Penalties(LavalinkSocket socket, long guild, List<PenaltyProvider> penaltyProviders, Lavalink lavalink) {
            this.lavalink = lavalink;
            this.socket = socket;
            this.guild = guild;
            RemoteStats stats = socket.getStats();
            if (stats == null) {
                return;
            }
            this.playerPenalty = lavalink != null ? this.countPlayingPlayers() : stats.getPlayingPlayers();
            this.cpuPenalty = (int)Math.pow(1.05, 100.0 * stats.getSystemLoad()) * 10 - 10;
            if (stats.getAvgFramesDeficitPerMinute() != -1) {
                this.deficitFramePenalty = (int)(Math.pow(1.03, 500.0f * ((float)stats.getAvgFramesDeficitPerMinute() / 3000.0f)) * 600.0 - 600.0);
                this.nullFramePenalty = (int)(Math.pow(1.03, 500.0f * ((float)stats.getAvgFramesNulledPerMinute() / 3000.0f)) * 300.0 - 300.0);
                this.nullFramePenalty *= 2;
            }
            penaltyProviders.forEach(pp -> this.customPenalties += pp.getPenalty(this));
        }

        private int countPlayingPlayers() {
            Collection links = this.lavalink.getLinks();
            Long players = links.stream().filter(link -> this.socket.equals(link.getNode(false)) && link.getPlayer().getPlayingTrack() != null && !link.getPlayer().isPaused()).count();
            return players.intValue();
        }

        public LavalinkSocket getSocket() {
            return this.socket;
        }

        public long getGuild() {
            return this.guild;
        }

        public int getPlayerPenalty() {
            return this.playerPenalty;
        }

        public int getCpuPenalty() {
            return this.cpuPenalty;
        }

        public int getDeficitFramePenalty() {
            return this.deficitFramePenalty;
        }

        public int getNullFramePenalty() {
            return this.nullFramePenalty;
        }

        public int getCustomPenalties() {
            return this.customPenalties;
        }

        public int getTotal() {
            if (!this.socket.isAvailable() || this.socket.getStats() == null) {
                return 0x7FFFFFFE;
            }
            return this.playerPenalty + this.cpuPenalty + this.deficitFramePenalty + this.nullFramePenalty + this.customPenalties;
        }

        public String toString() {
            if (!this.socket.isAvailable()) {
                return "Penalties{unavailable=2147483646}";
            }
            return "Penalties{total=" + this.getTotal() + ", playerPenalty=" + this.playerPenalty + ", cpuPenalty=" + this.cpuPenalty + ", deficitFramePenalty=" + this.deficitFramePenalty + ", nullFramePenalty=" + this.nullFramePenalty + ", custom=" + this.customPenalties + '}';
        }
    }
}

