/*
 * Decompiled with CFR 0.152.
 */
package lavalink.client.io;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import lavalink.client.io.LavalinkLoadBalancer;
import lavalink.client.io.LavalinkSocket;
import lavalink.client.io.Link;
import lavalink.client.io.ReconnectTask;
import lavalink.client.io.ReusableWebSocket;
import org.java_websocket.drafts.Draft;
import org.java_websocket.drafts.Draft_6455;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Lavalink<T extends Link> {
    private static final Logger log = LoggerFactory.getLogger(Lavalink.class);
    protected final int numShards;
    private final String userId;
    private final ConcurrentHashMap<String, T> links = new ConcurrentHashMap();
    final List<LavalinkSocket> nodes = new CopyOnWriteArrayList<LavalinkSocket>();
    final LavalinkLoadBalancer loadBalancer = new LavalinkLoadBalancer(this);
    private final ScheduledExecutorService reconnectService;
    private static final AtomicInteger nodeCounter = new AtomicInteger(0);

    public Lavalink(String userId, int numShards) {
        this.userId = userId;
        this.numShards = numShards;
        this.reconnectService = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread thread = new Thread(r, "lavalink-reconnect-thread");
            thread.setDaemon(true);
            return thread;
        });
        this.reconnectService.scheduleWithFixedDelay(new ReconnectTask(this), 0L, 500L, TimeUnit.MILLISECONDS);
    }

    public void addNode(@NonNull URI serverUri, @NonNull String password) {
        this.addNode("Lavalink_Node_#" + nodeCounter.getAndIncrement(), serverUri, password);
    }

    public void addNode(@NonNull String name, @NonNull URI serverUri, @NonNull String password) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", password);
        headers.put("Num-Shards", Integer.toString(this.numShards));
        headers.put("User-Id", this.userId);
        LavalinkSocket socket = new LavalinkSocket(name, this, serverUri, (Draft)new Draft_6455(), headers);
        socket.connect();
        this.nodes.add(socket);
    }

    public void removeNode(int key) {
        LavalinkSocket node = this.nodes.remove(key);
        node.close();
    }

    @NonNull
    public LavalinkLoadBalancer getLoadBalancer() {
        return this.loadBalancer;
    }

    @NonNull
    public T getLink(@NonNull String guildId) {
        return (T)this.links.computeIfAbsent(guildId, __ -> this.buildNewLink(guildId));
    }

    @Nullable
    public T getExistingLink(@NonNull String guildId) {
        return (T)((Link)this.links.get(guildId));
    }

    protected abstract T buildNewLink(String var1);

    public int getNumShards() {
        return this.numShards;
    }

    @NonNull
    public Collection<T> getLinks() {
        return this.links.values();
    }

    @NonNull
    public List<LavalinkSocket> getNodes() {
        return this.nodes;
    }

    public void shutdown() {
        this.reconnectService.shutdown();
        this.nodes.forEach(ReusableWebSocket::close);
    }

    void removeDestroyedLink(Link link) {
        log.info("Destroyed link for guild " + link.getGuildId());
        this.links.remove(link.getGuildId());
    }

    protected Map<String, T> getLinksMap() {
        return this.links;
    }
}

