/*
 * Decompiled with CFR 0.152.
 */
package com.foysaltech.scratchcardlayout.ui;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewParent;
import com.foysaltech.scratchcardlayout.R;
import com.foysaltech.scratchcardlayout.listener.ScratchListener;
import com.foysaltech.scratchcardlayout.ui.ScratchCardLayout;
import com.foysaltech.scratchcardlayout.util.ScratchCardUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001:\u00019B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\u001f\u001a\u00020 2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0002J\b\u0010!\u001a\u00020 H\u0014J\u0010\u0010\"\u001a\u00020 2\u0006\u0010#\u001a\u00020\fH\u0014J(\u0010$\u001a\u00020 2\u0006\u0010%\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\u0007H\u0014J\u0010\u0010)\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020+H\u0017J\u0006\u0010,\u001a\u00020 J\u0006\u0010-\u001a\u00020 J\u0010\u0010.\u001a\u00020 2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u000e\u0010/\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020\u0007J\u0010\u00100\u001a\u00020 2\b\u00101\u001a\u0004\u0018\u000102J\u0010\u00103\u001a\u00020 2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dJ\u000e\u00104\u001a\u00020 2\u0006\u00105\u001a\u00020\u000eJ\u000e\u00106\u001a\u00020 2\u0006\u0010\u001e\u001a\u00020\u0012J\b\u00107\u001a\u00020 H\u0002J\b\u00108\u001a\u00020 H\u0002R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/foysaltech/scratchcardlayout/ui/ScratchCard;", "Landroid/view/View;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyle", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "mBitmap", "Landroid/graphics/Bitmap;", "mCanvas", "Landroid/graphics/Canvas;", "mEnableScratching", "", "mInnerPaint", "Landroid/graphics/Paint;", "mLastTouchX", "", "mLastTouchY", "mListener", "Lcom/foysaltech/scratchcardlayout/listener/ScratchListener;", "mOuterPaint", "mPath", "Landroid/graphics/Path;", "mRevealFullAtPercent", "mRevealListener", "Lcom/foysaltech/scratchcardlayout/ui/ScratchCard$ScratchCardInterface;", "mScratchDrawable", "Landroid/graphics/drawable/Drawable;", "mScratchWidth", "init", "", "onDetachedFromWindow", "onDraw", "canvas", "onSizeChanged", "w", "h", "oldWidth", "oldHeight", "onTouchEvent", "event", "Landroid/view/MotionEvent;", "resetScratch", "revealScratch", "setListener", "setRevealFullAtPercent", "setRevealListener", "scratchCardLayout", "Lcom/foysaltech/scratchcardlayout/ui/ScratchCardLayout;", "setScratchDrawable", "setScratchEnabled", "enableScratching", "setScratchWidthDip", "setupScratchDrawableOnView", "stopScratchingAndRevealFull", "ScratchCardInterface", "scratchcardlayout_release"})
public final class ScratchCard
extends View {
    @Nullable
    private Path mPath;
    @Nullable
    private Paint mInnerPaint;
    @Nullable
    private Paint mOuterPaint;
    @Nullable
    private Bitmap mBitmap;
    @Nullable
    private Canvas mCanvas;
    @Nullable
    private Drawable mScratchDrawable;
    @Nullable
    private ScratchListener mListener;
    private float mScratchWidth;
    private float mLastTouchX;
    private float mLastTouchY;
    private int mRevealFullAtPercent;
    @Nullable
    private ScratchCardInterface mRevealListener;
    private boolean mEnableScratching;

    public ScratchCard(@NotNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyle);
        this.init(context, attrs);
    }

    private final void init(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ScratchCardLayout);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"obtainStyledAttributes(...)");
        TypedArray a = typedArray;
        this.mScratchDrawable = a.getDrawable(R.styleable.ScratchCardLayout_scratchDrawable);
        this.mScratchWidth = a.getDimension(R.styleable.ScratchCardLayout_scratchWidth, ScratchCardUtils.INSTANCE.dipToPx(context, 30.0f));
        this.mRevealFullAtPercent = a.getInteger(R.styleable.ScratchCardLayout_scratchRevealFullAtPercent, 100);
        this.mEnableScratching = a.getBoolean(R.styleable.ScratchCardLayout_scratchEnabled, true);
        a.recycle();
    }

    protected void onSizeChanged(int w, int h, int oldWidth, int oldHeight) {
        super.onSizeChanged(w, h, oldWidth, oldHeight);
        this.setupScratchDrawableOnView();
        if (this.mPath == null) {
            this.mPath = new Path();
        }
        if (this.mInnerPaint == null) {
            Paint paint = this.mInnerPaint = new Paint();
            Intrinsics.checkNotNull((Object)paint);
            paint.setAntiAlias(true);
            Paint paint2 = this.mInnerPaint;
            Intrinsics.checkNotNull((Object)paint2);
            paint2.setDither(true);
            Paint paint3 = this.mInnerPaint;
            Intrinsics.checkNotNull((Object)paint3);
            paint3.setStyle(Paint.Style.STROKE);
            Paint paint4 = this.mInnerPaint;
            Intrinsics.checkNotNull((Object)paint4);
            paint4.setFilterBitmap(true);
            Paint paint5 = this.mInnerPaint;
            Intrinsics.checkNotNull((Object)paint5);
            paint5.setStrokeJoin(Paint.Join.ROUND);
            Paint paint6 = this.mInnerPaint;
            Intrinsics.checkNotNull((Object)paint6);
            paint6.setStrokeCap(Paint.Cap.ROUND);
            Paint paint7 = this.mInnerPaint;
            Intrinsics.checkNotNull((Object)paint7);
            paint7.setStrokeWidth(this.mScratchWidth);
            Paint paint8 = this.mInnerPaint;
            Intrinsics.checkNotNull((Object)paint8);
            paint8.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
        }
        if (this.mOuterPaint == null) {
            this.mOuterPaint = new Paint();
        }
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.mEnableScratching) {
            return true;
        }
        float currentTouchX = event.getX();
        float currentTouchY = event.getY();
        switch (event.getAction()) {
            case 0: {
                Path path = this.mPath;
                if (path != null) {
                    path.reset();
                }
                Path path2 = this.mPath;
                if (path2 != null) {
                    path2.moveTo(event.getX(), event.getY());
                }
                break;
            }
            case 1: {
                Path path = this.mPath;
                if (path != null) {
                    path.lineTo(currentTouchX, currentTouchY);
                }
                break;
            }
            case 2: {
                float dx = Math.abs(currentTouchX - this.mLastTouchX);
                float dy = Math.abs(currentTouchY - this.mLastTouchY);
                if (dx >= 4.0f || dy >= 4.0f) {
                    float x1 = this.mLastTouchX;
                    float y1 = this.mLastTouchY;
                    float x2 = (currentTouchX + this.mLastTouchX) / (float)2;
                    float y2 = (currentTouchY + this.mLastTouchY) / (float)2;
                    Path path = this.mPath;
                    if (path != null) {
                        path.quadTo(x1, y1, x2, y2);
                    }
                }
                if (this.mListener == null) break;
                Bitmap bitmap = this.mBitmap;
                Integer width = bitmap != null ? Integer.valueOf(bitmap.getWidth()) : null;
                Bitmap bitmap2 = this.mBitmap;
                Integer height = bitmap2 != null ? Integer.valueOf(bitmap2.getHeight()) : null;
                Integer n = width;
                Intrinsics.checkNotNull((Object)n);
                int n2 = n;
                Integer n3 = height;
                Intrinsics.checkNotNull((Object)n3);
                int total = n2 * n3;
                int count = 0;
                for (int i = 0; i < width; i += 3) {
                    for (int j = 0; j < height; j += 3) {
                        Bitmap bitmap3 = this.mBitmap;
                        boolean bl = bitmap3 != null ? bitmap3.getPixel(i, j) == 0 : false;
                        if (!bl) continue;
                        ++count;
                    }
                }
                int percentCompleted = (int)((float)count / (float)total * (float)9 * (float)100);
                if (percentCompleted == 0) {
                    ScratchListener scratchListener = this.mListener;
                    if (scratchListener != null) {
                        scratchListener.onScratchStarted();
                    }
                    break;
                }
                if (percentCompleted == 100) {
                    this.stopScratchingAndRevealFull();
                    break;
                }
                if (percentCompleted >= this.mRevealFullAtPercent) {
                    this.stopScratchingAndRevealFull();
                    break;
                }
                ScratchListener scratchListener = this.mListener;
                if (scratchListener == null) break;
                ViewParent viewParent = this.getParent();
                Intrinsics.checkNotNull((Object)viewParent, (String)"null cannot be cast to non-null type com.foysaltech.scratchcardlayout.ui.ScratchCardLayout");
                scratchListener.onScratchProgress((ScratchCardLayout)viewParent, percentCompleted);
                break;
            }
        }
        Canvas canvas = this.mCanvas;
        if (canvas != null) {
            Path path = this.mPath;
            Intrinsics.checkNotNull((Object)path);
            Paint paint = this.mInnerPaint;
            Intrinsics.checkNotNull((Object)paint);
            canvas.drawPath(path, paint);
        }
        this.mLastTouchX = currentTouchX;
        this.mLastTouchY = currentTouchY;
        this.invalidate();
        return true;
    }

    private final void stopScratchingAndRevealFull() {
        block3: {
            if (this.mListener == null) break block3;
            if (this.mRevealListener != null) {
                ScratchCardInterface scratchCardInterface = this.mRevealListener;
                if (scratchCardInterface != null) {
                    scratchCardInterface.onFullReveal();
                }
            }
            ScratchListener scratchListener = this.mListener;
            if (scratchListener != null) {
                scratchListener.onScratchComplete();
            }
        }
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Bitmap bitmap = this.mBitmap;
        Intrinsics.checkNotNull((Object)bitmap);
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, this.mOuterPaint);
        super.onDraw(canvas);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mBitmap != null) {
            Bitmap bitmap = this.mBitmap;
            if (bitmap != null) {
                bitmap.recycle();
            }
            this.mBitmap = null;
        }
    }

    public final void setScratchDrawable(@Nullable Drawable mScratchDrawable) {
        this.mScratchDrawable = mScratchDrawable;
    }

    public final void setScratchWidthDip(float mScratchWidth) {
        this.mScratchWidth = mScratchWidth;
        if (this.mInnerPaint != null) {
            Paint paint = this.mInnerPaint;
            if (paint != null) {
                paint.setStrokeWidth(mScratchWidth);
            }
        }
    }

    public final void setListener(@Nullable ScratchListener mListener) {
        this.mListener = mListener;
    }

    public final void setRevealFullAtPercent(int mRevealFullAtPercent) {
        this.mRevealFullAtPercent = mRevealFullAtPercent;
    }

    public final void setRevealListener(@Nullable ScratchCardLayout scratchCardLayout) {
        this.mRevealListener = scratchCardLayout;
    }

    public final void setScratchEnabled(boolean enableScratching) {
        this.mEnableScratching = enableScratching;
    }

    public final void resetScratch() {
        if (this.getWidth() != 0 && this.getHeight() != 0) {
            this.setVisibility(0);
            this.setupScratchDrawableOnView();
            this.invalidate();
        }
    }

    public final void revealScratch() {
        this.stopScratchingAndRevealFull();
    }

    private final void setupScratchDrawableOnView() {
        if (this.mBitmap != null) {
            Bitmap bitmap = this.mBitmap;
            Intrinsics.checkNotNull((Object)bitmap);
            bitmap.recycle();
        }
        Bitmap bitmap = this.mBitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Intrinsics.checkNotNull((Object)bitmap);
        this.mCanvas = new Canvas(bitmap);
        if (this.mScratchDrawable != null) {
            Drawable drawable = this.mScratchDrawable;
            if (drawable != null) {
                Bitmap bitmap2 = this.mBitmap;
                Intrinsics.checkNotNull((Object)bitmap2);
                int n = bitmap2.getWidth();
                Bitmap bitmap3 = this.mBitmap;
                Intrinsics.checkNotNull((Object)bitmap3);
                drawable.setBounds(0, 0, n, bitmap3.getHeight());
            }
            Drawable drawable2 = this.mScratchDrawable;
            if (drawable2 != null) {
                Canvas canvas = this.mCanvas;
                Intrinsics.checkNotNull((Object)canvas);
                drawable2.draw(canvas);
            }
        } else {
            Canvas canvas = this.mCanvas;
            Intrinsics.checkNotNull((Object)canvas);
            canvas.drawColor(-4144960);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\b`\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lcom/foysaltech/scratchcardlayout/ui/ScratchCard$ScratchCardInterface;", "", "onFullReveal", "", "scratchcardlayout_release"})
    public static interface ScratchCardInterface {
        public void onFullReveal();
    }
}

