/*
 * Decompiled with CFR 0.152.
 */
package com.nafis.bottomnavigation;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.RippleDrawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import androidx.core.view.ViewCompat;
import androidx.core.widget.ImageViewCompat;
import androidx.databinding.DataBindingUtil;
import androidx.interpolator.view.animation.FastOutSlowInInterpolator;
import com.nafis.bottomnavigation.NafisBottomNavigationCell;
import com.nafis.bottomnavigation.R;
import com.nafis.bottomnavigation.UtilsKt;
import com.nafis.bottomnavigation.databinding.MeowNavigationCellBinding;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0017\u0018\u0000 S2\u00020\u0001:\u0001SB%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010K\u001a\u00020=2\u0006\u0010L\u001a\u00020\n2\b\b\u0002\u0010M\u001a\u00020\nH\u0002J\u0010\u0010N\u001a\u00020=2\b\b\u0002\u0010M\u001a\u00020\nJ\b\u0010O\u001a\u00020=H\u0002J\u0010\u0010L\u001a\u00020=2\b\b\u0002\u0010M\u001a\u00020\nJ\u0018\u0010P\u001a\u00020=2\u0006\u0010Q\u001a\u00020\u00072\u0006\u0010R\u001a\u00020\u0007H\u0014R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R(\u0010\u0015\u001a\u0004\u0018\u00010\u00142\b\u0010\u000e\u001a\u0004\u0018\u00010\u0014@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R$\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0011\"\u0004\b\u001c\u0010\u0013R$\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0011\"\u0004\b\u001f\u0010\u0013R(\u0010!\u001a\u0004\u0018\u00010 2\b\u0010\u000e\u001a\u0004\u0018\u00010 @FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R$\u0010&\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u0011\"\u0004\b(\u0010\u0013R\u001a\u0010)\u001a\u00020*X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R$\u0010/\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\u0011\"\u0004\b1\u0010\u0013R\u001e\u00103\u001a\u0002022\u0006\u0010\u000e\u001a\u000202@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b4\u00105R$\u00106\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00107\"\u0004\b8\u00109R\u001a\u0010:\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u00107\"\u0004\b;\u00109R0\u0010>\u001a\b\u0012\u0004\u0012\u00020=0<2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020=0<@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010@\"\u0004\bA\u0010BR\u001e\u0010C\u001a\u0002022\u0006\u0010\u000e\u001a\u000202@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\bD\u00105R$\u0010E\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bF\u0010\u0011\"\u0004\bG\u0010\u0013R$\u0010H\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bI\u0010\u0011\"\u0004\bJ\u0010\u0013\u00a8\u0006T"}, d2={"Lcom/nafis/bottomnavigation/NafisBottomNavigationCell;", "Landroid/widget/RelativeLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttrs", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "allowDraw", "", "binding", "Lcom/nafis/bottomnavigation/databinding/MeowNavigationCellBinding;", "kotlin.jvm.PlatformType", "value", "circleColor", "getCircleColor", "()I", "setCircleColor", "(I)V", "", "count", "getCount", "()Ljava/lang/String;", "setCount", "(Ljava/lang/String;)V", "countBackgroundColor", "getCountBackgroundColor", "setCountBackgroundColor", "countTextColor", "getCountTextColor", "setCountTextColor", "Landroid/graphics/Typeface;", "countTypeface", "getCountTypeface", "()Landroid/graphics/Typeface;", "setCountTypeface", "(Landroid/graphics/Typeface;)V", "defaultIconColor", "getDefaultIconColor", "setDefaultIconColor", "duration", "", "getDuration", "()J", "setDuration", "(J)V", "icon", "getIcon", "setIcon", "", "iconSize", "setIconSize", "(F)V", "isEnabledCell", "()Z", "setEnabledCell", "(Z)V", "isFromLeft", "setFromLeft", "Lkotlin/Function0;", "", "onClickListener", "getOnClickListener", "()Lkotlin/jvm/functions/Function0;", "setOnClickListener", "(Lkotlin/jvm/functions/Function0;)V", "progress", "setProgress", "rippleColor", "getRippleColor", "setRippleColor", "selectedIconColor", "getSelectedIconColor", "setSelectedIconColor", "animateProgress", "enableCell", "isAnimate", "disableCell", "draw", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "Companion", "NafisBottomNavigation_release"})
@SourceDebugExtension(value={"SMAP\nNafisBottomNavigationCell.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NafisBottomNavigationCell.kt\ncom/nafis/bottomnavigation/NafisBottomNavigationCell\n+ 2 Utils.kt\ncom/nafis/bottomnavigation/UtilsKt\n*L\n1#1,249:1\n76#2,7:250\n*S KotlinDebug\n*F\n+ 1 NafisBottomNavigationCell.kt\ncom/nafis/bottomnavigation/NafisBottomNavigationCell\n*L\n180#1:250,7\n*E\n"})
public final class NafisBottomNavigationCell
extends RelativeLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final MeowNavigationCellBinding binding;
    private int defaultIconColor;
    private int selectedIconColor;
    private int circleColor;
    private int icon;
    @Nullable
    private String count;
    private float iconSize;
    private int countTextColor;
    private int countBackgroundColor;
    @Nullable
    private Typeface countTypeface;
    private int rippleColor;
    private boolean isFromLeft;
    private long duration;
    private float progress;
    private boolean isEnabledCell;
    @NotNull
    private Function0<Unit> onClickListener;
    private boolean allowDraw;
    @NotNull
    public static final String EMPTY_VALUE = "empty";

    @JvmOverloads
    public NafisBottomNavigationCell(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttrs);
        this.binding = (MeowNavigationCellBinding)DataBindingUtil.inflate((LayoutInflater)LayoutInflater.from((Context)context), (int)R.layout.meow_navigation_cell, (ViewGroup)((ViewGroup)this), (boolean)true);
        this.count = EMPTY_VALUE;
        this.iconSize = UtilsKt.dp(48.0f, context);
        this.onClickListener = onClickListener.1.INSTANCE;
        this.allowDraw = true;
        this.draw();
    }

    public /* synthetic */ NafisBottomNavigationCell(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    public final int getDefaultIconColor() {
        return this.defaultIconColor;
    }

    public final void setDefaultIconColor(int value) {
        this.defaultIconColor = value;
        if (this.allowDraw) {
            ImageViewCompat.setImageTintList((ImageView)this.binding.iv, (ColorStateList)UtilsKt.ofColorStateList(!this.isEnabledCell ? this.defaultIconColor : this.selectedIconColor));
        }
    }

    public final int getSelectedIconColor() {
        return this.selectedIconColor;
    }

    public final void setSelectedIconColor(int value) {
        this.selectedIconColor = value;
        if (this.allowDraw) {
            ImageViewCompat.setImageTintList((ImageView)this.binding.iv, (ColorStateList)UtilsKt.ofColorStateList(!this.isEnabledCell ? this.defaultIconColor : this.selectedIconColor));
        }
    }

    public final int getCircleColor() {
        return this.circleColor;
    }

    public final void setCircleColor(int value) {
        this.circleColor = value;
        if (this.allowDraw) {
            this.setEnabledCell(this.isEnabledCell);
        }
    }

    public final int getIcon() {
        return this.icon;
    }

    public final void setIcon(int value) {
        this.icon = value;
        if (this.allowDraw) {
            this.binding.iv.setImageResource(value);
        }
    }

    @Nullable
    public final String getCount() {
        return this.count;
    }

    public final void setCount(@Nullable String value) {
        this.count = value;
        if (this.allowDraw) {
            if (this.count != null && Intrinsics.areEqual((Object)this.count, (Object)EMPTY_VALUE)) {
                this.binding.tvCount.setText((CharSequence)"");
                this.binding.tvCount.setVisibility(4);
            } else {
                if (this.count != null) {
                    String string = this.count;
                    if ((string != null ? string.length() : 0) >= 3) {
                        String string2;
                        StringBuilder stringBuilder = new StringBuilder();
                        String string3 = this.count;
                        if (string3 != null) {
                            String string4 = string3.substring(0, 1);
                            string2 = string4;
                            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                        } else {
                            string2 = null;
                        }
                        this.count = stringBuilder.append(string2).append("..").toString();
                    }
                }
                this.binding.tvCount.setText((CharSequence)this.count);
                this.binding.tvCount.setVisibility(0);
                String string = this.count;
                float scale = (string != null ? ((CharSequence)string).length() == 0 : false) ? 0.5f : 1.0f;
                this.binding.tvCount.setScaleX(scale);
                this.binding.tvCount.setScaleY(scale);
            }
        }
    }

    private final void setIconSize(float value) {
        this.iconSize = value;
        if (this.allowDraw) {
            UtilsKt.updateLayoutParams((View)this.binding.iv, (Function1)new Function1<FrameLayout.LayoutParams, Unit>(value){
                final /* synthetic */ float $value;
                {
                    this.$value = $value;
                    super(1);
                }

                public final void invoke(@NotNull FrameLayout.LayoutParams it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    it.width = (int)this.$value;
                    it.height = (int)this.$value;
                }
            });
            this.binding.iv.setPivotX(this.iconSize / 2.0f);
            this.binding.iv.setPivotY(this.iconSize / 2.0f);
        }
    }

    public final int getCountTextColor() {
        return this.countTextColor;
    }

    public final void setCountTextColor(int value) {
        this.countTextColor = value;
        if (this.allowDraw) {
            this.binding.tvCount.setTextColor(this.countTextColor);
        }
    }

    public final int getCountBackgroundColor() {
        return this.countBackgroundColor;
    }

    public final void setCountBackgroundColor(int value) {
        this.countBackgroundColor = value;
        if (this.allowDraw) {
            GradientDrawable d = new GradientDrawable();
            d.setColor(this.countBackgroundColor);
            d.setShape(1);
            ViewCompat.setBackground((View)((View)this.binding.tvCount), (Drawable)((Drawable)d));
        }
    }

    @Nullable
    public final Typeface getCountTypeface() {
        return this.countTypeface;
    }

    public final void setCountTypeface(@Nullable Typeface value) {
        this.countTypeface = value;
        if (this.allowDraw && this.countTypeface != null) {
            this.binding.tvCount.setTypeface(this.countTypeface);
        }
    }

    public final int getRippleColor() {
        return this.rippleColor;
    }

    public final void setRippleColor(int value) {
        this.rippleColor = value;
        if (this.allowDraw) {
            this.setEnabledCell(this.isEnabledCell);
        }
    }

    public final boolean isFromLeft() {
        return this.isFromLeft;
    }

    public final void setFromLeft(boolean bl) {
        this.isFromLeft = bl;
    }

    public final long getDuration() {
        return this.duration;
    }

    public final void setDuration(long l) {
        this.duration = l;
    }

    private final void setProgress(float value) {
        float f;
        this.progress = value;
        FrameLayout frameLayout = this.binding.fl;
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        float f2 = (1.0f - this.progress) * UtilsKt.dp(18.0f, context);
        Context context2 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"getContext(...)");
        frameLayout.setY(f2 - UtilsKt.dp(3.0f, context2));
        ImageViewCompat.setImageTintList((ImageView)this.binding.iv, (ColorStateList)UtilsKt.ofColorStateList(this.progress == 1.0f ? this.selectedIconColor : this.defaultIconColor));
        float scale = (1.0f - this.progress) * -0.2f + 1.0f;
        this.binding.iv.setScaleX(scale);
        this.binding.iv.setScaleY(scale);
        GradientDrawable d = new GradientDrawable();
        d.setColor(this.circleColor);
        d.setShape(1);
        ViewCompat.setBackground((View)this.binding.vCircle, (Drawable)((Drawable)d));
        View view = this.binding.vCircle;
        if (this.progress > 0.7f) {
            Context context3 = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context3, (String)"getContext(...)");
            f = UtilsKt.dp(this.progress * 4.0f, context3);
        } else {
            f = 0.0f;
        }
        ViewCompat.setElevation((View)view, (float)f);
        Context context4 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context4, (String)"getContext(...)");
        int m = UtilsKt.dp(24, context4);
        View view2 = this.binding.vCircle;
        float f3 = (1.0f - this.progress) * (float)(this.isFromLeft ? -m : m);
        float f4 = this.getMeasuredWidth();
        Context context5 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context5, (String)"getContext(...)");
        view2.setX(f3 + (f4 - UtilsKt.dp(48.0f, context5)) / 2.0f);
        View view3 = this.binding.vCircle;
        float f5 = (1.0f - this.progress) * (float)this.getMeasuredHeight();
        Context context6 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context6, (String)"getContext(...)");
        view3.setY(f5 + (float)UtilsKt.dp(6, context6));
    }

    public final boolean isEnabledCell() {
        return this.isEnabledCell;
    }

    /*
     * WARNING - void declaration
     */
    public final void setEnabledCell(boolean value) {
        block1: {
            void $this$runAfterDelay$iv;
            block0: {
                this.isEnabledCell = value;
                GradientDrawable d = new GradientDrawable();
                d.setColor(this.circleColor);
                d.setShape(1);
                if (Build.VERSION.SDK_INT < 21 || this.isEnabledCell) break block0;
                this.binding.fl.setBackground((Drawable)new RippleDrawable(ColorStateList.valueOf((int)this.rippleColor), null, (Drawable)d));
                break block1;
            }
            View view = (View)this.binding.fl;
            long delay$iv = 200L;
            boolean $i$f$runAfterDelay = false;
            void v0 = $this$runAfterDelay$iv;
            if (v0 == null) break block1;
            v0.postDelayed(new Runnable((View)$this$runAfterDelay$iv, this){
                final /* synthetic */ View $this_runAfterDelay;
                final /* synthetic */ NafisBottomNavigationCell this$0;
                {
                    this.$this_runAfterDelay = $receiver;
                    this.this$0 = nafisBottomNavigationCell;
                }

                public final void run() {
                    try {
                        FrameLayout $this$_set_isEnabledCell__u24lambda_u240 = (FrameLayout)this.$this_runAfterDelay;
                        boolean bl = false;
                        NafisBottomNavigationCell.access$getBinding$p((NafisBottomNavigationCell)this.this$0).fl.setBackgroundColor(0);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }, delay$iv);
        }
    }

    @NotNull
    public final Function0<Unit> getOnClickListener() {
        return this.onClickListener;
    }

    public final void setOnClickListener(@NotNull Function0<Unit> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.onClickListener = value;
        this.binding.iv.setOnClickListener(arg_0 -> NafisBottomNavigationCell._set_onClickListener_$lambda$1(this, arg_0));
    }

    private final void draw() {
        if (!this.allowDraw) {
            return;
        }
        this.setIcon(this.icon);
        this.setCount(this.count);
        this.setIconSize(this.iconSize);
        this.setCountTextColor(this.countTextColor);
        this.setCountBackgroundColor(this.countBackgroundColor);
        this.setCountTypeface(this.countTypeface);
        this.setRippleColor(this.rippleColor);
        this.setOnClickListener(this.onClickListener);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.setProgress(this.progress);
    }

    public final void disableCell(boolean isAnimate) {
        if (this.isEnabledCell) {
            this.animateProgress(false, isAnimate);
        }
        this.setEnabledCell(false);
    }

    public static /* synthetic */ void disableCell$default(NafisBottomNavigationCell nafisBottomNavigationCell, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        nafisBottomNavigationCell.disableCell(bl);
    }

    public final void enableCell(boolean isAnimate) {
        if (!this.isEnabledCell) {
            this.animateProgress(true, isAnimate);
        }
        this.setEnabledCell(true);
    }

    public static /* synthetic */ void enableCell$default(NafisBottomNavigationCell nafisBottomNavigationCell, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        nafisBottomNavigationCell.enableCell(bl);
    }

    private final void animateProgress(boolean enableCell, boolean isAnimate) {
        long d = enableCell ? this.duration : 250L;
        Object object = new float[]{0.0f, 1.0f};
        ValueAnimator anim = ValueAnimator.ofFloat((float[])object);
        Object $this$animateProgress_u24lambda_u243 = object = (Object)anim;
        boolean bl = false;
        $this$animateProgress_u24lambda_u243.setStartDelay(enableCell ? d / (long)4 : 0L);
        $this$animateProgress_u24lambda_u243.setDuration(isAnimate ? d : 1L);
        $this$animateProgress_u24lambda_u243.setInterpolator((TimeInterpolator)new FastOutSlowInInterpolator());
        $this$animateProgress_u24lambda_u243.addUpdateListener(arg_0 -> NafisBottomNavigationCell.animateProgress$lambda$3$lambda$2(this, enableCell, arg_0));
        $this$animateProgress_u24lambda_u243.start();
    }

    static /* synthetic */ void animateProgress$default(NafisBottomNavigationCell nafisBottomNavigationCell, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl2 = true;
        }
        nafisBottomNavigationCell.animateProgress(bl, bl2);
    }

    @JvmOverloads
    public NafisBottomNavigationCell(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public NafisBottomNavigationCell(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final void _set_onClickListener_$lambda$1(NafisBottomNavigationCell this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.onClickListener.invoke();
    }

    private static final void animateProgress$lambda$3$lambda$2(NafisBottomNavigationCell this$0, boolean $enableCell, ValueAnimator it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        float f = it.getAnimatedFraction();
        this$0.setProgress($enableCell ? f : 1.0f - f);
    }

    public static final /* synthetic */ MeowNavigationCellBinding access$getBinding$p(NafisBottomNavigationCell $this) {
        return $this.binding;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/nafis/bottomnavigation/NafisBottomNavigationCell$Companion;", "", "()V", "EMPTY_VALUE", "", "NafisBottomNavigation_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

