/*
 * Decompiled with CFR 0.152.
 */
package com.mediapermissionlib.byfoysaltechyt;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import com.mediapermissionlib.byfoysaltechyt.DialogConfig;
import com.mediapermissionlib.byfoysaltechyt.PermissionManager;
import com.mediapermissionlib.byfoysaltechyt.R;

public class CustomAlertDialog {
    private final Dialog dialog;
    private final PermissionManager permissionManager;

    public CustomAlertDialog(Activity activity, DialogConfig config, PermissionManager manager) {
        this.permissionManager = manager;
        this.dialog = new Dialog((Context)activity);
        this.dialog.setCancelable(false);
        this.dialog.setContentView(R.layout.dialog_permission);
        TextView titleView = (TextView)this.dialog.findViewById(R.id.dialog_title);
        TextView messageView = (TextView)this.dialog.findViewById(R.id.dialog_message);
        Button positiveButton = (Button)this.dialog.findViewById(R.id.btn_positive);
        Button negativeButton = (Button)this.dialog.findViewById(R.id.btn_negative);
        titleView.setText((CharSequence)config.getTitle());
        messageView.setText((CharSequence)config.getMessage());
        positiveButton.setText((CharSequence)config.getPositiveButtonText());
        negativeButton.setText((CharSequence)config.getNegativeButtonText());
        this.dialog.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
        positiveButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CustomAlertDialog.this.dialog.dismiss();
                CustomAlertDialog.this.permissionManager.requestStoragePermissions();
            }
        });
        negativeButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CustomAlertDialog.this.dialog.dismiss();
                CustomAlertDialog.this.permissionManager.getCallback().onPermissionDenied();
            }
        });
    }

    public void show() {
        this.dialog.show();
    }
}

