/*
 * Decompiled with CFR 0.152.
 */
package com.folioreader.util;

import android.app.Activity;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.Intent;
import android.content.res.AssetManager;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.util.StateSet;
import android.view.View;
import android.view.Window;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.core.content.ContextCompat;
import com.folioreader.AppContext;
import com.folioreader.R;
import com.folioreader.ui.view.UnderlinedTextView;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.util.Hashtable;
import org.json.JSONException;
import org.json.JSONObject;

public class UiUtil {
    private static final String LOG_TAG = UiUtil.class.getSimpleName();
    private static final Hashtable<String, SoftReference<Typeface>> fontCache = new Hashtable();

    public static void setCustomFont(View view, Context ctx, AttributeSet attrs, int[] attributeSet, int fontId) {
        TypedArray a = ctx.obtainStyledAttributes(attrs, attributeSet);
        String customFont = a.getString(fontId);
        UiUtil.setCustomFont(view, ctx, customFont);
        a.recycle();
    }

    public static boolean setCustomFont(View view, Context ctx, String asset) {
        if (TextUtils.isEmpty((CharSequence)asset)) {
            return false;
        }
        Typeface tf = null;
        try {
            tf = UiUtil.getFont(ctx, asset);
            if (view instanceof TextView) {
                ((TextView)view).setTypeface(tf);
            } else {
                ((Button)view).setTypeface(tf);
            }
        }
        catch (Exception e) {
            Log.e((String)"AppUtil", (String)("Could not get typface  " + asset));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Typeface getFont(Context c, String name) {
        Hashtable<String, SoftReference<Typeface>> hashtable = fontCache;
        synchronized (hashtable) {
            SoftReference<Typeface> ref;
            if (fontCache.get(name) != null && (ref = fontCache.get(name)).get() != null) {
                return ref.get();
            }
            Typeface typeface = Typeface.createFromAsset((AssetManager)c.getAssets(), (String)name);
            fontCache.put(name, new SoftReference<Typeface>(typeface));
            return typeface;
        }
    }

    public static ColorStateList getColorList(@ColorInt int selectedColor, @ColorInt int unselectedColor) {
        int[][] states = new int[][]{{0x10100A1}, new int[0]};
        int[] colors = new int[]{selectedColor, unselectedColor};
        ColorStateList list = new ColorStateList((int[][])states, colors);
        return list;
    }

    public static void keepScreenAwake(boolean enable, Context context) {
        if (enable) {
            ((Activity)context).getWindow().addFlags(128);
        } else {
            ((Activity)context).getWindow().clearFlags(128);
        }
    }

    public static void setBackColorToTextView(UnderlinedTextView textView, String type) {
        Context context = textView.getContext();
        if (type.equals("highlight_yellow")) {
            UiUtil.setUnderLineColor(textView, context, R.color.highlight_yellow, R.color.highlight_yellow);
        } else if (type.equals("highlight_green")) {
            UiUtil.setUnderLineColor(textView, context, R.color.highlight_green, R.color.highlight_green);
        } else if (type.equals("highlight_blue")) {
            UiUtil.setUnderLineColor(textView, context, R.color.highlight_blue, R.color.highlight_blue);
        } else if (type.equals("highlight_pink")) {
            UiUtil.setUnderLineColor(textView, context, R.color.highlight_pink, R.color.highlight_pink);
        } else if (type.equals("highlight_underline")) {
            UiUtil.setUnderLineColor(textView, context, 17170445, 17170455);
            textView.setUnderlineWidth(2.0f);
        }
    }

    private static void setUnderLineColor(UnderlinedTextView underlinedTextView, Context context, int background, int underlinecolor) {
        underlinedTextView.setBackgroundColor(ContextCompat.getColor((Context)context, (int)background));
        underlinedTextView.setUnderLineColor(ContextCompat.getColor((Context)context, (int)underlinecolor));
    }

    public static float convertDpToPixel(float dp, Context context) {
        return dp * context.getResources().getDisplayMetrics().density;
    }

    public static void copyToClipboard(Context context, String text) {
        ClipboardManager clipboard = (ClipboardManager)context.getSystemService("clipboard");
        ClipData clip = ClipData.newPlainText((CharSequence)"copy", (CharSequence)text);
        clipboard.setPrimaryClip(clip);
    }

    public static void share(Context context, String text) {
        Intent sendIntent = new Intent();
        sendIntent.setAction("android.intent.action.SEND");
        sendIntent.putExtra("android.intent.extra.TEXT", text);
        sendIntent.setType("text/plain");
        context.startActivity(Intent.createChooser((Intent)sendIntent, (CharSequence)context.getResources().getText(R.string.send_to)));
    }

    public static void setColorIntToDrawable(@ColorInt int color2, Drawable drawable2) {
        drawable2.setColorFilter(color2, PorterDuff.Mode.SRC_ATOP);
    }

    public static void setColorResToDrawable(@ColorRes int colorResId, Drawable drawable2) {
        try {
            int color2 = ContextCompat.getColor((Context)AppContext.get(), (int)colorResId);
            drawable2.setColorFilter(color2, PorterDuff.Mode.SRC_ATOP);
        }
        catch (Resources.NotFoundException e) {
            Log.e((String)LOG_TAG, (String)"-> Exception in setColorResToDrawable -> ", (Throwable)e);
        }
    }

    public static void setEditTextCursorColor(EditText editText, @ColorInt int color2) {
        try {
            Field field = TextView.class.getDeclaredField("mCursorDrawableRes");
            field.setAccessible(true);
            int drawableResId = field.getInt(editText);
            Drawable drawable2 = ContextCompat.getDrawable((Context)editText.getContext(), (int)drawableResId);
            drawable2.setColorFilter(color2, PorterDuff.Mode.SRC_IN);
            Drawable[] drawables = new Drawable[]{drawable2, drawable2};
            if (Build.VERSION.SDK_INT == 15) {
                Class<TextView> drawableFieldClass = TextView.class;
                field = drawableFieldClass.getDeclaredField("mCursorDrawable");
                field.setAccessible(true);
                field.set(editText, drawables);
            } else if (Build.VERSION.SDK_INT >= 16 && Build.VERSION.SDK_INT <= 27) {
                field = TextView.class.getDeclaredField("mEditor");
                field.setAccessible(true);
                Object editor = field.get(editText);
                field = editor.getClass().getDeclaredField("mCursorDrawable");
                field.setAccessible(true);
                field.set(editor, drawables);
            } else if (Build.VERSION.SDK_INT >= 28) {
                field = TextView.class.getDeclaredField("mEditor");
                field.setAccessible(true);
                Object editor = field.get(editText);
                field = editor.getClass().getDeclaredField("mDrawableForCursor");
                field.setAccessible(true);
                field.set(editor, drawables[0]);
            }
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)"-> ", (Throwable)e);
        }
    }

    public static void setEditTextHandleColor(EditText editText, @ColorInt int color2) {
        try {
            Field fieldLeftRes = TextView.class.getDeclaredField("mTextSelectHandleLeftRes");
            fieldLeftRes.setAccessible(true);
            int leftDrawableResId = fieldLeftRes.getInt(editText);
            Field fieldRightRes = TextView.class.getDeclaredField("mTextSelectHandleRightRes");
            fieldRightRes.setAccessible(true);
            int rightDrawableResId = fieldRightRes.getInt(editText);
            Field fieldCenterRes = TextView.class.getDeclaredField("mTextSelectHandleRes");
            fieldCenterRes.setAccessible(true);
            int centerDrawableResId = fieldCenterRes.getInt(editText);
            Drawable drawableLeft = ContextCompat.getDrawable((Context)editText.getContext(), (int)leftDrawableResId);
            drawableLeft.setColorFilter(color2, PorterDuff.Mode.SRC_IN);
            Drawable drawableRight = ContextCompat.getDrawable((Context)editText.getContext(), (int)rightDrawableResId);
            drawableRight.setColorFilter(color2, PorterDuff.Mode.SRC_IN);
            Drawable drawableCenter = ContextCompat.getDrawable((Context)editText.getContext(), (int)centerDrawableResId);
            drawableCenter.setColorFilter(color2, PorterDuff.Mode.SRC_IN);
            if (Build.VERSION.SDK_INT == 15) {
                Class<TextView> drawableFieldClass = TextView.class;
                Field fieldLeft = drawableFieldClass.getDeclaredField("mSelectHandleLeft");
                fieldLeft.setAccessible(true);
                fieldLeft.set(editText, drawableLeft);
                Field fieldRight = drawableFieldClass.getDeclaredField("mSelectHandleRight");
                fieldRight.setAccessible(true);
                fieldRight.set(editText, drawableRight);
                Field fieldCenter = drawableFieldClass.getDeclaredField("mSelectHandleCenter");
                fieldCenter.setAccessible(true);
                fieldCenter.set(editText, drawableCenter);
            } else {
                Field fieldEditor = TextView.class.getDeclaredField("mEditor");
                fieldEditor.setAccessible(true);
                Object editor = fieldEditor.get(editText);
                Field fieldLeft = editor.getClass().getDeclaredField("mSelectHandleLeft");
                fieldLeft.setAccessible(true);
                fieldLeft.set(editor, drawableLeft);
                Field fieldRight = editor.getClass().getDeclaredField("mSelectHandleRight");
                fieldRight.setAccessible(true);
                fieldRight.set(editor, drawableRight);
                Field fieldCenter = editor.getClass().getDeclaredField("mSelectHandleCenter");
                fieldCenter.setAccessible(true);
                fieldCenter.set(editor, drawableCenter);
            }
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)"-> ", (Throwable)e);
        }
    }

    public static StateListDrawable createStateDrawable(@ColorInt int colorSelected, @ColorInt int colorNormal) {
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(new int[]{0x10100A1}, (Drawable)new ColorDrawable(colorSelected));
        stateListDrawable.addState(StateSet.WILD_CARD, (Drawable)new ColorDrawable(colorNormal));
        return stateListDrawable;
    }

    public static GradientDrawable getShapeDrawable(@ColorInt int color2) {
        GradientDrawable gradientDrawable = new GradientDrawable();
        gradientDrawable.setShape(0);
        gradientDrawable.setStroke(UiUtil.pxToDp(2), color2);
        gradientDrawable.setColor(color2);
        gradientDrawable.setCornerRadius((float)UiUtil.pxToDp(3));
        return gradientDrawable;
    }

    public static void setShapeColor(View view, @ColorInt int color2) {
        ((GradientDrawable)view.getBackground()).setColor(color2);
    }

    public static int pxToDp(int px) {
        return (int)((float)px / Resources.getSystem().getDisplayMetrics().density);
    }

    public static void setStatusBarColor(Window window, @ColorInt int color2) {
        if (Build.VERSION.SDK_INT >= 21) {
            window.clearFlags(0x4000000);
            window.addFlags(Integer.MIN_VALUE);
            window.setStatusBarColor(color2);
        }
    }

    public static String rectToDOMRectJson(Rect rect) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("x", rect.left);
            jsonObject.put("y", rect.top);
            jsonObject.put("width", rect.width());
            jsonObject.put("height", rect.height());
            return jsonObject.toString();
        }
        catch (JSONException e) {
            Log.e((String)LOG_TAG, (String)"-> ", (Throwable)e);
            return null;
        }
    }
}

