/*
 * Decompiled with CFR 0.152.
 */
package com.folioreader.util;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;
import com.folioreader.ui.activity.FolioActivity;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileUtil {
    private static final String TAG = FileUtil.class.getSimpleName();
    private static final String FOLIO_READER_ROOT = "folioreader";

    public static String saveEpubFileAndLoadLazyBook(Context context, FolioActivity.EpubSourceType epubSourceType, String epubFilePath, int epubRawId, String epubFileName) {
        try {
            boolean isFolderAvailable = FileUtil.isFolderAvailable(epubFileName);
            String filePath = FileUtil.getFolioEpubFilePath(epubSourceType, epubFilePath, epubFileName);
            if (!isFolderAvailable) {
                if (epubSourceType.equals((Object)FolioActivity.EpubSourceType.RAW)) {
                    InputStream epubInputStream = context.getResources().openRawResource(epubRawId);
                    FileUtil.saveTempEpubFile(filePath, epubFileName, epubInputStream);
                } else if (epubSourceType.equals((Object)FolioActivity.EpubSourceType.ASSETS)) {
                    AssetManager assetManager = context.getAssets();
                    epubFilePath = epubFilePath.replaceAll("file:///android_asset/", "");
                    InputStream epubInputStream = assetManager.open(epubFilePath);
                    FileUtil.saveTempEpubFile(filePath, epubFileName, epubInputStream);
                } else {
                    filePath = epubFilePath;
                }
            }
            return filePath;
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)e.getMessage());
            return null;
        }
    }

    public static String getFolioEpubFolderPath(String epubFileName) {
        return Environment.getExternalStorageDirectory().getAbsolutePath() + "/" + FOLIO_READER_ROOT + "/" + epubFileName;
    }

    public static String getFolioEpubFilePath(FolioActivity.EpubSourceType sourceType, String epubFilePath, String epubFileName) {
        if (FolioActivity.EpubSourceType.SD_CARD.equals((Object)sourceType)) {
            return epubFilePath;
        }
        return FileUtil.getFolioEpubFolderPath(epubFileName) + "/" + epubFileName + ".epub";
    }

    private static boolean isFolderAvailable(String epubFileName) {
        File file = new File(FileUtil.getFolioEpubFolderPath(epubFileName));
        return file.isDirectory();
    }

    public static String getEpubFilename(Context context, FolioActivity.EpubSourceType epubSourceType, String epubFilePath, int epubRawId) {
        String epubFileName;
        if (epubSourceType.equals((Object)FolioActivity.EpubSourceType.RAW)) {
            Resources res = context.getResources();
            epubFileName = res.getResourceEntryName(epubRawId);
        } else {
            String[] temp = epubFilePath.split("/");
            epubFileName = temp[temp.length - 1];
            int fileMaxIndex = epubFileName.length();
            epubFileName = epubFileName.substring(0, fileMaxIndex - 5);
        }
        return epubFileName;
    }

    public static Boolean saveTempEpubFile(String filePath, String fileName, InputStream inputStream) {
        FileOutputStream outputStream = null;
        File file = new File(filePath);
        try {
            if (!file.exists()) {
                File folder = new File(FileUtil.getFolioEpubFolderPath(fileName));
                folder.mkdirs();
                outputStream = new FileOutputStream(file);
                int read = 0;
                byte[] bytes = new byte[inputStream.available()];
                while ((read = inputStream.read(bytes)) != -1) {
                    ((OutputStream)outputStream).write(bytes, 0, read);
                }
            } else {
                return true;
            }
            inputStream.close();
            ((OutputStream)outputStream).close();
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)e.getMessage());
        }
        return false;
    }

    public static String getExtensionUppercase(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return null;
        }
        int lastIndexOfDot = path.lastIndexOf(46);
        if (lastIndexOfDot == -1) {
            return null;
        }
        return path.substring(lastIndexOfDot + 1).toUpperCase();
    }
}

