/*
 * Decompiled with CFR 0.152.
 */
package com.folioreader.mediaoverlay;

import android.annotation.TargetApi;
import android.content.Context;
import android.media.MediaPlayer;
import android.os.Handler;
import android.speech.tts.TextToSpeech;
import android.util.Log;
import androidx.appcompat.app.AppCompatActivity;
import com.folioreader.mediaoverlay.MediaControllerCallbacks;
import com.folioreader.model.event.MediaOverlayPlayPauseEvent;
import com.folioreader.model.event.MediaOverlaySpeedEvent;
import com.folioreader.model.media_overlay.OverlayItems;
import com.folioreader.util.UiUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.readium.r2.shared.Clip;
import org.readium.r2.shared.MediaOverlays;

public class MediaController {
    private static final String TAG = MediaController.class.getSimpleName();
    private MediaType mediaType;
    private MediaControllerCallbacks callbacks;
    private Context context;
    private MediaOverlays mediaOverlays;
    private List<OverlayItems> mediaItems = new ArrayList<OverlayItems>();
    private int mediaItemPosition = 0;
    private MediaPlayer mediaPlayer;
    private Clip currentClip;
    private boolean isMediaPlayerReady;
    private Handler mediaHandler;
    private TextToSpeech mTextToSpeech;
    private boolean mIsSpeaking = false;
    private Runnable mHighlightTask = new Runnable(){

        @Override
        public void run() {
            int currentPosition = MediaController.this.mediaPlayer.getCurrentPosition();
            if (MediaController.this.mediaPlayer.getDuration() != currentPosition) {
                if (MediaController.this.mediaItemPosition < MediaController.this.mediaItems.size()) {
                    int end = (int)(MediaController.this.currentClip.getEnd() * 1000.0);
                    if (currentPosition > end) {
                        MediaController.this.mediaItemPosition++;
                        MediaController.this.currentClip = MediaController.this.mediaOverlays.clip(((OverlayItems)MediaController.this.mediaItems.get(MediaController.this.mediaItemPosition)).getId());
                        if (MediaController.this.currentClip != null) {
                            MediaController.this.callbacks.highLightText(((OverlayItems)MediaController.this.mediaItems.get(MediaController.this.mediaItemPosition)).getId());
                        } else {
                            MediaController.this.mediaItemPosition++;
                        }
                    }
                    MediaController.this.mediaHandler.postDelayed(MediaController.this.mHighlightTask, 10L);
                } else {
                    MediaController.this.mediaHandler.removeCallbacks(MediaController.this.mHighlightTask);
                }
            }
        }
    };

    public MediaController(Context context, MediaType mediaType, MediaControllerCallbacks callbacks) {
        this.mediaType = mediaType;
        this.callbacks = callbacks;
        this.context = context;
    }

    public void resetMediaPosition() {
        this.mediaItemPosition = 0;
    }

    public void setSMILItems(List<OverlayItems> overlayItems) {
        this.mediaItems = overlayItems;
    }

    public void next() {
        ++this.mediaItemPosition;
    }

    public void setTextToSpeech(final Context context) {
        this.mTextToSpeech = new TextToSpeech(context, new TextToSpeech.OnInitListener(){

            public void onInit(int status) {
                if (status != -1) {
                    MediaController.this.mTextToSpeech.setLanguage(Locale.UK);
                    MediaController.this.mTextToSpeech.setSpeechRate(0.7f);
                }
                MediaController.this.mTextToSpeech.setOnUtteranceCompletedListener(new TextToSpeech.OnUtteranceCompletedListener(){

                    public void onUtteranceCompleted(String utteranceId) {
                        ((AppCompatActivity)context).runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                if (MediaController.this.mIsSpeaking) {
                                    MediaController.this.callbacks.highLightTTS();
                                }
                            }
                        });
                    }
                });
            }
        });
    }

    public void setUpMediaPlayer(MediaOverlays mediaOverlays, String path, String mBookTitle) {
        this.mediaOverlays = mediaOverlays;
        this.mediaHandler = new Handler();
        try {
            this.mediaItemPosition = 0;
            String uri = "http://127.0.0.1:8080/" + mBookTitle + path;
            this.mediaPlayer = new MediaPlayer();
            this.mediaPlayer.setDataSource(uri);
            this.mediaPlayer.prepare();
            this.isMediaPlayerReady = true;
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)e.getMessage());
        }
    }

    public void setSpeed(MediaOverlaySpeedEvent.Speed speed) {
        switch (speed) {
            case HALF: {
                this.setPlaybackSpeed(0.5f);
                break;
            }
            case ONE: {
                this.setPlaybackSpeed(1.0f);
                break;
            }
            case ONE_HALF: {
                this.setPlaybackSpeed(1.5f);
                break;
            }
            case TWO: {
                this.setPlaybackSpeed(2.0f);
            }
        }
    }

    @TargetApi(value=23)
    private void setPlaybackSpeed(float speed) {
        if (this.mediaType == MediaType.SMIL) {
            if (this.mediaPlayer != null && this.mediaPlayer.isPlaying()) {
                this.mediaPlayer.setPlaybackParams(this.mediaPlayer.getPlaybackParams().setSpeed(speed));
            }
        } else {
            this.mTextToSpeech.setSpeechRate(speed);
        }
    }

    public void stateChanged(MediaOverlayPlayPauseEvent event) {
        if (event.isStateChanged()) {
            if (this.mediaPlayer != null) {
                this.mediaPlayer.pause();
            }
            if (this.mTextToSpeech != null && this.mTextToSpeech.isSpeaking()) {
                this.mTextToSpeech.stop();
            }
        } else {
            if (event.isPlay()) {
                UiUtil.keepScreenAwake(true, this.context);
            } else {
                UiUtil.keepScreenAwake(false, this.context);
            }
            if (this.mediaType == MediaType.SMIL) {
                this.playSMIL();
            } else if (this.mTextToSpeech.isSpeaking()) {
                this.mTextToSpeech.stop();
                this.mIsSpeaking = false;
                this.callbacks.resetCurrentIndex();
            } else {
                this.mIsSpeaking = true;
                this.callbacks.highLightTTS();
            }
        }
    }

    private void playSMIL() {
        if (this.mediaPlayer != null && this.isMediaPlayerReady) {
            if (this.mediaPlayer.isPlaying()) {
                this.mediaPlayer.pause();
            } else {
                this.currentClip = this.mediaOverlays.clip(this.mediaItems.get(this.mediaItemPosition).getId());
                if (this.currentClip != null) {
                    this.mediaPlayer.start();
                    this.mediaHandler.post(this.mHighlightTask);
                } else {
                    ++this.mediaItemPosition;
                    this.mediaPlayer.start();
                    this.mediaHandler.post(this.mHighlightTask);
                }
            }
        }
    }

    public void speakAudio(String sentence) {
        if (this.mediaType == MediaType.TTS) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("utteranceId", "stringId");
            this.mTextToSpeech.speak(sentence, 0, params);
        }
    }

    public void stop() {
        if (this.mTextToSpeech != null) {
            if (this.mTextToSpeech.isSpeaking()) {
                this.mTextToSpeech.stop();
            }
            this.mTextToSpeech.shutdown();
        }
        if (this.mediaPlayer != null && this.mediaPlayer.isPlaying()) {
            this.mediaPlayer.stop();
            this.mediaPlayer.release();
            this.mediaPlayer = null;
            this.mediaHandler.removeCallbacks(this.mHighlightTask);
        }
    }

    public static enum MediaType {
        TTS,
        SMIL;

    }
}

