/*
 * Decompiled with CFR 0.152.
 */
package com.folioreader;

import android.content.Context;
import android.content.res.Resources;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.core.content.ContextCompat;
import com.folioreader.AppContext;
import com.folioreader.R;
import org.json.JSONObject;

public class Config
implements Parcelable {
    private static final String LOG_TAG = Config.class.getSimpleName();
    public static final String INTENT_CONFIG = "config";
    public static final String EXTRA_OVERRIDE_CONFIG = "com.folioreader.extra.OVERRIDE_CONFIG";
    public static final String CONFIG_FONT = "font";
    public static final String CONFIG_FONT_SIZE = "font_size";
    public static final String CONFIG_IS_NIGHT_MODE = "is_night_mode";
    public static final String CONFIG_THEME_COLOR_INT = "theme_color_int";
    public static final String CONFIG_IS_TTS = "is_tts";
    public static final String CONFIG_ALLOWED_DIRECTION = "allowed_direction";
    public static final String CONFIG_DIRECTION = "direction";
    private static final AllowedDirection DEFAULT_ALLOWED_DIRECTION = AllowedDirection.ONLY_VERTICAL;
    private static final Direction DEFAULT_DIRECTION = Direction.VERTICAL;
    private static final int DEFAULT_THEME_COLOR_INT = ContextCompat.getColor((Context)AppContext.get(), (int)R.color.default_theme_accent_color);
    private int font = 3;
    private int fontSize = 2;
    private boolean nightMode;
    @ColorInt
    private int themeColor = DEFAULT_THEME_COLOR_INT;
    private boolean showTts = true;
    private AllowedDirection allowedDirection = DEFAULT_ALLOWED_DIRECTION;
    private Direction direction = DEFAULT_DIRECTION;
    public static final Parcelable.Creator<Config> CREATOR = new Parcelable.Creator<Config>(){

        public Config createFromParcel(Parcel in) {
            return new Config(in);
        }

        public Config[] newArray(int size) {
            return new Config[size];
        }
    };

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.font);
        dest.writeInt(this.fontSize);
        dest.writeByte((byte)(this.nightMode ? 1 : 0));
        dest.writeInt(this.themeColor);
        dest.writeByte((byte)(this.showTts ? 1 : 0));
        dest.writeString(this.allowedDirection.toString());
        dest.writeString(this.direction.toString());
    }

    protected Config(Parcel in) {
        this.font = in.readInt();
        this.fontSize = in.readInt();
        this.nightMode = in.readByte() != 0;
        this.themeColor = in.readInt();
        this.showTts = in.readByte() != 0;
        this.allowedDirection = Config.getAllowedDirectionFromString(LOG_TAG, in.readString());
        this.direction = Config.getDirectionFromString(LOG_TAG, in.readString());
    }

    public Config() {
    }

    public Config(JSONObject jsonObject) {
        this.font = jsonObject.optInt(CONFIG_FONT);
        this.fontSize = jsonObject.optInt(CONFIG_FONT_SIZE);
        this.nightMode = jsonObject.optBoolean(CONFIG_IS_NIGHT_MODE);
        this.themeColor = this.getValidColorInt(jsonObject.optInt(CONFIG_THEME_COLOR_INT));
        this.showTts = jsonObject.optBoolean(CONFIG_IS_TTS);
        this.allowedDirection = Config.getAllowedDirectionFromString(LOG_TAG, jsonObject.optString(CONFIG_ALLOWED_DIRECTION));
        this.direction = Config.getDirectionFromString(LOG_TAG, jsonObject.optString(CONFIG_DIRECTION));
    }

    public static Direction getDirectionFromString(String LOG_TAG, String directionString) {
        switch (directionString) {
            case "VERTICAL": {
                return Direction.VERTICAL;
            }
            case "HORIZONTAL": {
                return Direction.HORIZONTAL;
            }
        }
        Log.w((String)LOG_TAG, (String)("-> Illegal argument directionString = `" + directionString + "`, defaulting direction to " + (Object)((Object)DEFAULT_DIRECTION)));
        return DEFAULT_DIRECTION;
    }

    public static AllowedDirection getAllowedDirectionFromString(String LOG_TAG, String allowedDirectionString) {
        switch (allowedDirectionString) {
            case "ONLY_VERTICAL": {
                return AllowedDirection.ONLY_VERTICAL;
            }
            case "ONLY_HORIZONTAL": {
                return AllowedDirection.ONLY_HORIZONTAL;
            }
            case "VERTICAL_AND_HORIZONTAL": {
                return AllowedDirection.VERTICAL_AND_HORIZONTAL;
            }
        }
        Log.w((String)LOG_TAG, (String)("-> Illegal argument allowedDirectionString = `" + allowedDirectionString + "`, defaulting allowedDirection to " + (Object)((Object)DEFAULT_ALLOWED_DIRECTION)));
        return DEFAULT_ALLOWED_DIRECTION;
    }

    public int getFont() {
        return this.font;
    }

    public Config setFont(int font) {
        this.font = font;
        return this;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public Config setFontSize(int fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    public boolean isNightMode() {
        return this.nightMode;
    }

    public Config setNightMode(boolean nightMode) {
        this.nightMode = nightMode;
        return this;
    }

    @ColorInt
    private int getValidColorInt(@ColorInt int colorInt) {
        if (colorInt >= 0) {
            Log.w((String)LOG_TAG, (String)("-> getValidColorInt -> Invalid argument colorInt = " + colorInt + ", Returning DEFAULT_THEME_COLOR_INT = " + DEFAULT_THEME_COLOR_INT));
            return DEFAULT_THEME_COLOR_INT;
        }
        return colorInt;
    }

    @ColorInt
    public int getThemeColor() {
        return this.themeColor;
    }

    public Config setThemeColorRes(@ColorRes int colorResId) {
        try {
            this.themeColor = ContextCompat.getColor((Context)AppContext.get(), (int)colorResId);
        }
        catch (Resources.NotFoundException e) {
            Log.w((String)LOG_TAG, (String)("-> setThemeColorRes -> " + (Object)((Object)e)));
            Log.w((String)LOG_TAG, (String)("-> setThemeColorRes -> Defaulting themeColor to " + DEFAULT_THEME_COLOR_INT));
            this.themeColor = DEFAULT_THEME_COLOR_INT;
        }
        return this;
    }

    public Config setThemeColorInt(@ColorInt int colorInt) {
        this.themeColor = this.getValidColorInt(colorInt);
        return this;
    }

    public boolean isShowTts() {
        return this.showTts;
    }

    public Config setShowTts(boolean showTts) {
        this.showTts = showTts;
        return this;
    }

    public AllowedDirection getAllowedDirection() {
        return this.allowedDirection;
    }

    public Config setAllowedDirection(AllowedDirection allowedDirection) {
        this.allowedDirection = allowedDirection;
        if (allowedDirection == null) {
            this.allowedDirection = DEFAULT_ALLOWED_DIRECTION;
            this.direction = DEFAULT_DIRECTION;
            Log.w((String)LOG_TAG, (String)("-> allowedDirection cannot be null, defaulting allowedDirection to " + (Object)((Object)DEFAULT_ALLOWED_DIRECTION) + " and direction to " + (Object)((Object)DEFAULT_DIRECTION)));
        } else if (allowedDirection == AllowedDirection.ONLY_VERTICAL && this.direction != Direction.VERTICAL) {
            this.direction = Direction.VERTICAL;
            Log.w((String)LOG_TAG, (String)("-> allowedDirection is " + (Object)((Object)allowedDirection) + ", defaulting direction to " + (Object)((Object)this.direction)));
        } else if (allowedDirection == AllowedDirection.ONLY_HORIZONTAL && this.direction != Direction.HORIZONTAL) {
            this.direction = Direction.HORIZONTAL;
            Log.w((String)LOG_TAG, (String)("-> allowedDirection is " + (Object)((Object)allowedDirection) + ", defaulting direction to " + (Object)((Object)this.direction)));
        }
        return this;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public Config setDirection(Direction direction) {
        if (this.allowedDirection == AllowedDirection.VERTICAL_AND_HORIZONTAL && direction == null) {
            this.direction = DEFAULT_DIRECTION;
            Log.w((String)LOG_TAG, (String)("-> direction cannot be `null` when allowedDirection is " + (Object)((Object)this.allowedDirection) + ", defaulting direction to " + (Object)((Object)this.direction)));
        } else if (this.allowedDirection == AllowedDirection.ONLY_VERTICAL && direction != Direction.VERTICAL) {
            this.direction = Direction.VERTICAL;
            Log.w((String)LOG_TAG, (String)("-> direction cannot be `" + (Object)((Object)direction) + "` when allowedDirection is " + (Object)((Object)this.allowedDirection) + ", defaulting direction to " + (Object)((Object)this.direction)));
        } else if (this.allowedDirection == AllowedDirection.ONLY_HORIZONTAL && direction != Direction.HORIZONTAL) {
            this.direction = Direction.HORIZONTAL;
            Log.w((String)LOG_TAG, (String)("-> direction cannot be `" + (Object)((Object)direction) + "` when allowedDirection is " + (Object)((Object)this.allowedDirection) + ", defaulting direction to " + (Object)((Object)this.direction)));
        } else {
            this.direction = direction;
        }
        return this;
    }

    public String toString() {
        return "Config{font=" + this.font + ", fontSize=" + this.fontSize + ", nightMode=" + this.nightMode + ", themeColor=" + this.themeColor + ", showTts=" + this.showTts + ", allowedDirection=" + (Object)((Object)this.allowedDirection) + ", direction=" + (Object)((Object)this.direction) + '}';
    }

    public static enum Direction {
        VERTICAL,
        HORIZONTAL;

    }

    public static enum AllowedDirection {
        ONLY_VERTICAL,
        ONLY_HORIZONTAL,
        VERTICAL_AND_HORIZONTAL;

    }
}

