/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.idlab.knows.misc;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileFinder {
    private static final Logger logger = LoggerFactory.getLogger(FileFinder.class);

    public static URL findFile(String path) {
        logger.debug("Finding file '{}'", (Object)path);
        URL url = null;
        if (path.startsWith("http://") || path.startsWith("https://")) {
            logger.debug("Found remote URL for path '{}'", (Object)path);
            try {
                url = new URL(path);
            }
            catch (MalformedURLException e) {
                logger.debug(e.getMessage());
            }
        }
        if (url == null && (url = FileFinder.findFileRelativeToWorkingDir(path)) == null) {
            url = FileFinder.findFileOnClassPath(path);
        }
        return url;
    }

    static URL findFileOnClassPath(String path) {
        logger.debug("Searching '{}' on classpath", (Object)path);
        ClassLoader classLoader = FileFinder.class.getClassLoader();
        return classLoader.getResource(path);
    }

    static URL findFileRelativeToWorkingDir(String path) {
        logger.debug("Searching '{}' (absolute or relative to current working dir)", (Object)path);
        String workingDir = System.getProperty("user.dir");
        Path workingDirPath = Paths.get(workingDir, new String[0]);
        Path resolved = workingDirPath.resolve(path);
        File file = resolved.toFile();
        if (file.exists()) {
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                logger.info(e.getMessage());
            }
        }
        return null;
    }
}

