/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.idlab.knows.functions.agent.functionModelProvider.fno;

import be.ugent.idlab.knows.functions.agent.dataType.DataTypeConverter;
import be.ugent.idlab.knows.functions.agent.dataType.DataTypeConverterProvider;
import be.ugent.idlab.knows.functions.agent.functionModelProvider.FunctionModelProvider;
import be.ugent.idlab.knows.functions.agent.functionModelProvider.fno.NAMESPACES;
import be.ugent.idlab.knows.functions.agent.functionModelProvider.fno.exception.ClassNameDescriptionNotFoundException;
import be.ugent.idlab.knows.functions.agent.functionModelProvider.fno.exception.DataTypeNotFoundException;
import be.ugent.idlab.knows.functions.agent.functionModelProvider.fno.exception.FnODocNotFoundException;
import be.ugent.idlab.knows.functions.agent.functionModelProvider.fno.exception.FnOException;
import be.ugent.idlab.knows.functions.agent.functionModelProvider.fno.exception.FunctionMappingNotFoundException;
import be.ugent.idlab.knows.functions.agent.functionModelProvider.fno.exception.FunctionNameNotFoundException;
import be.ugent.idlab.knows.functions.agent.functionModelProvider.fno.exception.FunctionNotFoundException;
import be.ugent.idlab.knows.functions.agent.functionModelProvider.fno.exception.ImplementationDescriptionNotFoundException;
import be.ugent.idlab.knows.functions.agent.functionModelProvider.fno.exception.MethodMappingNotFoundException;
import be.ugent.idlab.knows.functions.agent.functionModelProvider.fno.exception.MethodMappingTypeNotFoundException;
import be.ugent.idlab.knows.functions.agent.functionModelProvider.fno.exception.MethodNameNotFoundException;
import be.ugent.idlab.knows.functions.agent.functionModelProvider.fno.exception.ParameterNameDescriptionNotFoundException;
import be.ugent.idlab.knows.functions.agent.functionModelProvider.fno.exception.ParameterPredicateNotFoundException;
import be.ugent.idlab.knows.functions.agent.functionModelProvider.fno.exception.UnsupportedImplementationTypeException;
import be.ugent.idlab.knows.functions.agent.model.Function;
import be.ugent.idlab.knows.functions.agent.model.FunctionMapping;
import be.ugent.idlab.knows.functions.agent.model.Implementation;
import be.ugent.idlab.knows.functions.agent.model.MethodMapping;
import be.ugent.idlab.knows.functions.agent.model.Parameter;
import be.ugent.idlab.knows.misc.FileFinder;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FnOFunctionModelProvider
implements FunctionModelProvider {
    private static final Logger logger = LoggerFactory.getLogger(FnOFunctionModelProvider.class);
    private final Model functionDescriptionTriples = ModelFactory.createDefaultModel();
    private final Map<String, Function> functionId2Functions = new HashMap<String, Function>();
    private final Map<String, FunctionMapping> functionId2functionMappings = new HashMap<String, FunctionMapping>();
    private final DataTypeConverterProvider dataTypeConverterProvider;
    private final Map<String, String> location2otherLocationMap;
    private final Property typeProperty = ResourceFactory.createProperty((String)NAMESPACES.RDF.toString(), (String)"type");

    public FnOFunctionModelProvider(DataTypeConverterProvider dataTypeConverterProvider, String ... fnoDocPaths) throws FnOException {
        this(dataTypeConverterProvider, Collections.emptyMap(), fnoDocPaths);
    }

    public FnOFunctionModelProvider(DataTypeConverterProvider dataTypeConverterProvider, Map<String, String> implementationLocationMapping, String ... fnoDocPaths) throws FnOException {
        this.dataTypeConverterProvider = dataTypeConverterProvider;
        this.location2otherLocationMap = implementationLocationMapping;
        this.parse(fnoDocPaths);
    }

    @Override
    public Map<String, Function> getFunctions() {
        return this.functionId2Functions;
    }

    private void parse(String ... fnoDocPaths) throws FnOException {
        logger.info("Loading function descriptions from {}", (Object)Arrays.toString(fnoDocPaths));
        try {
            this.readRDFModel(fnoDocPaths);
            this.parseFunctionMappings();
            this.parseFunctions();
            this.mapFunctionMappingsToFunctions();
        }
        finally {
            this.functionDescriptionTriples.close();
            this.functionId2functionMappings.clear();
        }
    }

    private void readRDFModel(String ... fnoDocPaths) throws FnODocNotFoundException {
        for (String fnoDocPath : fnoDocPaths) {
            logger.debug("Reading RDF model from {}", (Object)fnoDocPath);
            URL fnoDocURL = FileFinder.findFile(fnoDocPath);
            if (fnoDocURL != null) {
                logger.debug("'{}' resolved to '{}'", (Object)fnoDocPath, (Object)fnoDocURL);
                RDFDataMgr.read((Model)this.functionDescriptionTriples, (String)fnoDocPath, (Lang)Lang.TURTLE);
                continue;
            }
            logger.warn("Could not find document; trying to interpret it as direct Turlte input.");
            try {
                RDFDataMgr.read((Model)this.functionDescriptionTriples, (StringReader)new StringReader(fnoDocPath), (String)"", (Lang)Lang.TURTLE);
            }
            catch (Throwable t) {
                throw new FnODocNotFoundException("Could not process FnO document: " + t.getMessage());
            }
        }
    }

    private void mapFunctionMappingsToFunctions() throws FunctionMappingNotFoundException {
        for (String functionId : this.functionId2Functions.keySet()) {
            logger.debug("Finding mapping for function {}", (Object)functionId);
            if (this.functionId2functionMappings.containsKey(functionId)) {
                Function function = this.functionId2Functions.get(functionId);
                function.setFunctionMapping(this.functionId2functionMappings.get(functionId));
                continue;
            }
            throw new FunctionMappingNotFoundException("No '" + (Object)((Object)NAMESPACES.FNO) + "Mapping' found for function '" + functionId + '\"');
        }
    }

    private void parseFunctionMappings() throws FnOException {
        logger.debug("Parsing function mappings");
        Resource functionMappingObject = ResourceFactory.createResource((String)((Object)((Object)NAMESPACES.FNO) + "Mapping"));
        ResIterator mappings = this.functionDescriptionTriples.listSubjectsWithProperty(this.typeProperty, (RDFNode)functionMappingObject);
        while (mappings.hasNext()) {
            this.parseFunctionMapping(mappings.nextResource());
        }
    }

    private void parseFunctionMapping(Resource functionMappingResource) throws FnOException {
        logger.debug("Parsing function mapping {}", (Object)functionMappingResource.getURI());
        String functionURI = this.getObjectURI(functionMappingResource, (Object)((Object)NAMESPACES.FNO) + "function").orElseThrow(() -> new FunctionNotFoundException("No function resource found for fno:Mapping '" + functionMappingResource.getURI() + "'"));
        if (!this.functionId2functionMappings.containsKey(functionURI)) {
            String functionMappingURI = functionMappingResource.getURI();
            logger.debug("Parsing function mapping {} for function {}", (Object)functionMappingURI, (Object)functionURI);
            MethodMapping methodMapping = this.parseMethodMapping(functionMappingResource);
            Implementation implementation = this.parseImplementation(functionMappingResource);
            FunctionMapping functionMapping = new FunctionMapping(functionURI, methodMapping, implementation);
            this.functionId2functionMappings.put(functionURI, functionMapping);
        } else {
            logger.debug("Function mapping for {} already parsed", (Object)functionURI);
        }
    }

    private MethodMapping parseMethodMapping(Resource functionMappingResource) throws FnOException {
        logger.debug("Parsing method mapping for {}", (Object)functionMappingResource.getURI());
        Resource methodMappingResource = this.getObjectResource(functionMappingResource, (Object)((Object)NAMESPACES.FNO) + "methodMapping").orElseThrow(() -> new MethodMappingNotFoundException("No '" + (Object)((Object)NAMESPACES.FNO) + "methodMapping' found for fno:Mapping '" + functionMappingResource.getURI() + "'"));
        String methodMappingType = this.getObjectURI(methodMappingResource, this.typeProperty.getURI()).orElseThrow(() -> new MethodMappingTypeNotFoundException("No type of method mapping found for fno:Mapping '" + functionMappingResource.getURI() + "'"));
        String methodName = this.getLiteralStr(methodMappingResource, (Object)((Object)NAMESPACES.FNOM) + "method-name").orElseThrow(() -> new MethodNameNotFoundException("No '" + (Object)((Object)NAMESPACES.FNOM) + "method-name' found for fno:Mapping '" + functionMappingResource.getURI() + "' "));
        return new MethodMapping(methodMappingType, methodName);
    }

    private Implementation parseImplementation(Resource functionMappingResource) throws FnOException {
        logger.debug("Parsing implementation for {}", (Object)functionMappingResource.getURI());
        Optional<Resource> implementationResourceOption = this.getObjectResource(functionMappingResource, (Object)((Object)NAMESPACES.FNO) + "implementation");
        Resource implementationResource = implementationResourceOption.orElseThrow(() -> new ImplementationDescriptionNotFoundException("No implementation found for function mapping " + functionMappingResource.getURI()));
        String implementationUri = implementationResource.getURI();
        String implementationType = this.getObjectURI(implementationResource, this.typeProperty.getURI()).orElseThrow(() -> new ImplementationDescriptionNotFoundException("No implementation type found for implementation resource " + implementationUri));
        String supportedImplementationType = (Object)((Object)NAMESPACES.FNOI) + "JavaClass";
        if (!implementationType.equals(supportedImplementationType)) {
            throw new UnsupportedImplementationTypeException("Only implementation type '" + supportedImplementationType + "' supported. Found '" + implementationType + "'");
        }
        String className = this.getLiteralStr(implementationResource, (Object)((Object)NAMESPACES.FNOI) + "class-name").orElseThrow(() -> new ClassNameDescriptionNotFoundException("No '" + (Object)((Object)NAMESPACES.FNOI) + "class-name' found for implementation '" + implementationUri + "'"));
        Property downloadPageProperty = ResourceFactory.createProperty((String)NAMESPACES.DOAP.toString(), (String)"download-page");
        String location = this.getLiteralStr(implementationResource, downloadPageProperty.getURI()).orElse("");
        String mappedLocation = this.location2otherLocationMap.getOrDefault(location, location);
        return new Implementation(className, mappedLocation);
    }

    private void parseFunctions() throws FnOException {
        logger.debug("Parsing functions");
        Resource functionObject = ResourceFactory.createResource((String)((Object)((Object)NAMESPACES.FNO) + "Function"));
        ResIterator functions = this.functionDescriptionTriples.listSubjectsWithProperty(this.typeProperty, (RDFNode)functionObject);
        while (functions.hasNext()) {
            this.parseFunction(functions.nextResource());
        }
    }

    private void parseFunction(Resource functionResource) throws FnOException {
        String functionURI = functionResource.getURI();
        if (!this.functionId2Functions.containsKey(functionURI)) {
            logger.debug("Parsing new function {}", (Object)functionURI);
            String name = this.getLiteralStr(functionResource, (Object)((Object)NAMESPACES.FNO) + "name").orElseThrow(() -> new FunctionNameNotFoundException("Could not find '" + (Object)((Object)NAMESPACES.FNO) + "name' for"));
            List<Parameter> expects = this.parseParameters(functionResource, true);
            List<Parameter> returns = this.parseParameters(functionResource, false);
            String description = this.getLiteralStr(functionResource, (Object)((Object)NAMESPACES.DCTERMS) + "description").orElse("");
            this.parseLib(functionResource);
            Function function = new Function(functionURI, name, description, expects, returns);
            this.functionId2Functions.put(functionURI, function);
        }
    }

    private List<Parameter> parseParameters(Resource functionResource, boolean input) throws FnOException {
        logger.debug("Parsing expected parameters of {}", (Object)functionResource.getURI());
        String isInputParameter = input ? "expects" : "returns";
        Resource expectedOrReturnedResources = functionResource.getPropertyResourceValue(this.functionDescriptionTriples.getProperty(NAMESPACES.FNO.toString(), isInputParameter));
        List<Resource> parameterResourceList = this.getResourcesFromList(expectedOrReturnedResources);
        ArrayList<Parameter> parameters = new ArrayList<Parameter>(parameterResourceList.size());
        for (Resource parameterResource : parameterResourceList) {
            parameters.add(this.parseParameter(parameterResource));
        }
        return parameters;
    }

    private Parameter parseParameter(Resource parameterResource) throws FnOException {
        String uri = parameterResource.getURI();
        logger.debug("Parsing parameter {}", (Object)uri);
        String name = this.getLiteralStr(parameterResource, (Object)((Object)NAMESPACES.FNO) + "name").orElseThrow(() -> new ParameterNameDescriptionNotFoundException("No '" + (Object)((Object)NAMESPACES.FNO) + "name' found for parameter '" + uri + "'"));
        String typeUri = this.getObjectURI(parameterResource, (Object)((Object)NAMESPACES.FNO) + "type").orElseThrow(() -> new DataTypeNotFoundException("No data type description found for parameter '" + uri + '\"'));
        String predicateUri = this.getObjectURI(parameterResource, (Object)((Object)NAMESPACES.FNO) + "predicate").orElseThrow(() -> new ParameterPredicateNotFoundException("No predicate description found for parameter '" + uri + "'"));
        ResourceFactory.createProperty((String)((Object)((Object)NAMESPACES.FNO) + "required"));
        boolean isRequired = this.getLiteralBoolean(parameterResource, (Object)((Object)NAMESPACES.FNO) + "required").orElse(true);
        DataTypeConverter<?> typeConverter = this.dataTypeConverterProvider.getDataTypeConverter(typeUri);
        return new Parameter(name, predicateUri, typeConverter, isRequired);
    }

    private void parseLib(Resource functionResource) throws FnOException {
        Optional<Resource> libResourceOption = this.getObjectResource(functionResource, (Object)((Object)NAMESPACES.LIB) + "providedBy");
        String functionUri = functionResource.getURI();
        if (this.functionId2functionMappings.containsKey(functionUri)) {
            logger.debug("Function mapping for {} already parsed", (Object)functionUri);
            return;
        }
        if (libResourceOption.isPresent()) {
            logger.warn("Using {}providedBy is deprecated. Using the implementation vocabulary (https://fno.io/vocabulary/implementation/index-en.html) is recommended", (Object)NAMESPACES.LIB);
            Resource libResource = libResourceOption.get();
            String location = this.getLiteralStr(libResource, (Object)((Object)NAMESPACES.LIB) + "localLibrary").orElse("");
            String mappedLocation = this.location2otherLocationMap.getOrDefault(location, location);
            String className = this.getLiteralStr(libResource, (Object)((Object)NAMESPACES.LIB) + "class").orElseThrow(() -> new ClassNameDescriptionNotFoundException("No '" + (Object)((Object)NAMESPACES.LIB) + "class' found for '" + libResource.getURI() + "' for function '" + functionUri + "'"));
            String method = this.getLiteralStr(libResource, (Object)((Object)NAMESPACES.LIB) + "method").orElseThrow(() -> new MethodMappingNotFoundException("No '" + (Object)((Object)NAMESPACES.LIB) + "method' found for '" + libResource.getURI() + "' for function '" + functionUri + "'"));
            MethodMapping methodMapping = new MethodMapping((Object)((Object)NAMESPACES.FNOM) + "StringMethodMapping", method);
            Implementation implementation = new Implementation(className, mappedLocation);
            FunctionMapping functionMapping = new FunctionMapping(functionUri, methodMapping, implementation);
            this.functionId2functionMappings.put(functionUri, functionMapping);
        }
    }

    private Optional<Literal> getLiteral(Resource subject, String predicateURI) {
        Property property = ResourceFactory.createProperty((String)predicateURI);
        Statement statement = subject.getProperty(property);
        if (statement == null) {
            return Optional.empty();
        }
        return Optional.of(statement.getObject().asLiteral());
    }

    private Optional<String> getLiteralStr(Resource subject, String predicateURI) {
        Optional<Literal> objectLiteralResult = this.getLiteral(subject, predicateURI);
        return objectLiteralResult.map(Literal::getString);
    }

    private Optional<Boolean> getLiteralBoolean(Resource subject, String predicateURI) {
        Optional<Literal> objectLiteralResult = this.getLiteral(subject, predicateURI);
        return objectLiteralResult.map(Literal::getBoolean);
    }

    private Optional<String> getObjectURI(Resource subject, String predicateURI) {
        Optional<Resource> objectResourceOption = this.getObjectResource(subject, predicateURI);
        return objectResourceOption.map(Resource::getURI);
    }

    private Optional<Resource> getObjectResource(Resource subject, String predicateURI) {
        Property property = ResourceFactory.createProperty((String)predicateURI);
        Statement statement = subject.getProperty(property);
        if (statement == null) {
            return Optional.empty();
        }
        return Optional.of(statement.getObject().asResource());
    }

    private List<Resource> getResourcesFromList(Resource listResource) {
        Optional<Resource> firstResource;
        ArrayList<Resource> resources = new ArrayList<Resource>();
        if (!listResource.hasURI((Object)((Object)NAMESPACES.RDF) + "nil") && (firstResource = this.getObjectResource(listResource, (Object)((Object)NAMESPACES.RDF) + "first")).isPresent()) {
            resources.add(firstResource.get());
            Optional<Resource> restResource = this.getObjectResource(listResource, (Object)((Object)NAMESPACES.RDF) + "rest");
            restResource.ifPresent(resource -> resources.addAll(this.getResourcesFromList((Resource)resource)));
        }
        return resources;
    }
}

