/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.idlab.knows.functions.agent;

import be.ugent.idlab.knows.functions.agent.Agent;
import be.ugent.idlab.knows.functions.agent.Arguments;
import be.ugent.idlab.knows.functions.agent.dataType.DataTypeConverter;
import be.ugent.idlab.knows.functions.agent.functionIntantiation.Instantiator;
import be.ugent.idlab.knows.functions.agent.model.Function;
import be.ugent.idlab.knows.functions.agent.model.Parameter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentImpl
implements Agent {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, Function> functionId2Function;
    private final Instantiator instantiator;

    public AgentImpl(Map<String, Function> functionId2Function, Instantiator instantiator) {
        this.functionId2Function = functionId2Function;
        this.instantiator = instantiator;
    }

    @Override
    public Object execute(String functionId, Arguments arguments) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Executing function '{}' with arguments '{}'", (Object)functionId, (Object)arguments.toString());
        }
        Method method = this.instantiator.getMethod(functionId);
        Function function = this.functionId2Function.get(functionId);
        ArrayList valuesInOrder = new ArrayList(arguments.size());
        for (Parameter argumentParameter : function.getArgumentParameters()) {
            Object convertedValue;
            Collection<Object> valueCollection = arguments.get(argumentParameter.getId());
            if (argumentParameter.getTypeConverter().getTypeCategory().equals((Object)DataTypeConverter.TypeCategory.COLLECTION)) {
                convertedValue = argumentParameter.getTypeConverter().convert(valueCollection);
                valuesInOrder.add(convertedValue);
                continue;
            }
            if (valueCollection.isEmpty()) {
                this.logger.debug("No value found for parameter '{}' in function {}. Considering it to be 'null'.", (Object)argumentParameter.getId(), (Object)functionId);
                valuesInOrder.add(null);
                continue;
            }
            convertedValue = argumentParameter.getTypeConverter().convert(valueCollection.stream().findFirst().orElseThrow(() -> new IllegalArgumentException("Value expected for parameter '" + argumentParameter.getId() + "' in function '" + functionId + "'.")));
            valuesInOrder.add(convertedValue);
        }
        return method.invoke(null, valuesInOrder.toArray());
    }
}

