/*
 * Decompiled with CFR 0.152.
 */
package com.ferfalk.simplesearchview.utils;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.Log;
import android.widget.EditText;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.BlendModeColorFilterCompat;
import androidx.core.graphics.BlendModeCompat;
import java.lang.reflect.Field;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u000eH\u0007J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000eH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \b*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/ferfalk/simplesearchview/utils/EditTextReflectionUtils;", "", "()V", "EDIT_TEXT_FIELD_CURSOR_DRAWABLE", "", "EDIT_TEXT_FIELD_CURSOR_DRAWABLE_RES", "EDIT_TEXT_FIELD_EDITOR", "TAG", "kotlin.jvm.PlatformType", "setCursorColor", "", "editText", "Landroid/widget/EditText;", "color", "", "setCursorDrawable", "drawable", "simplesearchview_release"})
public final class EditTextReflectionUtils {
    private static final String TAG;
    private static final String EDIT_TEXT_FIELD_CURSOR_DRAWABLE_RES = "mCursorDrawableRes";
    private static final String EDIT_TEXT_FIELD_EDITOR = "mEditor";
    private static final String EDIT_TEXT_FIELD_CURSOR_DRAWABLE = "mCursorDrawable";
    public static final EditTextReflectionUtils INSTANCE;

    @JvmStatic
    public static final void setCursorDrawable(@NotNull EditText editText, int drawable) {
        Intrinsics.checkNotNullParameter((Object)editText, (String)"editText");
        try {
            Field f;
            Field field = f = TextView.class.getDeclaredField(EDIT_TEXT_FIELD_CURSOR_DRAWABLE_RES);
            Intrinsics.checkNotNullExpressionValue((Object)field, (String)"f");
            field.setAccessible(true);
            f.set(editText, drawable);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
        }
    }

    @JvmStatic
    public static final void setCursorColor(@NotNull EditText editText, @ColorInt int color) {
        Intrinsics.checkNotNullParameter((Object)editText, (String)"editText");
        try {
            Drawable drawable;
            Field field;
            Field field2 = field = TextView.class.getDeclaredField(EDIT_TEXT_FIELD_CURSOR_DRAWABLE_RES);
            Intrinsics.checkNotNullExpressionValue((Object)field2, (String)"field");
            field2.setAccessible(true);
            int drawableResId = field.getInt(editText);
            Field field3 = field = TextView.class.getDeclaredField(EDIT_TEXT_FIELD_EDITOR);
            Intrinsics.checkNotNullExpressionValue((Object)field3, (String)"field");
            field3.setAccessible(true);
            Object editor = field.get(editText);
            Drawable drawable2 = drawable = ContextCompat.getDrawable((Context)editText.getContext(), (int)drawableResId);
            if (drawable2 != null) {
                drawable2.setColorFilter(BlendModeColorFilterCompat.createBlendModeColorFilterCompat((int)color, (BlendModeCompat)BlendModeCompat.SRC_IN));
            }
            Drawable[] drawables = new Drawable[]{drawable, drawable};
            Field field4 = field = editor.getClass().getDeclaredField(EDIT_TEXT_FIELD_CURSOR_DRAWABLE);
            Intrinsics.checkNotNullExpressionValue((Object)field4, (String)"field");
            field4.setAccessible(true);
            field.set(editor, drawables);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
        }
    }

    private EditTextReflectionUtils() {
    }

    static {
        EditTextReflectionUtils editTextReflectionUtils;
        INSTANCE = editTextReflectionUtils = new EditTextReflectionUtils();
        TAG = EditTextReflectionUtils.class.getSimpleName();
    }
}

