/*
 * Decompiled with CFR 0.152.
 */
package com.ferfalk.simplesearchview;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import androidx.core.widget.ImageViewCompat;
import com.ferfalk.simplesearchview.R;
import com.ferfalk.simplesearchview.SimpleOnTabSelectedListener;
import com.ferfalk.simplesearchview.SimpleTextWatcher;
import com.ferfalk.simplesearchview.databinding.SearchViewBinding;
import com.ferfalk.simplesearchview.utils.ContextUtils;
import com.ferfalk.simplesearchview.utils.DimensUtils;
import com.ferfalk.simplesearchview.utils.EditTextReflectionUtils;
import com.ferfalk.simplesearchview.utils.SimpleAnimationListener;
import com.ferfalk.simplesearchview.utils.SimpleAnimationUtils;
import com.google.android.material.tabs.TabLayout;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.annotation.AnnotationRetention;
import kotlin.annotation.Retention;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0015\u0018\u0000 |2\u00020\u0001:\u0006|}~\u007f\u0080\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u00108\u001a\u000209H\u0016J\u000f\u0010:\u001a\u0004\u0018\u00010\nH\u0002\u00a2\u0006\u0002\u0010;J\u0019\u0010<\u001a\u0004\u0018\u0001092\b\b\u0002\u0010=\u001a\u00020\nH\u0007\u00a2\u0006\u0002\u0010>J\u000e\u0010?\u001a\u0002092\u0006\u0010@\u001a\u00020\nJ\u0012\u0010A\u001a\u0002092\b\b\u0002\u0010=\u001a\u00020\nH\u0007J\b\u0010B\u001a\u000209H\u0002J\b\u0010C\u001a\u000209H\u0002J\u001a\u0010D\u001a\u0002092\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J*\u0010E\u001a\u00020\n2\u0006\u0010F\u001a\u00020\u00072\u0006\u0010G\u001a\u00020\u00072\u0006\u0010H\u001a\u00020I2\b\b\u0002\u0010J\u001a\u00020\nH\u0007J\u0006\u0010K\u001a\u00020\nJ\u0010\u0010L\u001a\u0002092\u0006\u0010M\u001a\u00020NH\u0016J\b\u0010O\u001a\u00020NH\u0016J\b\u0010P\u001a\u000209H\u0002J\u0010\u0010Q\u001a\u0002092\u0006\u0010R\u001a\u00020!H\u0002J\u001a\u0010S\u001a\u00020\n2\u0006\u0010T\u001a\u00020\u00072\b\u0010U\u001a\u0004\u0018\u00010VH\u0016J\u000e\u0010W\u001a\u0002092\u0006\u0010X\u001a\u00020YJ\u0010\u0010Z\u001a\u0002092\b\b\u0001\u0010[\u001a\u00020\u0007J\u0010\u0010\\\u001a\u0002092\b\u0010]\u001a\u0004\u0018\u00010^J\u0010\u0010_\u001a\u0002092\b\u0010]\u001a\u0004\u0018\u00010^J\u0010\u0010`\u001a\u0002092\b\b\u0001\u0010[\u001a\u00020\u0007J\u0010\u0010a\u001a\u0002092\b\b\u0001\u0010]\u001a\u00020\u0007J\u0010\u0010b\u001a\u0002092\b\u0010c\u001a\u0004\u0018\u00010!J\u0010\u0010d\u001a\u0002092\b\b\u0001\u0010[\u001a\u00020\u0007J\u000e\u0010e\u001a\u0002092\u0006\u0010X\u001a\u00020YJ\u0010\u0010f\u001a\u0002092\b\b\u0001\u0010[\u001a\u00020\u0007J\u000e\u0010g\u001a\u0002092\u0006\u0010h\u001a\u00020\u0007J\u000e\u0010i\u001a\u0002092\u0006\u0010\u001f\u001a\u00020\nJ\u000e\u0010j\u001a\u0002092\u0006\u0010k\u001a\u00020lJ\u0010\u0010m\u001a\u0002092\b\u0010n\u001a\u0004\u0018\u00010#J\u0010\u0010o\u001a\u0002092\b\u0010n\u001a\u0004\u0018\u00010-J\u0018\u0010p\u001a\u0002092\b\u0010q\u001a\u0004\u0018\u00010!2\u0006\u0010J\u001a\u00020\nJ\u0010\u0010r\u001a\u0002092\b\u0010s\u001a\u0004\u0018\u00010^J\u000e\u0010t\u001a\u0002092\u0006\u00102\u001a\u000201J\u0010\u0010u\u001a\u0002092\b\b\u0001\u0010[\u001a\u00020\u0007J\u0010\u0010v\u001a\u0002092\b\u0010]\u001a\u0004\u0018\u00010^J\u0010\u0010w\u001a\u0002092\b\u00106\u001a\u0004\u0018\u000107J\u0019\u0010x\u001a\u0004\u0018\u0001092\b\b\u0002\u0010=\u001a\u00020\nH\u0007\u00a2\u0006\u0002\u0010>J\u0012\u0010y\u001a\u0002092\b\b\u0002\u0010=\u001a\u00020\nH\u0007J\u000e\u0010z\u001a\u0002092\u0006\u0010{\u001a\u00020\nJ\b\u0010@\u001a\u000209H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\r\"\u0004\b\u0015\u0010\u000fR\u0014\u0010\u0016\u001a\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001dR\u000e\u0010\u001f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010%\u001a\u0004\u0018\u00010&8FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u000e\u0010+\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010,\u001a\u0004\u0018\u00010-X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010.\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b/\u00100R\"\u00102\u001a\u0004\u0018\u0001012\b\u0010\u001b\u001a\u0004\u0018\u000101@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u000e\u00105\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00106\u001a\u0004\u0018\u000107X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0081\u0001"}, d2={"Lcom/ferfalk/simplesearchview/SimpleSearchView;", "Landroid/widget/FrameLayout;", "creationContext", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "allowVoiceSearch", "", "animationDuration", "getAnimationDuration", "()I", "setAnimationDuration", "(I)V", "binding", "Lcom/ferfalk/simplesearchview/databinding/SearchViewBinding;", "value", "cardStyle", "getCardStyle", "setCardStyle", "cardStyleBackground", "Landroid/graphics/drawable/GradientDrawable;", "getCardStyleBackground", "()Landroid/graphics/drawable/GradientDrawable;", "isClearingFocus", "<set-?>", "isSearchOpen", "()Z", "isVoiceAvailable", "keepQuery", "oldQuery", "", "onQueryChangeListener", "Lcom/ferfalk/simplesearchview/SimpleSearchView$OnQueryTextListener;", "query", "revealAnimationCenter", "Landroid/graphics/Point;", "getRevealAnimationCenter", "()Landroid/graphics/Point;", "setRevealAnimationCenter", "(Landroid/graphics/Point;)V", "searchIsClosing", "searchViewListener", "Lcom/ferfalk/simplesearchview/SimpleSearchView$SearchViewListener;", "style", "getStyle$annotations", "()V", "Lcom/google/android/material/tabs/TabLayout;", "tabLayout", "getTabLayout", "()Lcom/google/android/material/tabs/TabLayout;", "tabLayoutInitialHeight", "voiceSearchPrompt", "", "clearFocus", "", "clearSearch", "()Ljava/lang/Boolean;", "closeSearch", "animate", "(Z)Lkotlin/Unit;", "enableVoiceSearch", "voiceSearch", "hideTabLayout", "initClickListeners", "initSearchEditText", "initStyle", "onActivityResult", "requestCode", "resultCode", "data", "Landroid/content/Intent;", "submit", "onBackPressed", "onRestoreInstanceState", "state", "Landroid/os/Parcelable;", "onSaveInstanceState", "onSubmitQuery", "onTextChanged", "newText", "requestFocus", "direction", "previouslyFocusedRect", "Landroid/graphics/Rect;", "setBackIconAlpha", "alpha", "", "setBackIconColor", "color", "setBackIconDrawable", "drawable", "Landroid/graphics/drawable/Drawable;", "setClearIconDrawable", "setCursorColor", "setCursorDrawable", "setHint", "hint", "setHintTextColor", "setIconsAlpha", "setIconsColor", "setInputType", "inputType", "setKeepQuery", "setMenuItem", "menuItem", "Landroid/view/MenuItem;", "setOnQueryTextListener", "listener", "setOnSearchViewListener", "setQuery", "sequence", "setSearchBackground", "background", "setTabLayout", "setTextColor", "setVoiceIconDrawable", "setVoiceSearchPrompt", "showSearch", "showTabLayout", "showVoice", "show", "Companion", "OnQueryTextListener", "SavedState", "SearchViewListener", "Style", "simplesearchview_release"})
public final class SimpleSearchView
extends FrameLayout {
    private int animationDuration;
    @Nullable
    private Point revealAnimationCenter;
    private CharSequence query;
    private CharSequence oldQuery;
    private boolean allowVoiceSearch;
    private boolean isSearchOpen;
    private boolean isClearingFocus;
    private String voiceSearchPrompt;
    private int style;
    @Nullable
    private TabLayout tabLayout;
    private int tabLayoutInitialHeight;
    private OnQueryTextListener onQueryChangeListener;
    private SearchViewListener searchViewListener;
    private boolean searchIsClosing;
    private boolean keepQuery;
    private final SearchViewBinding binding;
    public static final int REQUEST_VOICE_SEARCH = 735;
    public static final int CARD_CORNER_RADIUS = 4;
    public static final int ANIMATION_CENTER_PADDING = 26;
    private static final int CARD_PADDING = 6;
    private static final int CARD_ELEVATION = 2;
    private static final float BACK_ICON_ALPHA_DEFAULT = 0.87f;
    private static final float ICONS_ALPHA_DEFAULT = 0.54f;
    public static final int STYLE_BAR = 0;
    public static final int STYLE_CARD = 1;
    public static final Companion Companion = new Companion(null);

    public final int getAnimationDuration() {
        return this.animationDuration;
    }

    public final void setAnimationDuration(int n) {
        this.animationDuration = n;
    }

    @Nullable
    public final Point getRevealAnimationCenter() {
        if (this.revealAnimationCenter != null) {
            return this.revealAnimationCenter;
        }
        int n = this.getWidth();
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        int centerX = n - DimensUtils.convertDpToPx(26, context);
        int centerY = this.getHeight() / 2;
        this.revealAnimationCenter = new Point(centerX, centerY);
        return this.revealAnimationCenter;
    }

    public final void setRevealAnimationCenter(@Nullable Point point) {
        this.revealAnimationCenter = point;
    }

    public final boolean isSearchOpen() {
        return this.isSearchOpen;
    }

    private static /* synthetic */ void getStyle$annotations() {
    }

    @Nullable
    public final TabLayout getTabLayout() {
        return this.tabLayout;
    }

    private final void initStyle(AttributeSet attrs, int defStyleAttr) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.SimpleSearchView, defStyleAttr, 0);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.obtainStyledAttr\u2026rchView, defStyleAttr, 0)");
        TypedArray typedArray2 = typedArray;
        if (typedArray2.hasValue(R.styleable.SimpleSearchView_type)) {
            this.setCardStyle(typedArray2.getInt(R.styleable.SimpleSearchView_type, this.style));
        }
        if (typedArray2.hasValue(R.styleable.SimpleSearchView_backIconAlpha)) {
            this.setBackIconAlpha(typedArray2.getFloat(R.styleable.SimpleSearchView_backIconAlpha, 0.87f));
        }
        if (typedArray2.hasValue(R.styleable.SimpleSearchView_iconsAlpha)) {
            this.setIconsAlpha(typedArray2.getFloat(R.styleable.SimpleSearchView_iconsAlpha, 0.54f));
        }
        if (typedArray2.hasValue(R.styleable.SimpleSearchView_backIconTint)) {
            Context context = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            this.setBackIconColor(typedArray2.getColor(R.styleable.SimpleSearchView_backIconTint, ContextUtils.getPrimaryColor(context)));
        }
        if (typedArray2.hasValue(R.styleable.SimpleSearchView_iconsTint)) {
            this.setIconsColor(typedArray2.getColor(R.styleable.SimpleSearchView_iconsTint, -16777216));
        }
        if (typedArray2.hasValue(R.styleable.SimpleSearchView_cursorColor)) {
            Context context = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            this.setCursorColor(typedArray2.getColor(R.styleable.SimpleSearchView_cursorColor, ContextUtils.getAccentColor(context)));
        }
        if (typedArray2.hasValue(R.styleable.SimpleSearchView_hintColor)) {
            this.setHintTextColor(typedArray2.getColor(R.styleable.SimpleSearchView_hintColor, ContextCompat.getColor((Context)this.getContext(), (int)R.color.default_textColorHint)));
        }
        if (typedArray2.hasValue(R.styleable.SimpleSearchView_searchBackground)) {
            this.setSearchBackground(typedArray2.getDrawable(R.styleable.SimpleSearchView_searchBackground));
        }
        if (typedArray2.hasValue(R.styleable.SimpleSearchView_searchBackIcon)) {
            this.setBackIconDrawable(typedArray2.getDrawable(R.styleable.SimpleSearchView_searchBackIcon));
        }
        if (typedArray2.hasValue(R.styleable.SimpleSearchView_searchClearIcon)) {
            this.setClearIconDrawable(typedArray2.getDrawable(R.styleable.SimpleSearchView_searchClearIcon));
        }
        if (typedArray2.hasValue(R.styleable.SimpleSearchView_searchVoiceIcon)) {
            this.setVoiceIconDrawable(typedArray2.getDrawable(R.styleable.SimpleSearchView_searchVoiceIcon));
        }
        if (typedArray2.hasValue(R.styleable.SimpleSearchView_voiceSearch)) {
            this.enableVoiceSearch(typedArray2.getBoolean(R.styleable.SimpleSearchView_voiceSearch, this.allowVoiceSearch));
        }
        if (typedArray2.hasValue(R.styleable.SimpleSearchView_voiceSearchPrompt)) {
            this.setVoiceSearchPrompt(typedArray2.getString(R.styleable.SimpleSearchView_voiceSearchPrompt));
        }
        if (typedArray2.hasValue(R.styleable.SimpleSearchView_android_hint)) {
            this.setHint(typedArray2.getString(R.styleable.SimpleSearchView_android_hint));
        }
        if (typedArray2.hasValue(R.styleable.SimpleSearchView_android_inputType)) {
            this.setInputType(typedArray2.getInt(R.styleable.SimpleSearchView_android_inputType, 524288));
        }
        if (typedArray2.hasValue(R.styleable.SimpleSearchView_android_textColor)) {
            this.setTextColor(typedArray2.getColor(R.styleable.SimpleSearchView_android_textColor, ContextCompat.getColor((Context)this.getContext(), (int)R.color.default_textColor)));
        }
        typedArray2.recycle();
    }

    private final void initSearchEditText() {
        SearchViewBinding searchViewBinding = this.binding;
        boolean bl = false;
        boolean bl2 = false;
        SearchViewBinding $this$with = searchViewBinding;
        boolean bl3 = false;
        $this$with.searchEditText.setOnEditorActionListener(new TextView.OnEditorActionListener(this){
            final /* synthetic */ SimpleSearchView this$0;
            {
                this.this$0 = simpleSearchView;
            }

            public final boolean onEditorAction(@Nullable TextView $noName_0, int $noName_1, @Nullable KeyEvent $noName_2) {
                SimpleSearchView.access$onSubmitQuery(this.this$0);
                return true;
            }
        });
        $this$with.searchEditText.addTextChangedListener((TextWatcher)new SimpleTextWatcher(this){
            final /* synthetic */ SimpleSearchView this$0;
            {
                this.this$0 = simpleSearchView;
            }

            public void onTextChanged(@NotNull CharSequence s, int start, int before, int count) {
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                if (!SimpleSearchView.access$getSearchIsClosing$p(this.this$0)) {
                    SimpleSearchView.access$onTextChanged(this.this$0, s);
                }
            }
        });
        EditText editText = $this$with.searchEditText;
        Intrinsics.checkNotNullExpressionValue((Object)editText, (String)"searchEditText");
        editText.setOnFocusChangeListener(new View.OnFocusChangeListener($this$with){
            final /* synthetic */ SearchViewBinding $this_with;

            public final void onFocusChange(@Nullable View $noName_0, boolean hasFocus) {
                if (hasFocus) {
                    EditText editText = this.$this_with.searchEditText;
                    Intrinsics.checkNotNullExpressionValue((Object)editText, (String)"searchEditText");
                    ContextUtils.showKeyboard((View)editText);
                }
            }
            {
                this.$this_with = searchViewBinding;
            }
        });
    }

    private final void initClickListeners() {
        SearchViewBinding searchViewBinding = this.binding;
        boolean bl = false;
        boolean bl2 = false;
        SearchViewBinding $this$with = searchViewBinding;
        boolean bl3 = false;
        $this$with.backButton.setOnClickListener(new View.OnClickListener(this){
            final /* synthetic */ SimpleSearchView this$0;
            {
                this.this$0 = simpleSearchView;
            }

            public final void onClick(View it) {
                SimpleSearchView.closeSearch$default(this.this$0, false, 1, null);
            }
        });
        $this$with.clearButton.setOnClickListener(new View.OnClickListener(this){
            final /* synthetic */ SimpleSearchView this$0;
            {
                this.this$0 = simpleSearchView;
            }

            public final void onClick(View it) {
                SimpleSearchView.access$clearSearch(this.this$0);
            }
        });
        $this$with.voiceButton.setOnClickListener(new View.OnClickListener(this){
            final /* synthetic */ SimpleSearchView this$0;
            {
                this.this$0 = simpleSearchView;
            }

            public final void onClick(View it) {
                SimpleSearchView.access$voiceSearch(this.this$0);
            }
        });
    }

    public void clearFocus() {
        SearchViewBinding searchViewBinding = this.binding;
        boolean bl = false;
        boolean bl2 = false;
        SearchViewBinding $this$with = searchViewBinding;
        boolean bl3 = false;
        this.isClearingFocus = true;
        ContextUtils.hideKeyboard((View)this);
        super.clearFocus();
        $this$with.searchEditText.clearFocus();
        this.isClearingFocus = false;
    }

    public boolean requestFocus(int direction, @Nullable Rect previouslyFocusedRect) {
        SearchViewBinding searchViewBinding = this.binding;
        boolean bl = false;
        boolean bl2 = false;
        SearchViewBinding $this$with = searchViewBinding;
        boolean bl3 = false;
        if (this.isClearingFocus) {
            return false;
        }
        return !this.isFocusable() ? false : $this$with.searchEditText.requestFocus(direction, previouslyFocusedRect);
    }

    @NotNull
    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState savedState = new SavedState(superState);
        savedState.setQuery(this.query != null ? String.valueOf(this.query) : null);
        savedState.setSearchOpen(this.isSearchOpen);
        savedState.setAnimationDuration(this.animationDuration);
        savedState.setKeepQuery(this.keepQuery);
        return (Parcelable)savedState;
    }

    public void onRestoreInstanceState(@NotNull Parcelable state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        this.query = ((SavedState)state).getQuery();
        this.animationDuration = ((SavedState)state).getAnimationDuration();
        this.voiceSearchPrompt = ((SavedState)state).getVoiceSearchPrompt();
        this.keepQuery = ((SavedState)state).getKeepQuery();
        if (((SavedState)state).isSearchOpen()) {
            this.showSearch(false);
            this.setQuery(((SavedState)state).getQuery(), false);
        }
        super.onRestoreInstanceState(((SavedState)state).getSuperState());
    }

    private final void voiceSearch() {
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        Activity activity = ContextUtils.scanForActivity(context);
        if (activity == null) {
            return;
        }
        Activity activity2 = activity;
        Intent intent = new Intent("android.speech.action.RECOGNIZE_SPEECH");
        CharSequence charSequence = this.voiceSearchPrompt;
        boolean bl = false;
        boolean bl2 = false;
        if (!(charSequence == null || charSequence.length() == 0)) {
            intent.putExtra("android.speech.extra.PROMPT", this.voiceSearchPrompt);
        }
        intent.putExtra("android.speech.extra.LANGUAGE_MODEL", "web_search");
        intent.putExtra("android.speech.extra.MAX_RESULTS", 1);
        activity2.startActivityForResult(intent, 735);
    }

    private final Boolean clearSearch() {
        SearchViewBinding searchViewBinding = this.binding;
        boolean bl = false;
        boolean bl2 = false;
        SearchViewBinding $this$with = searchViewBinding;
        boolean bl3 = false;
        EditText editText = $this$with.searchEditText;
        Intrinsics.checkNotNullExpressionValue((Object)editText, (String)"searchEditText");
        editText.setText((CharSequence)null);
        OnQueryTextListener onQueryTextListener = this.onQueryChangeListener;
        return onQueryTextListener != null ? Boolean.valueOf(onQueryTextListener.onQueryTextCleared()) : null;
    }

    private final void onTextChanged(CharSequence newText) {
        boolean hasText;
        SearchViewBinding searchViewBinding = this.binding;
        boolean bl = false;
        boolean bl2 = false;
        SearchViewBinding $this$with = searchViewBinding;
        boolean bl3 = false;
        this.query = newText;
        boolean bl4 = hasText = !TextUtils.isEmpty((CharSequence)newText);
        if (hasText) {
            ImageButton imageButton = $this$with.clearButton;
            Intrinsics.checkNotNullExpressionValue((Object)imageButton, (String)"clearButton");
            imageButton.setVisibility(0);
            this.showVoice(false);
        } else {
            ImageButton imageButton = $this$with.clearButton;
            Intrinsics.checkNotNullExpressionValue((Object)imageButton, (String)"clearButton");
            imageButton.setVisibility(8);
            this.showVoice(true);
        }
        if (!TextUtils.equals((CharSequence)newText, (CharSequence)this.oldQuery)) {
            OnQueryTextListener onQueryTextListener = this.onQueryChangeListener;
            if (onQueryTextListener != null) {
                onQueryTextListener.onQueryTextChange(((Object)newText).toString());
            }
        }
        this.oldQuery = ((Object)newText).toString();
    }

    private final void onSubmitQuery() {
        block2: {
            SearchViewBinding $this$with;
            block3: {
                SearchViewBinding searchViewBinding = this.binding;
                boolean bl = false;
                boolean bl2 = false;
                $this$with = searchViewBinding;
                boolean bl3 = false;
                EditText editText = $this$with.searchEditText;
                Intrinsics.checkNotNullExpressionValue((Object)editText, (String)"searchEditText");
                CharSequence submittedQuery = (CharSequence)editText.getText();
                if (submittedQuery == null || TextUtils.getTrimmedLength((CharSequence)submittedQuery) <= 0) break block2;
                if (this.onQueryChangeListener == null) break block3;
                OnQueryTextListener onQueryTextListener = this.onQueryChangeListener;
                Intrinsics.checkNotNull((Object)onQueryTextListener);
                if (onQueryTextListener.onQueryTextSubmit(((Object)submittedQuery).toString())) break block2;
            }
            SimpleSearchView.closeSearch$default(this, false, 1, null);
            this.searchIsClosing = true;
            EditText editText = $this$with.searchEditText;
            Intrinsics.checkNotNullExpressionValue((Object)editText, (String)"searchEditText");
            editText.setText((CharSequence)null);
            this.searchIsClosing = false;
        }
    }

    private final boolean isVoiceAvailable() {
        if (this.isInEditMode()) {
            return true;
        }
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        PackageManager pm = context.getPackageManager();
        List list = pm.queryIntentActivities(new Intent("android.speech.action.RECOGNIZE_SPEECH"), 0);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"pm.queryIntentActivities\u2026ION_RECOGNIZE_SPEECH), 0)");
        List activities = list;
        Collection collection = activities;
        boolean bl = false;
        return !collection.isEmpty();
    }

    public final void setKeepQuery(boolean keepQuery) {
        this.keepQuery = keepQuery;
    }

    @JvmOverloads
    @Nullable
    public final Unit showSearch(boolean animate) {
        Unit unit;
        SearchViewBinding searchViewBinding = this.binding;
        boolean bl = false;
        boolean bl2 = false;
        SearchViewBinding $this$with = searchViewBinding;
        boolean bl3 = false;
        if (this.isSearchOpen) {
            return null;
        }
        $this$with.searchEditText.setText(this.keepQuery ? this.query : null);
        $this$with.searchEditText.requestFocus();
        if (animate) {
            SimpleAnimationUtils.AnimationListener animationListener = new SimpleAnimationListener(this, animate){
                final /* synthetic */ SimpleSearchView this$0;
                final /* synthetic */ boolean $animate$inlined;
                {
                    this.this$0 = simpleSearchView;
                    this.$animate$inlined = bl;
                }

                public boolean onAnimationEnd(@NotNull View view) {
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                        SearchViewListener searchViewListener = SimpleSearchView.access$getSearchViewListener$p(this.this$0);
                        if (searchViewListener == null) break block0;
                        searchViewListener.onSearchViewShownAnimation();
                    }
                    return false;
                }
            };
            SimpleAnimationUtils.revealOrFadeIn((View)this, this.animationDuration, animationListener, this.getRevealAnimationCenter()).start();
        } else {
            this.setVisibility(0);
        }
        this.hideTabLayout(animate);
        this.isSearchOpen = true;
        SearchViewListener searchViewListener = this.searchViewListener;
        if (searchViewListener != null) {
            searchViewListener.onSearchViewShown();
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    public static /* synthetic */ Unit showSearch$default(SimpleSearchView simpleSearchView, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return simpleSearchView.showSearch(bl);
    }

    @JvmOverloads
    @Nullable
    public final Unit showSearch() {
        return SimpleSearchView.showSearch$default(this, false, 1, null);
    }

    @JvmOverloads
    @Nullable
    public final Unit closeSearch(boolean animate) {
        Unit unit;
        SearchViewBinding searchViewBinding = this.binding;
        boolean bl = false;
        boolean bl2 = false;
        SearchViewBinding $this$with = searchViewBinding;
        boolean bl3 = false;
        if (!this.isSearchOpen) {
            return null;
        }
        this.searchIsClosing = true;
        EditText editText = $this$with.searchEditText;
        Intrinsics.checkNotNullExpressionValue((Object)editText, (String)"searchEditText");
        editText.setText((CharSequence)null);
        this.searchIsClosing = false;
        this.clearFocus();
        if (animate) {
            SimpleAnimationUtils.AnimationListener animationListener = new SimpleAnimationListener(this, animate){
                final /* synthetic */ SimpleSearchView this$0;
                final /* synthetic */ boolean $animate$inlined;
                {
                    this.this$0 = simpleSearchView;
                    this.$animate$inlined = bl;
                }

                public boolean onAnimationEnd(@NotNull View view) {
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                        SearchViewListener searchViewListener = SimpleSearchView.access$getSearchViewListener$p(this.this$0);
                        if (searchViewListener == null) break block0;
                        searchViewListener.onSearchViewClosedAnimation();
                    }
                    return false;
                }
            };
            SimpleAnimationUtils.hideOrFadeOut((View)this, this.animationDuration, animationListener, this.getRevealAnimationCenter()).start();
        } else {
            this.setVisibility(4);
        }
        this.showTabLayout(animate);
        this.isSearchOpen = false;
        SearchViewListener searchViewListener = this.searchViewListener;
        if (searchViewListener != null) {
            searchViewListener.onSearchViewClosed();
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    public static /* synthetic */ Unit closeSearch$default(SimpleSearchView simpleSearchView, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return simpleSearchView.closeSearch(bl);
    }

    @JvmOverloads
    @Nullable
    public final Unit closeSearch() {
        return SimpleSearchView.closeSearch$default(this, false, 1, null);
    }

    public final void setTabLayout(@NotNull TabLayout tabLayout) {
        Intrinsics.checkNotNullParameter((Object)tabLayout, (String)"tabLayout");
        TabLayout tabLayout2 = this.tabLayout = tabLayout;
        Intrinsics.checkNotNull((Object)tabLayout2);
        tabLayout2.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(this, tabLayout){
            final /* synthetic */ SimpleSearchView this$0;
            final /* synthetic */ TabLayout $tabLayout;

            public boolean onPreDraw() {
                SimpleSearchView.access$setTabLayoutInitialHeight$p(this.this$0, this.$tabLayout.getHeight());
                this.$tabLayout.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                return true;
            }
            {
                this.this$0 = this$0;
                this.$tabLayout = $captured_local_variable$1;
            }
        });
        TabLayout tabLayout3 = this.tabLayout;
        Intrinsics.checkNotNull((Object)tabLayout3);
        tabLayout3.addOnTabSelectedListener((TabLayout.OnTabSelectedListener)new SimpleOnTabSelectedListener(this){
            final /* synthetic */ SimpleSearchView this$0;

            public void onTabUnselected(@NotNull TabLayout.Tab tab) {
                Intrinsics.checkNotNullParameter((Object)tab, (String)"tab");
                SimpleSearchView.closeSearch$default(this.this$0, false, 1, null);
            }
            {
                this.this$0 = this$0;
            }
        });
    }

    @JvmOverloads
    public final void showTabLayout(boolean animate) {
        block2: {
            block1: {
                if (this.tabLayout == null) {
                    return;
                }
                if (!animate) break block1;
                TabLayout tabLayout = this.tabLayout;
                Intrinsics.checkNotNull((Object)tabLayout);
                SimpleAnimationUtils.verticalSlideView$default((View)tabLayout, 0, this.tabLayoutInitialHeight, this.animationDuration, null, 16, null).start();
                break block2;
            }
            TabLayout tabLayout = this.tabLayout;
            if (tabLayout == null) break block2;
            tabLayout.setVisibility(0);
        }
    }

    public static /* synthetic */ void showTabLayout$default(SimpleSearchView simpleSearchView, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        simpleSearchView.showTabLayout(bl);
    }

    @JvmOverloads
    public final void showTabLayout() {
        SimpleSearchView.showTabLayout$default(this, false, 1, null);
    }

    @JvmOverloads
    public final void hideTabLayout(boolean animate) {
        if (this.tabLayout == null) {
            return;
        }
        if (animate) {
            TabLayout tabLayout = this.tabLayout;
            Intrinsics.checkNotNull((Object)tabLayout);
            View view = (View)tabLayout;
            TabLayout tabLayout2 = this.tabLayout;
            Intrinsics.checkNotNull((Object)tabLayout2);
            SimpleAnimationUtils.verticalSlideView$default(view, tabLayout2.getHeight(), 0, this.animationDuration, null, 16, null).start();
        } else {
            TabLayout tabLayout = this.tabLayout;
            Intrinsics.checkNotNull((Object)tabLayout);
            tabLayout.setVisibility(8);
        }
    }

    public static /* synthetic */ void hideTabLayout$default(SimpleSearchView simpleSearchView, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        simpleSearchView.hideTabLayout(bl);
    }

    @JvmOverloads
    public final void hideTabLayout() {
        SimpleSearchView.hideTabLayout$default(this, false, 1, null);
    }

    public final boolean onBackPressed() {
        if (this.isSearchOpen) {
            SimpleSearchView.closeSearch$default(this, false, 1, null);
            return true;
        }
        return false;
    }

    @JvmOverloads
    public final boolean onActivityResult(int requestCode, int resultCode, @NotNull Intent data, boolean submit) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (requestCode == 735 && resultCode == -1) {
            String searchWrd;
            ArrayList matches = data.getStringArrayListExtra("android.speech.extra.RESULTS");
            Collection collection = matches;
            boolean bl = false;
            boolean bl2 = false;
            if (!(collection == null || collection.isEmpty()) && !TextUtils.isEmpty((CharSequence)(searchWrd = (String)matches.get(0)))) {
                this.setQuery(searchWrd, submit);
            }
            return true;
        }
        return false;
    }

    public static /* synthetic */ boolean onActivityResult$default(SimpleSearchView simpleSearchView, int n, int n2, Intent intent, boolean bl, int n3, Object object) {
        if ((n3 & 8) != 0) {
            bl = true;
        }
        return simpleSearchView.onActivityResult(n, n2, intent, bl);
    }

    @JvmOverloads
    public final boolean onActivityResult(int requestCode, int resultCode, @NotNull Intent data) {
        return SimpleSearchView.onActivityResult$default(this, requestCode, resultCode, data, false, 8, null);
    }

    public final int getCardStyle() {
        return this.style;
    }

    public final void setCardStyle(int value) {
        SearchViewBinding searchViewBinding = this.binding;
        boolean bl = false;
        boolean bl2 = false;
        SearchViewBinding $this$with = searchViewBinding;
        boolean bl3 = false;
        this.style = value;
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
        float elevation = 0.0f;
        switch (value) {
            case 1: {
                ConstraintLayout constraintLayout = $this$with.searchContainer;
                Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"searchContainer");
                constraintLayout.setBackground((Drawable)this.getCardStyleBackground());
                View view = $this$with.bottomLine;
                Intrinsics.checkNotNullExpressionValue((Object)view, (String)"bottomLine");
                view.setVisibility(8);
                Context context = this.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                int cardPadding = DimensUtils.convertDpToPx(6, context);
                layoutParams.setMargins(cardPadding, cardPadding, cardPadding, cardPadding);
                Context context2 = this.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
                elevation = DimensUtils.convertDpToPx(2, context2);
                break;
            }
            case 0: {
                $this$with.searchContainer.setBackgroundColor(-1);
                View view = $this$with.bottomLine;
                Intrinsics.checkNotNullExpressionValue((Object)view, (String)"bottomLine");
                view.setVisibility(0);
                break;
            }
            default: {
                $this$with.searchContainer.setBackgroundColor(-1);
                View view = $this$with.bottomLine;
                Intrinsics.checkNotNullExpressionValue((Object)view, (String)"bottomLine");
                view.setVisibility(0);
            }
        }
        ConstraintLayout constraintLayout = $this$with.searchContainer;
        Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"searchContainer");
        constraintLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        if (Build.VERSION.SDK_INT >= 21) {
            ConstraintLayout constraintLayout2 = $this$with.searchContainer;
            Intrinsics.checkNotNullExpressionValue((Object)constraintLayout2, (String)"searchContainer");
            constraintLayout2.setElevation(elevation);
        }
    }

    private final GradientDrawable getCardStyleBackground() {
        GradientDrawable drawable = new GradientDrawable();
        drawable.setColor(-1);
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        drawable.setCornerRadius((float)DimensUtils.convertDpToPx(4, context));
        return drawable;
    }

    public final void setIconsAlpha(float alpha) {
        SearchViewBinding searchViewBinding = this.binding;
        boolean bl = false;
        boolean bl2 = false;
        SearchViewBinding $this$with = searchViewBinding;
        boolean bl3 = false;
        ImageButton imageButton = $this$with.clearButton;
        Intrinsics.checkNotNullExpressionValue((Object)imageButton, (String)"clearButton");
        imageButton.setAlpha(alpha);
        ImageButton imageButton2 = $this$with.voiceButton;
        Intrinsics.checkNotNullExpressionValue((Object)imageButton2, (String)"voiceButton");
        imageButton2.setAlpha(alpha);
    }

    public final void setIconsColor(@ColorInt int color2) {
        SearchViewBinding searchViewBinding = this.binding;
        boolean bl = false;
        boolean bl2 = false;
        SearchViewBinding $this$with = searchViewBinding;
        boolean bl3 = false;
        ImageViewCompat.setImageTintList((ImageView)((ImageView)$this$with.clearButton), (ColorStateList)ColorStateList.valueOf((int)color2));
        ImageViewCompat.setImageTintList((ImageView)((ImageView)$this$with.voiceButton), (ColorStateList)ColorStateList.valueOf((int)color2));
    }

    public final void setBackIconAlpha(float alpha) {
        SearchViewBinding searchViewBinding = this.binding;
        boolean bl = false;
        boolean bl2 = false;
        SearchViewBinding $this$with = searchViewBinding;
        boolean bl3 = false;
        ImageButton imageButton = $this$with.backButton;
        Intrinsics.checkNotNullExpressionValue((Object)imageButton, (String)"backButton");
        imageButton.setAlpha(alpha);
    }

    public final void setBackIconColor(@ColorInt int color2) {
        SearchViewBinding searchViewBinding = this.binding;
        boolean bl = false;
        boolean bl2 = false;
        SearchViewBinding $this$with = searchViewBinding;
        boolean bl3 = false;
        ImageViewCompat.setImageTintList((ImageView)((ImageView)$this$with.backButton), (ColorStateList)ColorStateList.valueOf((int)color2));
    }

    public final void setBackIconDrawable(@Nullable Drawable drawable) {
        SearchViewBinding searchViewBinding = this.binding;
        boolean bl = false;
        boolean bl2 = false;
        SearchViewBinding $this$with = searchViewBinding;
        boolean bl3 = false;
        $this$with.backButton.setImageDrawable(drawable);
    }

    public final void setVoiceIconDrawable(@Nullable Drawable drawable) {
        SearchViewBinding searchViewBinding = this.binding;
        boolean bl = false;
        boolean bl2 = false;
        SearchViewBinding $this$with = searchViewBinding;
        boolean bl3 = false;
        $this$with.voiceButton.setImageDrawable(drawable);
    }

    public final void setClearIconDrawable(@Nullable Drawable drawable) {
        SearchViewBinding searchViewBinding = this.binding;
        boolean bl = false;
        boolean bl2 = false;
        SearchViewBinding $this$with = searchViewBinding;
        boolean bl3 = false;
        $this$with.clearButton.setImageDrawable(drawable);
    }

    public final void setSearchBackground(@Nullable Drawable background) {
        SearchViewBinding searchViewBinding = this.binding;
        boolean bl = false;
        boolean bl2 = false;
        SearchViewBinding $this$with = searchViewBinding;
        boolean bl3 = false;
        ConstraintLayout constraintLayout = $this$with.searchContainer;
        Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"searchContainer");
        constraintLayout.setBackground(background);
    }

    public final void setTextColor(@ColorInt int color2) {
        SearchViewBinding searchViewBinding = this.binding;
        boolean bl = false;
        boolean bl2 = false;
        SearchViewBinding $this$with = searchViewBinding;
        boolean bl3 = false;
        $this$with.searchEditText.setTextColor(color2);
    }

    public final void setHintTextColor(@ColorInt int color2) {
        SearchViewBinding searchViewBinding = this.binding;
        boolean bl = false;
        boolean bl2 = false;
        SearchViewBinding $this$with = searchViewBinding;
        boolean bl3 = false;
        $this$with.searchEditText.setHintTextColor(color2);
    }

    public final void setHint(@Nullable CharSequence hint) {
        SearchViewBinding searchViewBinding = this.binding;
        boolean bl = false;
        boolean bl2 = false;
        SearchViewBinding $this$with = searchViewBinding;
        boolean bl3 = false;
        EditText editText = $this$with.searchEditText;
        Intrinsics.checkNotNullExpressionValue((Object)editText, (String)"searchEditText");
        editText.setHint(hint);
    }

    public final void setInputType(int inputType) {
        SearchViewBinding searchViewBinding = this.binding;
        boolean bl = false;
        boolean bl2 = false;
        SearchViewBinding $this$with = searchViewBinding;
        boolean bl3 = false;
        EditText editText = $this$with.searchEditText;
        Intrinsics.checkNotNullExpressionValue((Object)editText, (String)"searchEditText");
        editText.setInputType(inputType);
    }

    public final void setCursorDrawable(@DrawableRes int drawable) {
        SearchViewBinding searchViewBinding = this.binding;
        boolean bl = false;
        boolean bl2 = false;
        SearchViewBinding $this$with = searchViewBinding;
        boolean bl3 = false;
        EditText editText = $this$with.searchEditText;
        Intrinsics.checkNotNullExpressionValue((Object)editText, (String)"searchEditText");
        EditTextReflectionUtils.setCursorDrawable(editText, drawable);
    }

    public final void setCursorColor(@ColorInt int color2) {
        SearchViewBinding searchViewBinding = this.binding;
        boolean bl = false;
        boolean bl2 = false;
        SearchViewBinding $this$with = searchViewBinding;
        boolean bl3 = false;
        EditText editText = $this$with.searchEditText;
        Intrinsics.checkNotNullExpressionValue((Object)editText, (String)"searchEditText");
        EditTextReflectionUtils.setCursorColor(editText, color2);
    }

    public final void enableVoiceSearch(boolean voiceSearch) {
        this.allowVoiceSearch = voiceSearch;
    }

    public final void setQuery(@Nullable CharSequence sequence, boolean submit) {
        SearchViewBinding searchViewBinding = this.binding;
        boolean bl = false;
        boolean bl2 = false;
        SearchViewBinding $this$with = searchViewBinding;
        boolean bl3 = false;
        $this$with.searchEditText.setText(sequence);
        if (sequence != null) {
            $this$with.searchEditText.setSelection($this$with.searchEditText.length());
            this.query = sequence;
        }
        if (submit && !TextUtils.isEmpty((CharSequence)sequence)) {
            this.onSubmitQuery();
        }
    }

    public final void showVoice(boolean show) {
        SearchViewBinding searchViewBinding = this.binding;
        boolean bl = false;
        boolean bl2 = false;
        SearchViewBinding $this$with = searchViewBinding;
        boolean bl3 = false;
        if (show && this.isVoiceAvailable() && this.allowVoiceSearch) {
            ImageButton imageButton = $this$with.voiceButton;
            Intrinsics.checkNotNullExpressionValue((Object)imageButton, (String)"voiceButton");
            imageButton.setVisibility(0);
        } else {
            ImageButton imageButton = $this$with.voiceButton;
            Intrinsics.checkNotNullExpressionValue((Object)imageButton, (String)"voiceButton");
            imageButton.setVisibility(8);
        }
    }

    public final void setMenuItem(@NotNull MenuItem menuItem) {
        Intrinsics.checkNotNullParameter((Object)menuItem, (String)"menuItem");
        menuItem.setOnMenuItemClickListener(new MenuItem.OnMenuItemClickListener(this){
            final /* synthetic */ SimpleSearchView this$0;

            public final boolean onMenuItemClick(MenuItem it) {
                SimpleSearchView.showSearch$default(this.this$0, false, 1, null);
                return true;
            }
            {
                this.this$0 = simpleSearchView;
            }
        });
    }

    public final void setOnQueryTextListener(@Nullable OnQueryTextListener listener) {
        this.onQueryChangeListener = listener;
    }

    public final void setOnSearchViewListener(@Nullable SearchViewListener listener) {
        this.searchViewListener = listener;
    }

    public final void setVoiceSearchPrompt(@Nullable String voiceSearchPrompt) {
        this.voiceSearchPrompt = voiceSearchPrompt;
    }

    @JvmOverloads
    public SimpleSearchView(@NotNull Context creationContext, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)creationContext, (String)"creationContext");
        super(creationContext, attrs, defStyleAttr);
        this.animationDuration = 250;
        this.voiceSearchPrompt = "";
        SearchViewBinding searchViewBinding = SearchViewBinding.inflate(LayoutInflater.from((Context)this.getContext()), (ViewGroup)this, true);
        Intrinsics.checkNotNullExpressionValue((Object)searchViewBinding, (String)"SearchViewBinding.inflat\u2026rom(context), this, true)");
        this.binding = searchViewBinding;
        this.initStyle(attrs, defStyleAttr);
        this.initSearchEditText();
        this.initClickListeners();
        this.showVoice(true);
        if (!this.isInEditMode()) {
            this.setVisibility(4);
        }
    }

    public /* synthetic */ SimpleSearchView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public SimpleSearchView(@NotNull Context creationContext, @Nullable AttributeSet attrs) {
        this(creationContext, attrs, 0, 4, null);
    }

    @JvmOverloads
    public SimpleSearchView(@NotNull Context creationContext) {
        this(creationContext, null, 0, 6, null);
    }

    public static final /* synthetic */ void access$onSubmitQuery(SimpleSearchView $this) {
        $this.onSubmitQuery();
    }

    public static final /* synthetic */ boolean access$getSearchIsClosing$p(SimpleSearchView $this) {
        return $this.searchIsClosing;
    }

    public static final /* synthetic */ void access$setSearchIsClosing$p(SimpleSearchView $this, boolean bl) {
        $this.searchIsClosing = bl;
    }

    public static final /* synthetic */ void access$onTextChanged(SimpleSearchView $this, CharSequence newText) {
        $this.onTextChanged(newText);
    }

    public static final /* synthetic */ Boolean access$clearSearch(SimpleSearchView $this) {
        return $this.clearSearch();
    }

    public static final /* synthetic */ void access$voiceSearch(SimpleSearchView $this) {
        $this.voiceSearch();
    }

    public static final /* synthetic */ SearchViewListener access$getSearchViewListener$p(SimpleSearchView $this) {
        return $this.searchViewListener;
    }

    public static final /* synthetic */ void access$setSearchViewListener$p(SimpleSearchView $this, SearchViewListener searchViewListener) {
        $this.searchViewListener = searchViewListener;
    }

    public static final /* synthetic */ int access$getTabLayoutInitialHeight$p(SimpleSearchView $this) {
        return $this.tabLayoutInitialHeight;
    }

    public static final /* synthetic */ void access$setTabLayoutInitialHeight$p(SimpleSearchView $this, int n) {
        $this.tabLayoutInitialHeight = n;
    }

    @Retention(value=AnnotationRetention.SOURCE)
    @java.lang.annotation.Retention(value=RetentionPolicy.SOURCE)
    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0087\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Lcom/ferfalk/simplesearchview/SimpleSearchView$Style;", "", "simplesearchview_release"})
    public static @interface Style {
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 #2\u00020\u0001:\u0001#B\u0011\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0012\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\tH\u0016R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0019\"\u0004\b\u001e\u0010\u001b\u00a8\u0006$"}, d2={"Lcom/ferfalk/simplesearchview/SimpleSearchView$SavedState;", "Landroid/view/View$BaseSavedState;", "superState", "Landroid/os/Parcelable;", "(Landroid/os/Parcelable;)V", "in", "Landroid/os/Parcel;", "(Landroid/os/Parcel;)V", "animationDuration", "", "getAnimationDuration", "()I", "setAnimationDuration", "(I)V", "isSearchOpen", "", "()Z", "setSearchOpen", "(Z)V", "keepQuery", "getKeepQuery", "setKeepQuery", "query", "", "getQuery", "()Ljava/lang/String;", "setQuery", "(Ljava/lang/String;)V", "voiceSearchPrompt", "getVoiceSearchPrompt", "setVoiceSearchPrompt", "writeToParcel", "", "out", "flags", "Companion", "simplesearchview_release"})
    public static final class SavedState
    extends View.BaseSavedState {
        @Nullable
        private String query;
        private boolean isSearchOpen;
        private int animationDuration;
        @Nullable
        private String voiceSearchPrompt;
        private boolean keepQuery;
        @NotNull
        private static final Parcelable.Creator<SavedState> CREATOR;
        public static final Companion Companion;

        @Nullable
        public final String getQuery() {
            return this.query;
        }

        public final void setQuery(@Nullable String string) {
            this.query = string;
        }

        public final boolean isSearchOpen() {
            return this.isSearchOpen;
        }

        public final void setSearchOpen(boolean bl) {
            this.isSearchOpen = bl;
        }

        public final int getAnimationDuration() {
            return this.animationDuration;
        }

        public final void setAnimationDuration(int n) {
            this.animationDuration = n;
        }

        @Nullable
        public final String getVoiceSearchPrompt() {
            return this.voiceSearchPrompt;
        }

        public final void setVoiceSearchPrompt(@Nullable String string) {
            this.voiceSearchPrompt = string;
        }

        public final boolean getKeepQuery() {
            return this.keepQuery;
        }

        public final void setKeepQuery(boolean bl) {
            this.keepQuery = bl;
        }

        public void writeToParcel(@NotNull Parcel out, int flags) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            super.writeToParcel(out, flags);
            out.writeString(this.query);
            out.writeInt(this.isSearchOpen ? 1 : 0);
            out.writeInt(this.animationDuration);
            out.writeString(this.voiceSearchPrompt);
            out.writeInt(this.keepQuery ? 1 : 0);
        }

        public SavedState(@Nullable Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.query = in.readString();
            this.isSearchOpen = in.readInt() == 1;
            this.animationDuration = in.readInt();
            this.voiceSearchPrompt = in.readString();
            this.keepQuery = in.readInt() == 1;
        }

        static {
            Companion = new Companion(null);
            CREATOR = (Parcelable.Creator)new Parcelable.Creator<SavedState>(){

                @Nullable
                public SavedState createFromParcel(@NotNull Parcel in) {
                    Intrinsics.checkNotNullParameter((Object)in, (String)"in");
                    return new SavedState(in, null);
                }

                @NotNull
                public SavedState[] newArray(int size) {
                    return new SavedState[size];
                }
            };
        }

        public /* synthetic */ SavedState(Parcel in, DefaultConstructorMarker $constructor_marker) {
            this(in);
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/ferfalk/simplesearchview/SimpleSearchView$SavedState$Companion;", "", "()V", "CREATOR", "Landroid/os/Parcelable$Creator;", "Lcom/ferfalk/simplesearchview/SimpleSearchView$SavedState;", "getCREATOR", "()Landroid/os/Parcelable$Creator;", "simplesearchview_release"})
        public static final class Companion {
            @NotNull
            public final Parcelable.Creator<SavedState> getCREATOR() {
                return CREATOR;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\b\u0010\u0006\u001a\u00020\u0003H&J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0005H&\u00a8\u0006\t"}, d2={"Lcom/ferfalk/simplesearchview/SimpleSearchView$OnQueryTextListener;", "", "onQueryTextChange", "", "newText", "", "onQueryTextCleared", "onQueryTextSubmit", "query", "simplesearchview_release"})
    public static interface OnQueryTextListener {
        public boolean onQueryTextSubmit(@NotNull String var1);

        public boolean onQueryTextChange(@NotNull String var1);

        public boolean onQueryTextCleared();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\b\u0010\u0004\u001a\u00020\u0003H&J\b\u0010\u0005\u001a\u00020\u0003H&J\b\u0010\u0006\u001a\u00020\u0003H&\u00a8\u0006\u0007"}, d2={"Lcom/ferfalk/simplesearchview/SimpleSearchView$SearchViewListener;", "", "onSearchViewClosed", "", "onSearchViewClosedAnimation", "onSearchViewShown", "onSearchViewShownAnimation", "simplesearchview_release"})
    public static interface SearchViewListener {
        public void onSearchViewShown();

        public void onSearchViewClosed();

        public void onSearchViewShownAnimation();

        public void onSearchViewClosedAnimation();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/ferfalk/simplesearchview/SimpleSearchView$Companion;", "", "()V", "ANIMATION_CENTER_PADDING", "", "BACK_ICON_ALPHA_DEFAULT", "", "CARD_CORNER_RADIUS", "CARD_ELEVATION", "CARD_PADDING", "ICONS_ALPHA_DEFAULT", "REQUEST_VOICE_SEARCH", "STYLE_BAR", "STYLE_CARD", "simplesearchview_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

