/*
 * Decompiled with CFR 0.152.
 */
package com.eulerian.android.sdk;

import com.eulerian.android.sdk.CurrencyISO;
import com.eulerian.android.sdk.EALog;
import com.eulerian.android.sdk.EAProperties;
import com.eulerian.android.sdk.JSONUtils;
import com.eulerian.android.sdk.Product;
import org.json.JSONArray;
import org.json.JSONObject;

public class EAEstimate
extends EAProperties {
    private static final String KEY_ESTIMATE = "estimate";
    private static final String KEY_REF = "ref";
    private static final String KEY_ESTIMATE_AMOUNT = "amount";
    private static final String KEY_CURRENCY = "currency";
    private static final String KEY_TYPE = "type";
    private static final String KEY_PRODUCTS = "products";
    private static final String KEY_PRODUCT_AMOUNT = "amount";
    private static final String KEY_QUANTITY = "quantity";

    protected EAEstimate(Builder builder) {
        super(builder);
    }

    public static class Builder
    extends EAProperties.Builder<Builder> {
        private final JSONArray products = new JSONArray();

        public Builder(String path, String ref) {
            super(path);
            this.set(EAEstimate.KEY_ESTIMATE, "1");
            this.set(EAEstimate.KEY_REF, ref);
        }

        public Builder setAmount(double amount) {
            this.set("amount", String.valueOf(amount));
            return this;
        }

        public Builder setCurrency(String currency) {
            this.set(EAEstimate.KEY_CURRENCY, currency);
            return this;
        }

        public Builder setCurrency(CurrencyISO currency) {
            this.set(EAEstimate.KEY_CURRENCY, currency.value);
            return this;
        }

        public Builder setType(String type) {
            this.set(EAEstimate.KEY_TYPE, type);
            return this;
        }

        public Builder addProduct(Product product, double amount, int quantity) {
            if (quantity <= 0) {
                EALog.w(EAEstimate.class.getSimpleName() + "#addProduct() : quantity might be > 0. Current is " + quantity);
            }
            JSONObject productJson = product.getJson();
            JSONUtils.put(productJson, "amount", amount);
            JSONUtils.put(productJson, EAEstimate.KEY_QUANTITY, quantity);
            this.products.put((Object)productJson);
            return this;
        }

        @Override
        public EAEstimate build() {
            JSONUtils.put(this.properties, EAEstimate.KEY_PRODUCTS, this.products);
            return new EAEstimate(this);
        }
    }
}

