/*
 * Decompiled with CFR 0.152.
 */
package com.xcode.onboarding;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.xcode.onboarding.OnBoardingPage;
import com.xcode.onboarding.R;
import java.util.List;

public class ViewPagerAdapter
extends RecyclerView.Adapter<onBoardingViewHolder> {
    List<OnBoardingPage> pages;

    public ViewPagerAdapter(@NonNull List<OnBoardingPage> pages) {
        this.pages = pages;
    }

    @NonNull
    public onBoardingViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new onBoardingViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.onboarding, parent, false));
    }

    public void onBindViewHolder(@NonNull onBoardingViewHolder holder, int position) {
        holder.imageView.setImageResource(this.pages.get(position).getImage());
        holder.heading.setText((CharSequence)this.pages.get(position).getTitle());
        holder.description.setText((CharSequence)this.pages.get(position).getDescription());
    }

    public int getItemCount() {
        return this.pages.size();
    }

    protected static class onBoardingViewHolder
    extends RecyclerView.ViewHolder {
        ImageView imageView;
        TextView heading;
        TextView description;

        public onBoardingViewHolder(View view) {
            super(view);
            this.imageView = (ImageView)view.findViewById(R.id.image);
            this.heading = (TextView)view.findViewById(R.id.heading);
            this.description = (TextView)view.findViewById(R.id.description);
        }
    }
}

