/*
 * Decompiled with CFR 0.152.
 */
package ua.naiksoftware.stomp.client;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ua.naiksoftware.stomp.StompHeader;
import ua.naiksoftware.stomp.client.StompCommand;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u000e\u001a\u00020\u0003J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0010\u001a\u00020\u0003R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0019\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0012"}, d2={"Lua/naiksoftware/stomp/client/StompMessage;", "", "stompCommand", "", "stompHeaders", "", "Lua/naiksoftware/stomp/StompHeader;", "payload", "(Ljava/lang/String;Ljava/util/List;Ljava/lang/String;)V", "getPayload", "()Ljava/lang/String;", "getStompCommand", "getStompHeaders", "()Ljava/util/List;", "compile", "findHeader", "key", "Companion", "lib_release"})
public final class StompMessage {
    @NotNull
    private final String stompCommand;
    @Nullable
    private final List<StompHeader> stompHeaders;
    @Nullable
    private final String payload;
    @NotNull
    private static final String TERMINATE_MESSAGE_SYMBOL = "\u0000";
    private static final Pattern PATTERN_HEADER;
    public static final Companion Companion;

    @Nullable
    public final String findHeader(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        if (this.stompHeaders == null) {
            return null;
        }
        for (StompHeader header : this.stompHeaders) {
            if (!Intrinsics.areEqual((Object)header.getKey(), (Object)key)) continue;
            return header.getValue();
        }
        return null;
    }

    @NotNull
    public final String compile() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.stompCommand).append('\n');
        List<StompHeader> list = this.stompHeaders;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        for (StompHeader header : list) {
            builder.append(header.getKey()).append(':').append(header.getValue()).append('\n');
        }
        builder.append('\n');
        if (this.payload != null) {
            builder.append(this.payload).append("\n\n");
        }
        builder.append(Companion.getTERMINATE_MESSAGE_SYMBOL());
        String string = builder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"builder.toString()");
        return string;
    }

    @NotNull
    public final String getStompCommand() {
        return this.stompCommand;
    }

    @Nullable
    public final List<StompHeader> getStompHeaders() {
        return this.stompHeaders;
    }

    @Nullable
    public final String getPayload() {
        return this.payload;
    }

    public StompMessage(@NotNull String stompCommand, @Nullable List<? extends StompHeader> stompHeaders, @Nullable String payload) {
        Intrinsics.checkParameterIsNotNull((Object)stompCommand, (String)"stompCommand");
        this.stompCommand = stompCommand;
        this.stompHeaders = stompHeaders;
        this.payload = payload;
    }

    static {
        Companion = new Companion(null);
        TERMINATE_MESSAGE_SYMBOL = TERMINATE_MESSAGE_SYMBOL;
        PATTERN_HEADER = Pattern.compile("([^:\\s]+)\\s*:\\s*([^:\\s]+)");
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\tR\u001c\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lua/naiksoftware/stomp/client/StompMessage$Companion;", "", "()V", "PATTERN_HEADER", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "getPATTERN_HEADER", "()Ljava/util/regex/Pattern;", "TERMINATE_MESSAGE_SYMBOL", "", "getTERMINATE_MESSAGE_SYMBOL", "()Ljava/lang/String;", "from", "Lua/naiksoftware/stomp/client/StompMessage;", "data", "lib_release"})
    public static final class Companion {
        @NotNull
        public final String getTERMINATE_MESSAGE_SYMBOL() {
            return TERMINATE_MESSAGE_SYMBOL;
        }

        private final Pattern getPATTERN_HEADER() {
            return PATTERN_HEADER;
        }

        @NotNull
        public final StompMessage from(@Nullable String data) {
            block8: {
                block7: {
                    if (data == null) break block7;
                    CharSequence $receiver$iv = data;
                    CharSequence $receiver$iv$iv = $receiver$iv;
                    int startIndex$iv$iv = 0;
                    int endIndex$iv$iv = $receiver$iv$iv.length() - 1;
                    boolean startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        boolean match$iv$iv;
                        int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        char it = $receiver$iv$iv.charAt(index$iv$iv);
                        boolean bl = match$iv$iv = it <= ' ';
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    if (!(($receiver$iv = (CharSequence)((Object)$receiver$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()).length() == 0)) break block8;
                }
                return new StompMessage(StompCommand.INSTANCE.getUNKNOWN(), null, data);
            }
            Scanner reader = new Scanner(new StringReader(data));
            reader.useDelimiter("\\n");
            String command = reader.next();
            ArrayList<StompHeader> headers = new ArrayList<StompHeader>();
            while (reader.hasNext(this.getPATTERN_HEADER())) {
                Matcher matcher = this.getPATTERN_HEADER().matcher(reader.next());
                matcher.find();
                headers.add(new StompHeader(matcher.group(1), matcher.group(2)));
            }
            reader.skip("\\s");
            reader.useDelimiter(this.getTERMINATE_MESSAGE_SYMBOL());
            String payload = reader.hasNext() ? reader.next() : null;
            String string = command;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"command");
            return new StompMessage(string, (List<? extends StompHeader>)headers, payload);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

