/*
 * Decompiled with CFR 0.152.
 */
package com.zhihu.matisse.internal.ui.widget;

import android.graphics.Rect;
import android.view.View;
import androidx.recyclerview.widget.RecyclerView;

public class MediaGridInset
extends RecyclerView.ItemDecoration {
    private int mSpanCount;
    private int mSpacing;
    private boolean mIncludeEdge;

    public MediaGridInset(int spanCount, int spacing, boolean includeEdge) {
        this.mSpanCount = spanCount;
        this.mSpacing = spacing;
        this.mIncludeEdge = includeEdge;
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        int position = parent.getChildAdapterPosition(view);
        int column = position % this.mSpanCount;
        if (this.mIncludeEdge) {
            outRect.left = this.mSpacing - column * this.mSpacing / this.mSpanCount;
            outRect.right = (column + 1) * this.mSpacing / this.mSpanCount;
            if (position < this.mSpanCount) {
                outRect.top = this.mSpacing;
            }
            outRect.bottom = this.mSpacing;
        } else {
            outRect.left = column * this.mSpacing / this.mSpanCount;
            outRect.right = this.mSpacing - (column + 1) * this.mSpacing / this.mSpanCount;
            if (position >= this.mSpanCount) {
                outRect.top = this.mSpacing;
            }
        }
    }
}

