/*
 * Decompiled with CFR 0.152.
 */
package com.doublesymmetry.kotlinaudio.players;

import android.content.Context;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.ResultReceiver;
import android.support.v4.media.MediaMetadataCompat;
import android.support.v4.media.RatingCompat;
import android.support.v4.media.session.MediaSessionCompat;
import androidx.annotation.CallSuper;
import androidx.core.content.ContextCompat;
import androidx.media.AudioAttributesCompat;
import androidx.media.AudioFocusRequestCompat;
import androidx.media.AudioManagerCompat;
import com.doublesymmetry.kotlinaudio.event.EventHolder;
import com.doublesymmetry.kotlinaudio.event.NotificationEventHolder;
import com.doublesymmetry.kotlinaudio.event.PlayerEventHolder;
import com.doublesymmetry.kotlinaudio.models.AudioItem;
import com.doublesymmetry.kotlinaudio.models.AudioItemTransitionReason;
import com.doublesymmetry.kotlinaudio.models.AudioPlayerState;
import com.doublesymmetry.kotlinaudio.models.BufferConfig;
import com.doublesymmetry.kotlinaudio.models.CacheConfig;
import com.doublesymmetry.kotlinaudio.models.DefaultPlayerOptions;
import com.doublesymmetry.kotlinaudio.models.MediaSessionCallback;
import com.doublesymmetry.kotlinaudio.models.MediaType;
import com.doublesymmetry.kotlinaudio.models.NotificationMetadata;
import com.doublesymmetry.kotlinaudio.models.PlaybackMetadata;
import com.doublesymmetry.kotlinaudio.models.PlayerConfig;
import com.doublesymmetry.kotlinaudio.models.PlayerOptions;
import com.doublesymmetry.kotlinaudio.models.PositionChangedReason;
import com.doublesymmetry.kotlinaudio.notification.NotificationManager;
import com.doublesymmetry.kotlinaudio.players.MediaSourceExtKt;
import com.doublesymmetry.kotlinaudio.utils.UtilsKt;
import com.google.android.exoplayer2.DefaultLoadControl;
import com.google.android.exoplayer2.ExoPlayer;
import com.google.android.exoplayer2.ForwardingPlayer;
import com.google.android.exoplayer2.LoadControl;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.database.DatabaseProvider;
import com.google.android.exoplayer2.database.StandaloneDatabaseProvider;
import com.google.android.exoplayer2.ext.mediasession.MediaSessionConnector;
import com.google.android.exoplayer2.extractor.DefaultExtractorsFactory;
import com.google.android.exoplayer2.extractor.ExtractorsFactory;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.ProgressiveMediaSource;
import com.google.android.exoplayer2.source.dash.DashChunkSource;
import com.google.android.exoplayer2.source.dash.DashMediaSource;
import com.google.android.exoplayer2.source.dash.DefaultDashChunkSource;
import com.google.android.exoplayer2.source.hls.HlsMediaSource;
import com.google.android.exoplayer2.source.smoothstreaming.DefaultSsChunkSource;
import com.google.android.exoplayer2.source.smoothstreaming.SsChunkSource;
import com.google.android.exoplayer2.source.smoothstreaming.SsMediaSource;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.upstream.DefaultDataSourceFactory;
import com.google.android.exoplayer2.upstream.DefaultHttpDataSource;
import com.google.android.exoplayer2.upstream.RawResourceDataSource;
import com.google.android.exoplayer2.upstream.cache.Cache;
import com.google.android.exoplayer2.upstream.cache.CacheDataSource;
import com.google.android.exoplayer2.upstream.cache.CacheEvictor;
import com.google.android.exoplayer2.upstream.cache.LeastRecentlyUsedCacheEvictor;
import com.google.android.exoplayer2.upstream.cache.SimpleCache;
import com.google.android.exoplayer2.util.Util;
import java.io.File;
import java.lang.invoke.LambdaMetafactory;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00dc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 ~2\u00020\u0001:\u0002~\u007fB+\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\b\u0010]\u001a\u00020^H\u0002J\u001a\u0010_\u001a\u00020`2\u0006\u0010a\u001a\u00020b2\b\u0010c\u001a\u0004\u0018\u00010dH\u0002J\b\u0010e\u001a\u00020(H\u0002J\u001a\u0010f\u001a\u00020`2\u0006\u0010a\u001a\u00020b2\b\u0010c\u001a\u0004\u0018\u00010dH\u0002J\u0018\u0010g\u001a\u00020h2\u0006\u0010a\u001a\u00020b2\u0006\u0010c\u001a\u00020dH\u0002J\u001a\u0010i\u001a\u00020`2\u0006\u0010a\u001a\u00020b2\b\u0010c\u001a\u0004\u0018\u00010dH\u0002J\b\u0010j\u001a\u00020^H\u0017J\u0010\u0010k\u001a\u00020d2\u0006\u0010c\u001a\u00020dH\u0002J\u0010\u0010l\u001a\u00020b2\u0006\u0010m\u001a\u00020\u0018H\u0002J\u0010\u0010n\u001a\u00020`2\u0006\u0010m\u001a\u00020\u0018H\u0004J\u001a\u0010o\u001a\u00020^2\u0006\u0010p\u001a\u00020\u00182\b\b\u0002\u0010q\u001a\u00020\fH\u0016J\u0010\u0010r\u001a\u00020^2\u0006\u0010s\u001a\u00020OH\u0016J\u0006\u0010t\u001a\u00020^J\u0006\u0010u\u001a\u00020^J\b\u0010v\u001a\u00020^H\u0002J\u0016\u0010w\u001a\u00020^2\u0006\u0010\u001b\u001a\u00020\u00122\u0006\u0010x\u001a\u00020yJ\u0010\u0010z\u001a\u00020{2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010|\u001a\u00020^H\u0016J\u0006\u0010}\u001a\u00020^R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0014R\u0011\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\"X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010*\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u000eR\u0014\u0010+\u001a\u00020,X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0014\u0010/\u001a\u000200X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u000e\u00103\u001a\u000204X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u00105\u001a\u000206\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108R\u000e\u00109\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010<\u001a\u00020;2\u0006\u0010:\u001a\u00020;8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@R\u000e\u0010A\u001a\u00020BX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010C\u001a\u00020DX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010FR$\u0010H\u001a\u00020G2\u0006\u0010:\u001a\u00020G@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bI\u0010J\"\u0004\bK\u0010LR\u0011\u0010M\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\bN\u0010\u0014R$\u0010P\u001a\u00020O2\u0006\u0010:\u001a\u00020O@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bQ\u0010R\"\u0004\bS\u0010TR\u000e\u0010U\u001a\u00020VX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010W\u001a\u00020;2\u0006\u0010:\u001a\u00020;8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bX\u0010>\"\u0004\bY\u0010@R\u001e\u0010Z\u001a\u00020;2\u0006\u0010:\u001a\u00020;@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b[\u0010@R\u000e\u0010\\\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0080\u0001"}, d2={"Lcom/doublesymmetry/kotlinaudio/players/BaseAudioPlayer;", "Landroid/media/AudioManager$OnAudioFocusChangeListener;", "context", "Landroid/content/Context;", "playerConfig", "Lcom/doublesymmetry/kotlinaudio/models/PlayerConfig;", "bufferConfig", "Lcom/doublesymmetry/kotlinaudio/models/BufferConfig;", "cacheConfig", "Lcom/doublesymmetry/kotlinaudio/models/CacheConfig;", "(Landroid/content/Context;Lcom/doublesymmetry/kotlinaudio/models/PlayerConfig;Lcom/doublesymmetry/kotlinaudio/models/BufferConfig;Lcom/doublesymmetry/kotlinaudio/models/CacheConfig;)V", "automaticallyUpdateNotificationMetadata", "", "getAutomaticallyUpdateNotificationMetadata", "()Z", "setAutomaticallyUpdateNotificationMetadata", "(Z)V", "bufferedPosition", "", "getBufferedPosition", "()J", "cache", "Lcom/google/android/exoplayer2/upstream/cache/SimpleCache;", "currentItem", "Lcom/doublesymmetry/kotlinaudio/models/AudioItem;", "getCurrentItem", "()Lcom/doublesymmetry/kotlinaudio/models/AudioItem;", "duration", "getDuration", "event", "Lcom/doublesymmetry/kotlinaudio/event/EventHolder;", "getEvent", "()Lcom/doublesymmetry/kotlinaudio/event/EventHolder;", "exoPlayer", "Lcom/google/android/exoplayer2/ExoPlayer;", "getExoPlayer", "()Lcom/google/android/exoplayer2/ExoPlayer;", "focus", "Landroidx/media/AudioFocusRequestCompat;", "forwardingPlayer", "Lcom/google/android/exoplayer2/ForwardingPlayer;", "hasAudioFocus", "isPlaying", "mediaSession", "Landroid/support/v4/media/session/MediaSessionCompat;", "getMediaSession", "()Landroid/support/v4/media/session/MediaSessionCompat;", "mediaSessionConnector", "Lcom/google/android/exoplayer2/ext/mediasession/MediaSessionConnector;", "getMediaSessionConnector", "()Lcom/google/android/exoplayer2/ext/mediasession/MediaSessionConnector;", "notificationEventHolder", "Lcom/doublesymmetry/kotlinaudio/event/NotificationEventHolder;", "notificationManager", "Lcom/doublesymmetry/kotlinaudio/notification/NotificationManager;", "getNotificationManager", "()Lcom/doublesymmetry/kotlinaudio/notification/NotificationManager;", "oldPosition", "value", "", "playbackSpeed", "getPlaybackSpeed", "()F", "setPlaybackSpeed", "(F)V", "playerEventHolder", "Lcom/doublesymmetry/kotlinaudio/event/PlayerEventHolder;", "playerOptions", "Lcom/doublesymmetry/kotlinaudio/models/PlayerOptions;", "getPlayerOptions", "()Lcom/doublesymmetry/kotlinaudio/models/PlayerOptions;", "Lcom/doublesymmetry/kotlinaudio/models/AudioPlayerState;", "playerState", "getPlayerState", "()Lcom/doublesymmetry/kotlinaudio/models/AudioPlayerState;", "setPlayerState", "(Lcom/doublesymmetry/kotlinaudio/models/AudioPlayerState;)V", "position", "getPosition", "", "ratingType", "getRatingType", "()I", "setRatingType", "(I)V", "scope", "Lkotlinx/coroutines/CoroutineScope;", "volume", "getVolume", "setVolume", "volumeMultiplier", "setVolumeMultiplier", "wasDucking", "abandonAudioFocusIfHeld", "", "createDashSource", "Lcom/google/android/exoplayer2/source/MediaSource;", "mediaItem", "Lcom/google/android/exoplayer2/MediaItem;", "factory", "Lcom/google/android/exoplayer2/upstream/DataSource$Factory;", "createForwardingPlayer", "createHlsSource", "createProgressiveSource", "Lcom/google/android/exoplayer2/source/ProgressiveMediaSource;", "createSsSource", "destroy", "enableCaching", "getMediaItemFromAudioItem", "audioItem", "getMediaSourceFromAudioItem", "load", "item", "playWhenReady", "onAudioFocusChange", "focusChange", "pause", "play", "requestAudioFocus", "seek", "unit", "Ljava/util/concurrent/TimeUnit;", "setupBuffer", "Lcom/google/android/exoplayer2/DefaultLoadControl;", "stop", "togglePlaying", "Companion", "PlayerListener", "kotlin-audio_release"})
public abstract class BaseAudioPlayer
implements AudioManager.OnAudioFocusChangeListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @Nullable
    private final BufferConfig bufferConfig;
    @Nullable
    private final CacheConfig cacheConfig;
    @NotNull
    private final ExoPlayer exoPlayer;
    @NotNull
    private final ForwardingPlayer forwardingPlayer;
    @Nullable
    private SimpleCache cache;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final NotificationManager notificationManager;
    @NotNull
    private final PlayerOptions playerOptions;
    @NotNull
    private AudioPlayerState playerState;
    private long oldPosition;
    private boolean automaticallyUpdateNotificationMetadata;
    private float volumeMultiplier;
    @NotNull
    private final NotificationEventHolder notificationEventHolder;
    @NotNull
    private final PlayerEventHolder playerEventHolder;
    private int ratingType;
    @NotNull
    private final EventHolder event;
    @Nullable
    private AudioFocusRequestCompat focus;
    private boolean hasAudioFocus;
    private boolean wasDucking;
    @NotNull
    private final MediaSessionCompat mediaSession;
    @NotNull
    private final MediaSessionConnector mediaSessionConnector;
    @NotNull
    public static final String APPLICATION_NAME = "react-native-track-player";

    /*
     * WARNING - void declaration
     */
    public BaseAudioPlayer(@NotNull Context context, @NotNull PlayerConfig playerConfig, @Nullable BufferConfig bufferConfig, @Nullable CacheConfig cacheConfig) {
        ExoPlayer.Builder builder;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)playerConfig, (String)"playerConfig");
        this.context = context;
        this.bufferConfig = bufferConfig;
        this.cacheConfig = cacheConfig;
        this.scope = CoroutineScopeKt.MainScope();
        this.playerOptions = new DefaultPlayerOptions(false, 1, null);
        this.playerState = AudioPlayerState.IDLE;
        this.automaticallyUpdateNotificationMetadata = true;
        this.volumeMultiplier = 1.0f;
        this.notificationEventHolder = new NotificationEventHolder();
        this.playerEventHolder = new PlayerEventHolder();
        this.event = new EventHolder(this.notificationEventHolder, this.playerEventHolder);
        this.mediaSession = new MediaSessionCompat(this.context, "KotlinAudioPlayer");
        this.mediaSessionConnector = new MediaSessionConnector(this.mediaSession);
        if (this.cacheConfig != null) {
            File cacheDir = new File(this.context.getCacheDir(), this.cacheConfig.getIdentifier());
            DatabaseProvider db = (DatabaseProvider)new StandaloneDatabaseProvider(this.context);
            Long l = this.cacheConfig.getMaxCacheSize();
            this.cache = new SimpleCache(cacheDir, (CacheEvictor)new LeastRecentlyUsedCacheEvictor(l != null ? l : 0L), db);
        }
        ExoPlayer.Builder builder2 = builder = new ExoPlayer.Builder(this.context).setHandleAudioBecomingNoisy(playerConfig.getHandleAudioBecomingNoisy());
        BaseAudioPlayer baseAudioPlayer = this;
        boolean bl = false;
        if (this.bufferConfig != null) {
            void $this$_init__u24lambda_u2d0;
            $this$_init__u24lambda_u2d0.setLoadControl((LoadControl)this.setupBuffer(this.bufferConfig));
        }
        ExoPlayer exoPlayer = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)exoPlayer, (String)"Builder(context)\n       \u2026   }\n            .build()");
        baseAudioPlayer.exoPlayer = exoPlayer;
        this.forwardingPlayer = this.createForwardingPlayer();
        this.mediaSession.setActive(true);
        Player playerToUse = playerConfig.getInterceptPlayerActionsTriggeredExternally() ? (Player)this.forwardingPlayer : (Player)this.exoPlayer;
        MediaSessionCompat.Token token = this.mediaSession.getSessionToken();
        Intrinsics.checkNotNullExpressionValue((Object)token, (String)"mediaSession.sessionToken");
        this.notificationManager = new NotificationManager(this.context, playerToUse, token, this.notificationEventHolder);
        this.exoPlayer.addListener((Player.Listener)new PlayerListener());
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, playerToUse, null){
            int label;
            final /* synthetic */ BaseAudioPlayer this$0;
            final /* synthetic */ Player $playerToUse;
            {
                this.this$0 = $receiver;
                this.$playerToUse = $playerToUse;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.this$0.getMediaSessionConnector().setPlayer(this.$playerToUse);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @NotNull
    protected final ExoPlayer getExoPlayer() {
        return this.exoPlayer;
    }

    @NotNull
    public final NotificationManager getNotificationManager() {
        return this.notificationManager;
    }

    @NotNull
    public PlayerOptions getPlayerOptions() {
        return this.playerOptions;
    }

    @Nullable
    public AudioItem getCurrentItem() {
        MediaItem mediaItem = this.exoPlayer.getCurrentMediaItem();
        return (AudioItem)(mediaItem != null && (mediaItem = mediaItem.localConfiguration) != null ? mediaItem.tag : null);
    }

    @NotNull
    public final AudioPlayerState getPlayerState() {
        return this.playerState;
    }

    private final void setPlayerState(AudioPlayerState value) {
        if (value != this.playerState) {
            this.playerState = value;
            this.playerEventHolder.updateAudioPlayerState$kotlin_audio_release(value);
        }
    }

    public final long getDuration() {
        return this.exoPlayer.getDuration() == -9223372036854775807L ? 0L : this.exoPlayer.getDuration();
    }

    public final long getPosition() {
        return this.exoPlayer.getCurrentPosition() == -1L ? 0L : this.exoPlayer.getCurrentPosition();
    }

    public final long getBufferedPosition() {
        return this.exoPlayer.getBufferedPosition() == -1L ? 0L : this.exoPlayer.getBufferedPosition();
    }

    public final float getVolume() {
        return this.exoPlayer.getVolume();
    }

    public final void setVolume(float value) {
        this.exoPlayer.setVolume(value * this.volumeMultiplier);
    }

    public final float getPlaybackSpeed() {
        return this.exoPlayer.getPlaybackParameters().speed;
    }

    public final void setPlaybackSpeed(float value) {
        this.exoPlayer.setPlaybackSpeed(value);
    }

    public final boolean getAutomaticallyUpdateNotificationMetadata() {
        return this.automaticallyUpdateNotificationMetadata;
    }

    public final void setAutomaticallyUpdateNotificationMetadata(boolean bl) {
        this.automaticallyUpdateNotificationMetadata = bl;
    }

    private final void setVolumeMultiplier(float value) {
        this.volumeMultiplier = value;
        this.setVolume(this.getVolume());
    }

    public final boolean isPlaying() {
        return this.exoPlayer.isPlaying();
    }

    public final int getRatingType() {
        return this.ratingType;
    }

    public final void setRatingType(int value) {
        this.ratingType = value;
        this.mediaSession.setRatingType(this.ratingType);
        this.mediaSessionConnector.setRatingCallback(new MediaSessionConnector.RatingCallback(this){
            final /* synthetic */ BaseAudioPlayer this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean onCommand(@NotNull Player player, @NotNull String command, @Nullable Bundle extras, @Nullable ResultReceiver cb) {
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                Intrinsics.checkNotNullParameter((Object)command, (String)"command");
                return true;
            }

            public void onSetRating(@NotNull Player player, @NotNull RatingCompat rating) {
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                Intrinsics.checkNotNullParameter((Object)rating, (String)"rating");
                BaseAudioPlayer.access$getPlayerEventHolder$p(this.this$0).updateOnPlayerActionTriggeredExternally$kotlin_audio_release(new MediaSessionCallback.RATING(rating, null));
            }

            public void onSetRating(@NotNull Player player, @NotNull RatingCompat rating, @Nullable Bundle extras) {
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                Intrinsics.checkNotNullParameter((Object)rating, (String)"rating");
                BaseAudioPlayer.access$getPlayerEventHolder$p(this.this$0).updateOnPlayerActionTriggeredExternally$kotlin_audio_release(new MediaSessionCallback.RATING(rating, extras));
            }
        });
    }

    @NotNull
    public final EventHolder getEvent() {
        return this.event;
    }

    @NotNull
    protected final MediaSessionCompat getMediaSession() {
        return this.mediaSession;
    }

    @NotNull
    protected final MediaSessionConnector getMediaSessionConnector() {
        return this.mediaSessionConnector;
    }

    private final ForwardingPlayer createForwardingPlayer() {
        ExoPlayer exoPlayer = this.exoPlayer;
        return new ForwardingPlayer(this, exoPlayer){
            final /* synthetic */ BaseAudioPlayer this$0;
            {
                this.this$0 = $receiver;
                super((Player)$super_call_param$1);
            }

            public void play() {
                BaseAudioPlayer.access$getPlayerEventHolder$p(this.this$0).updateOnPlayerActionTriggeredExternally$kotlin_audio_release(MediaSessionCallback.PLAY.INSTANCE);
            }

            public void pause() {
                BaseAudioPlayer.access$getPlayerEventHolder$p(this.this$0).updateOnPlayerActionTriggeredExternally$kotlin_audio_release(MediaSessionCallback.PAUSE.INSTANCE);
            }

            public void seekToNext() {
                BaseAudioPlayer.access$getPlayerEventHolder$p(this.this$0).updateOnPlayerActionTriggeredExternally$kotlin_audio_release(MediaSessionCallback.NEXT.INSTANCE);
            }

            public void seekToPrevious() {
                BaseAudioPlayer.access$getPlayerEventHolder$p(this.this$0).updateOnPlayerActionTriggeredExternally$kotlin_audio_release(MediaSessionCallback.PREVIOUS.INSTANCE);
            }

            public void seekForward() {
                BaseAudioPlayer.access$getPlayerEventHolder$p(this.this$0).updateOnPlayerActionTriggeredExternally$kotlin_audio_release(MediaSessionCallback.FORWARD.INSTANCE);
            }

            public void seekBack() {
                BaseAudioPlayer.access$getPlayerEventHolder$p(this.this$0).updateOnPlayerActionTriggeredExternally$kotlin_audio_release(MediaSessionCallback.REWIND.INSTANCE);
            }

            public void stop() {
                BaseAudioPlayer.access$getPlayerEventHolder$p(this.this$0).updateOnPlayerActionTriggeredExternally$kotlin_audio_release(MediaSessionCallback.STOP.INSTANCE);
            }

            public void seekTo(long positionMs) {
                BaseAudioPlayer.access$getPlayerEventHolder$p(this.this$0).updateOnPlayerActionTriggeredExternally$kotlin_audio_release(new MediaSessionCallback.SEEK(positionMs));
            }
        };
    }

    /*
     * Unable to fully structure code
     */
    private final DefaultLoadControl setupBuffer(BufferConfig bufferConfig) {
        $this$setupBuffer_u24lambda_u2d1 = bufferConfig;
        $i$a$-apply-BaseAudioPlayer$setupBuffer$1 = false;
        multiplier = 2;
        if ($this$setupBuffer_u24lambda_u2d1.getMinBuffer() == null) ** GOTO lbl-1000
        v0 = $this$setupBuffer_u24lambda_u2d1.getMinBuffer();
        if (v0 == null || v0 != 0) {
            v1 = $this$setupBuffer_u24lambda_u2d1.getMinBuffer();
        } else lbl-1000:
        // 2 sources

        {
            v1 = minBuffer = 50000;
        }
        if ($this$setupBuffer_u24lambda_u2d1.getMaxBuffer() == null) ** GOTO lbl-1000
        v2 = $this$setupBuffer_u24lambda_u2d1.getMaxBuffer();
        if (v2 == null || v2 != 0) {
            v3 = $this$setupBuffer_u24lambda_u2d1.getMaxBuffer();
        } else lbl-1000:
        // 2 sources

        {
            v3 = maxBuffer = 50000;
        }
        if ($this$setupBuffer_u24lambda_u2d1.getPlayBuffer() == null) ** GOTO lbl-1000
        v4 = $this$setupBuffer_u24lambda_u2d1.getPlayBuffer();
        if (v4 == null || v4 != 0) {
            v5 = $this$setupBuffer_u24lambda_u2d1.getPlayBuffer();
        } else lbl-1000:
        // 2 sources

        {
            v5 = playBuffer = 2500;
        }
        if ($this$setupBuffer_u24lambda_u2d1.getBackBuffer() == null) ** GOTO lbl-1000
        v6 = $this$setupBuffer_u24lambda_u2d1.getBackBuffer();
        if (v6 == null || v6 != 0) {
            v7 = $this$setupBuffer_u24lambda_u2d1.getBackBuffer();
        } else lbl-1000:
        // 2 sources

        {
            v7 = 0;
        }
        backBuffer = v7;
        v8 = new DefaultLoadControl.Builder().setBufferDurationsMs(minBuffer, maxBuffer, playBuffer, playBuffer * multiplier).setBackBuffer(backBuffer, false).build();
        Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"Builder()\n              \u2026\n                .build()");
        return v8;
    }

    public void load(@NotNull AudioItem item, boolean playWhenReady) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        MediaSource mediaSource = this.getMediaSourceFromAudioItem(item);
        this.exoPlayer.addMediaSource(mediaSource);
        this.exoPlayer.setPlayWhenReady(playWhenReady);
        this.exoPlayer.prepare();
    }

    public static /* synthetic */ void load$default(BaseAudioPlayer baseAudioPlayer, AudioItem audioItem, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: load");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        baseAudioPlayer.load(audioItem, bl);
    }

    public final void togglePlaying() {
        if (this.exoPlayer.isPlaying()) {
            this.exoPlayer.pause();
        } else {
            this.exoPlayer.play();
        }
    }

    public final void play() {
        this.exoPlayer.play();
    }

    public final void pause() {
        this.exoPlayer.pause();
    }

    public void stop() {
        this.exoPlayer.stop();
        this.exoPlayer.clearMediaItems();
    }

    @CallSuper
    public void destroy() {
        this.abandonAudioFocusIfHeld();
        this.stop();
        this.notificationManager.destroy$kotlin_audio_release();
        this.exoPlayer.release();
        SimpleCache simpleCache = this.cache;
        if (simpleCache != null) {
            simpleCache.release();
        }
        this.mediaSession.setActive(false);
    }

    public final void seek(long duration, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        long millis = TimeUnit.MILLISECONDS.convert(duration, unit);
        this.exoPlayer.seekTo(millis);
    }

    private final MediaItem getMediaItemFromAudioItem(AudioItem audioItem) {
        MediaItem mediaItem = new MediaItem.Builder().setUri(audioItem.getAudioUrl()).setTag((Object)audioItem).build();
        Intrinsics.checkNotNullExpressionValue((Object)mediaItem, (String)"Builder().setUri(audioIt\u2026setTag(audioItem).build()");
        return mediaItem;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    protected final MediaSource getMediaSourceFromAudioItem(@NotNull AudioItem audioItem) {
        Intrinsics.checkNotNullParameter((Object)audioItem, (String)"audioItem");
        factory = null;
        uri = Uri.parse((String)audioItem.getAudioUrl());
        mediaItem = this.getMediaItemFromAudioItem(audioItem);
        if (audioItem.getOptions() == null) ** GOTO lbl-1000
        v0 = audioItem.getOptions();
        Intrinsics.checkNotNull((Object)v0);
        var6_5 = v0.getUserAgent();
        if (var6_5 == null || StringsKt.isBlank((CharSequence)var6_5) != false) lbl-1000:
        // 2 sources

        {
            v1 = Util.getUserAgent((Context)this.context, (String)"react-native-track-player");
        } else {
            v2 = audioItem.getOptions();
            Intrinsics.checkNotNull((Object)v2);
            v1 = v2.getUserAgent();
        }
        userAgent = v1;
        v3 = audioItem.getOptions();
        if ((v3 != null ? v3.getResourceId() : null) != null) {
            raw = new RawResourceDataSource(this.context);
            raw.open(new DataSpec(uri));
            v4 = (DataSource.Factory)LambdaMetafactory.metafactory(null, null, null, ()Lcom/google/android/exoplayer2/upstream/DataSource;, getMediaSourceFromAudioItem$lambda-2(com.google.android.exoplayer2.upstream.RawResourceDataSource ), ()Lcom/google/android/exoplayer2/upstream/DataSource;)((RawResourceDataSource)raw);
        } else if (UtilsKt.isUriLocal(uri)) {
            v4 = (DataSource.Factory)new DefaultDataSourceFactory(this.context, userAgent);
        } else {
            $this$getMediaSourceFromAudioItem_u24lambda_u2d4 = var7_7 = new DefaultHttpDataSource.Factory();
            $i$a$-apply-BaseAudioPlayer$getMediaSourceFromAudioItem$tempFactory$1 = false;
            $this$getMediaSourceFromAudioItem_u24lambda_u2d4.setUserAgent(userAgent);
            $this$getMediaSourceFromAudioItem_u24lambda_u2d4.setAllowCrossProtocolRedirects(true);
            v5 = audioItem.getOptions();
            if (v5 != null && (v5 = v5.getHeaders()) != null) {
                it = v5;
                $i$a$-let-BaseAudioPlayer$getMediaSourceFromAudioItem$tempFactory$1$1 = false;
                $this$getMediaSourceFromAudioItem_u24lambda_u2d4.setDefaultRequestProperties(MapsKt.toMap((Map)it));
            }
            tempFactory = var7_7;
            v4 = this.enableCaching((DataSource.Factory)tempFactory);
        }
        factory = v4;
        switch (WhenMappings.$EnumSwitchMapping$0[audioItem.getType().ordinal()]) {
            case 1: {
                v6 = this.createDashSource(mediaItem, factory);
                break;
            }
            case 2: {
                v6 = this.createHlsSource(mediaItem, factory);
                break;
            }
            case 3: {
                v6 = this.createSsSource(mediaItem, factory);
                break;
            }
            default: {
                v6 = (MediaSource)this.createProgressiveSource(mediaItem, factory);
            }
        }
        return v6;
    }

    private final MediaSource createDashSource(MediaItem mediaItem, DataSource.Factory factory) {
        DataSource.Factory factory2 = factory;
        Intrinsics.checkNotNull((Object)factory2);
        DashMediaSource dashMediaSource = new DashMediaSource.Factory((DashChunkSource.Factory)new DefaultDashChunkSource.Factory(factory2), factory).createMediaSource(mediaItem);
        Intrinsics.checkNotNullExpressionValue((Object)dashMediaSource, (String)"Factory(DefaultDashChunk\u2026ateMediaSource(mediaItem)");
        return (MediaSource)dashMediaSource;
    }

    private final MediaSource createHlsSource(MediaItem mediaItem, DataSource.Factory factory) {
        DataSource.Factory factory2 = factory;
        Intrinsics.checkNotNull((Object)factory2);
        HlsMediaSource hlsMediaSource = new HlsMediaSource.Factory(factory2).createMediaSource(mediaItem);
        Intrinsics.checkNotNullExpressionValue((Object)hlsMediaSource, (String)"Factory(factory!!)\n     \u2026ateMediaSource(mediaItem)");
        return (MediaSource)hlsMediaSource;
    }

    private final MediaSource createSsSource(MediaItem mediaItem, DataSource.Factory factory) {
        DataSource.Factory factory2 = factory;
        Intrinsics.checkNotNull((Object)factory2);
        SsMediaSource ssMediaSource = new SsMediaSource.Factory((SsChunkSource.Factory)new DefaultSsChunkSource.Factory(factory2), factory).createMediaSource(mediaItem);
        Intrinsics.checkNotNullExpressionValue((Object)ssMediaSource, (String)"Factory(DefaultSsChunkSo\u2026ateMediaSource(mediaItem)");
        return (MediaSource)ssMediaSource;
    }

    private final ProgressiveMediaSource createProgressiveSource(MediaItem mediaItem, DataSource.Factory factory) {
        ProgressiveMediaSource progressiveMediaSource = new ProgressiveMediaSource.Factory(factory, (ExtractorsFactory)new DefaultExtractorsFactory().setConstantBitrateSeekingEnabled(true)).createMediaSource(mediaItem);
        Intrinsics.checkNotNullExpressionValue((Object)progressiveMediaSource, (String)"Factory(\n            fac\u2026ateMediaSource(mediaItem)");
        return progressiveMediaSource;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final DataSource.Factory enableCaching(DataSource.Factory factory) {
        DataSource.Factory factory2;
        if (this.cache != null && this.cacheConfig != null) {
            Long l = this.cacheConfig.getMaxCacheSize();
            if ((l != null ? l : 0L) > 0L) {
                CacheDataSource.Factory factory3;
                CacheDataSource.Factory $this$enableCaching_u24lambda_u2d5 = factory3 = new CacheDataSource.Factory();
                boolean bl = false;
                SimpleCache simpleCache = this.cache;
                Intrinsics.checkNotNull((Object)simpleCache);
                $this$enableCaching_u24lambda_u2d5.setCache((Cache)simpleCache);
                $this$enableCaching_u24lambda_u2d5.setUpstreamDataSourceFactory(factory);
                $this$enableCaching_u24lambda_u2d5.setFlags(2);
                factory2 = (DataSource.Factory)factory3;
                return factory2;
            }
        }
        factory2 = factory;
        return factory2;
    }

    private final void requestAudioFocus() {
        int n;
        if (this.hasAudioFocus) {
            return;
        }
        Timber.Forest.d("Requesting audio focus...", new Object[0]);
        AudioManager manager = (AudioManager)ContextCompat.getSystemService((Context)this.context, AudioManager.class);
        this.focus = new AudioFocusRequestCompat.Builder(1).setOnAudioFocusChangeListener((AudioManager.OnAudioFocusChangeListener)this).setAudioAttributes(new AudioAttributesCompat.Builder().setUsage(1).setContentType(2).build()).setWillPauseWhenDucked(this.getPlayerOptions().getAlwaysPauseOnInterruption()).build();
        if (manager != null && this.focus != null) {
            AudioFocusRequestCompat audioFocusRequestCompat = this.focus;
            Intrinsics.checkNotNull((Object)audioFocusRequestCompat);
            n = AudioManagerCompat.requestAudioFocus((AudioManager)manager, (AudioFocusRequestCompat)audioFocusRequestCompat);
        } else {
            n = 0;
        }
        int result = n;
        this.hasAudioFocus = result == 1;
    }

    private final void abandonAudioFocusIfHeld() {
        int n;
        if (!this.hasAudioFocus) {
            return;
        }
        Timber.Forest.d("Abandoning audio focus...", new Object[0]);
        AudioManager manager = (AudioManager)ContextCompat.getSystemService((Context)this.context, AudioManager.class);
        if (manager != null && this.focus != null) {
            AudioFocusRequestCompat audioFocusRequestCompat = this.focus;
            Intrinsics.checkNotNull((Object)audioFocusRequestCompat);
            n = AudioManagerCompat.abandonAudioFocusRequest((AudioManager)manager, (AudioFocusRequestCompat)audioFocusRequestCompat);
        } else {
            n = 0;
        }
        int result = n;
        this.hasAudioFocus = result != 1;
    }

    public void onAudioFocusChange(int focusChange) {
        Timber.Forest.d("Audio focus changed", new Object[0]);
        boolean isPermanent = false;
        boolean isPaused = false;
        boolean isDucking = false;
        switch (focusChange) {
            case -1: {
                isPermanent = true;
                isPaused = true;
                this.abandonAudioFocusIfHeld();
                break;
            }
            case -2: {
                isPaused = true;
                break;
            }
            case -3: {
                if (this.getPlayerOptions().getAlwaysPauseOnInterruption()) {
                    isPaused = true;
                    break;
                }
                isDucking = true;
            }
        }
        if (isDucking) {
            this.setVolumeMultiplier(0.5f);
            this.wasDucking = true;
        } else if (this.wasDucking) {
            this.setVolumeMultiplier(1.0f);
            this.wasDucking = false;
        }
        this.playerEventHolder.updateOnAudioFocusChanged$kotlin_audio_release(isPaused, isPermanent);
    }

    private static final DataSource getMediaSourceFromAudioItem$lambda-2(RawResourceDataSource $raw) {
        Intrinsics.checkNotNullParameter((Object)$raw, (String)"$raw");
        return (DataSource)$raw;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/doublesymmetry/kotlinaudio/players/BaseAudioPlayer$Companion;", "", "()V", "APPLICATION_NAME", "", "kotlin-audio_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001a\u0010\u0007\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u000bH\u0016J \u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\u0015"}, d2={"Lcom/doublesymmetry/kotlinaudio/players/BaseAudioPlayer$PlayerListener;", "Lcom/google/android/exoplayer2/Player$Listener;", "(Lcom/doublesymmetry/kotlinaudio/players/BaseAudioPlayer;)V", "onIsPlayingChanged", "", "isPlaying", "", "onMediaItemTransition", "mediaItem", "Lcom/google/android/exoplayer2/MediaItem;", "reason", "", "onMetadata", "metadata", "Lcom/google/android/exoplayer2/metadata/Metadata;", "onPlaybackStateChanged", "playbackState", "onPositionDiscontinuity", "oldPosition", "Lcom/google/android/exoplayer2/Player$PositionInfo;", "newPosition", "kotlin-audio_release"})
    public final class PlayerListener
    implements Player.Listener {
        public void onMetadata(@NotNull com.google.android.exoplayer2.metadata.Metadata metadata) {
            block3: {
                PlaybackMetadata it;
                BaseAudioPlayer baseAudioPlayer;
                PlaybackMetadata playbackMetadata;
                Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
                PlaybackMetadata playbackMetadata2 = PlaybackMetadata.Companion.fromId3Metadata(metadata);
                if (playbackMetadata2 != null) {
                    playbackMetadata = playbackMetadata2;
                    baseAudioPlayer = BaseAudioPlayer.this;
                    it = playbackMetadata;
                    boolean bl = false;
                    baseAudioPlayer.playerEventHolder.updateOnPlaybackMetadata$kotlin_audio_release(it);
                }
                PlaybackMetadata playbackMetadata3 = PlaybackMetadata.Companion.fromIcy(metadata);
                if (playbackMetadata3 != null) {
                    playbackMetadata = playbackMetadata3;
                    baseAudioPlayer = BaseAudioPlayer.this;
                    it = playbackMetadata;
                    boolean bl = false;
                    baseAudioPlayer.playerEventHolder.updateOnPlaybackMetadata$kotlin_audio_release(it);
                }
                PlaybackMetadata playbackMetadata4 = PlaybackMetadata.Companion.fromVorbisComment(metadata);
                if (playbackMetadata4 != null) {
                    playbackMetadata = playbackMetadata4;
                    baseAudioPlayer = BaseAudioPlayer.this;
                    it = playbackMetadata;
                    boolean bl = false;
                    baseAudioPlayer.playerEventHolder.updateOnPlaybackMetadata$kotlin_audio_release(it);
                }
                PlaybackMetadata playbackMetadata5 = PlaybackMetadata.Companion.fromQuickTime(metadata);
                if (playbackMetadata5 == null) break block3;
                playbackMetadata = playbackMetadata5;
                baseAudioPlayer = BaseAudioPlayer.this;
                it = playbackMetadata;
                boolean bl = false;
                baseAudioPlayer.playerEventHolder.updateOnPlaybackMetadata$kotlin_audio_release(it);
            }
        }

        public void onPlaybackStateChanged(int playbackState) {
            AudioPlayerState audioPlayerState;
            switch (playbackState) {
                case 2: {
                    if (BaseAudioPlayer.this.getExoPlayer().getPlayWhenReady()) {
                        audioPlayerState = AudioPlayerState.BUFFERING;
                        break;
                    }
                    audioPlayerState = AudioPlayerState.LOADING;
                    break;
                }
                case 3: {
                    BaseAudioPlayer.this.requestAudioFocus();
                    audioPlayerState = AudioPlayerState.READY;
                    break;
                }
                case 1: {
                    BaseAudioPlayer.this.abandonAudioFocusIfHeld();
                    audioPlayerState = AudioPlayerState.IDLE;
                    break;
                }
                case 4: {
                    audioPlayerState = AudioPlayerState.ENDED;
                    break;
                }
                default: {
                    Timber.Forest.e("Unknown playback state: " + playbackState, new Object[0]);
                    audioPlayerState = AudioPlayerState.IDLE;
                }
            }
            BaseAudioPlayer.this.setPlayerState(audioPlayerState);
        }

        public void onPositionDiscontinuity(@NotNull Player.PositionInfo oldPosition, @NotNull Player.PositionInfo newPosition, int reason) {
            Intrinsics.checkNotNullParameter((Object)oldPosition, (String)"oldPosition");
            Intrinsics.checkNotNullParameter((Object)newPosition, (String)"newPosition");
            BaseAudioPlayer.this.oldPosition = oldPosition.positionMs;
            switch (reason) {
                case 0: {
                    BaseAudioPlayer.this.playerEventHolder.updatePositionChangedReason$kotlin_audio_release(new PositionChangedReason.AUTO(oldPosition.positionMs, newPosition.positionMs));
                    break;
                }
                case 1: {
                    BaseAudioPlayer.this.playerEventHolder.updatePositionChangedReason$kotlin_audio_release(new PositionChangedReason.SEEK(oldPosition.positionMs, newPosition.positionMs));
                    break;
                }
                case 2: {
                    BaseAudioPlayer.this.playerEventHolder.updatePositionChangedReason$kotlin_audio_release(new PositionChangedReason.SEEK_FAILED(oldPosition.positionMs, newPosition.positionMs));
                    break;
                }
                case 4: {
                    BaseAudioPlayer.this.playerEventHolder.updatePositionChangedReason$kotlin_audio_release(new PositionChangedReason.QUEUE_CHANGED(oldPosition.positionMs, newPosition.positionMs));
                    break;
                }
                case 3: {
                    BaseAudioPlayer.this.playerEventHolder.updatePositionChangedReason$kotlin_audio_release(new PositionChangedReason.SKIPPED_PERIOD(oldPosition.positionMs, newPosition.positionMs));
                    break;
                }
                case 5: {
                    BaseAudioPlayer.this.playerEventHolder.updatePositionChangedReason$kotlin_audio_release(new PositionChangedReason.UNKNOWN(oldPosition.positionMs, newPosition.positionMs));
                }
            }
        }

        public void onMediaItemTransition(@Nullable MediaItem mediaItem, int reason) {
            switch (reason) {
                case 1: {
                    BaseAudioPlayer.this.playerEventHolder.updateAudioItemTransition$kotlin_audio_release(new AudioItemTransitionReason.AUTO(BaseAudioPlayer.this.oldPosition));
                    break;
                }
                case 3: {
                    BaseAudioPlayer.this.playerEventHolder.updateAudioItemTransition$kotlin_audio_release(new AudioItemTransitionReason.QUEUE_CHANGED(BaseAudioPlayer.this.oldPosition));
                    break;
                }
                case 0: {
                    BaseAudioPlayer.this.playerEventHolder.updateAudioItemTransition$kotlin_audio_release(new AudioItemTransitionReason.REPEAT(BaseAudioPlayer.this.oldPosition));
                    break;
                }
                case 2: {
                    BaseAudioPlayer.this.playerEventHolder.updateAudioItemTransition$kotlin_audio_release(new AudioItemTransitionReason.SEEK_TO_ANOTHER_AUDIO_ITEM(BaseAudioPlayer.this.oldPosition));
                }
            }
            if (BaseAudioPlayer.this.getAutomaticallyUpdateNotificationMetadata()) {
                AudioItem audioItem = BaseAudioPlayer.this.getCurrentItem();
                AudioItem audioItem2 = BaseAudioPlayer.this.getCurrentItem();
                AudioItem audioItem3 = BaseAudioPlayer.this.getCurrentItem();
                BaseAudioPlayer.this.getNotificationManager().setNotificationMetadata(new NotificationMetadata(audioItem != null ? audioItem.getTitle() : null, audioItem2 != null ? audioItem2.getArtist() : null, audioItem3 != null ? audioItem3.getArtwork() : null));
            }
            BaseAudioPlayer.this.getMediaSessionConnector().setMediaMetadataProvider(arg_0 -> PlayerListener.onMediaItemTransition$lambda-5(BaseAudioPlayer.this, arg_0));
        }

        public void onIsPlayingChanged(boolean isPlaying) {
            if (BaseAudioPlayer.this.getExoPlayer().getPlaybackState() != 3) {
                return;
            }
            BaseAudioPlayer.this.setPlayerState(isPlaying ? AudioPlayerState.PLAYING : AudioPlayerState.PAUSED);
            BaseAudioPlayer.this.playerEventHolder.updateAudioPlayerState$kotlin_audio_release(isPlaying ? AudioPlayerState.PLAYING : AudioPlayerState.PAUSED);
        }

        private static final MediaMetadataCompat onMediaItemTransition$lambda-5(BaseAudioPlayer this$0, Player it) {
            MediaSource mediaSource;
            MediaSource mediaSource2;
            MediaSource mediaSource3;
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            AudioItem audioItem = this$0.getCurrentItem();
            if (audioItem != null) {
                AudioItem item = audioItem;
                boolean bl = false;
                mediaSource3 = this$0.getMediaSourceFromAudioItem(item);
            } else {
                mediaSource3 = null;
            }
            if ((mediaSource2 = (mediaSource = mediaSource3)) == null || (mediaSource2 = MediaSourceExtKt.getMediaMetadataCompat(mediaSource2)) == null) {
                MediaMetadataCompat mediaMetadataCompat = new MediaMetadataCompat.Builder().build();
                mediaSource2 = mediaMetadataCompat;
                Intrinsics.checkNotNullExpressionValue((Object)mediaMetadataCompat, (String)"Builder().build()");
            }
            return mediaSource2;
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MediaType.values().length];
            nArray[MediaType.DASH.ordinal()] = 1;
            nArray[MediaType.HLS.ordinal()] = 2;
            nArray[MediaType.SMOOTH_STREAMING.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

